/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ([
/* 0 */,
/* 1 */
/***/ ((module) => {

module.exports = require("@nestjs/common");

/***/ }),
/* 2 */
/***/ ((module) => {

module.exports = require("@nestjs/core");

/***/ }),
/* 3 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AppModule = void 0;
const tslib_1 = __webpack_require__(4);
const common_1 = __webpack_require__(1);
const app_controller_1 = __webpack_require__(5);
const app_service_1 = __webpack_require__(6);
const supabase_module_1 = __webpack_require__(9);
const mysql_module_1 = __webpack_require__(20);
const auth_module_1 = __webpack_require__(65);
const attachments_module_1 = __webpack_require__(81);
const clients_module_1 = __webpack_require__(90);
const companies_module_1 = __webpack_require__(93);
const financials_module_1 = __webpack_require__(96);
const leads_module_1 = __webpack_require__(99);
const monitorings_module_1 = __webpack_require__(102);
const proposals_module_1 = __webpack_require__(109);
const sales_module_1 = __webpack_require__(112);
const users_module_1 = __webpack_require__(115);
const config_1 = __webpack_require__(118);
let AppModule = class AppModule {
};
exports.AppModule = AppModule;
exports.AppModule = AppModule = tslib_1.__decorate([
    (0, common_1.Module)({
        imports: [
            config_1.ConfigModule.forRoot({ isGlobal: true }),
            supabase_module_1.SupabaseModule,
            mysql_module_1.MysqlModule,
            auth_module_1.AuthModule,
            attachments_module_1.AttachmentsModule,
            clients_module_1.ClientsModule,
            companies_module_1.CompaniesModule,
            financials_module_1.FinancialsModule,
            leads_module_1.LeadsModule,
            monitorings_module_1.MonitoringsModule,
            proposals_module_1.ProposalsModule,
            sales_module_1.SalesModule,
            users_module_1.UsersModule,
        ],
        controllers: [app_controller_1.AppController],
        providers: [app_service_1.AppService],
    })
], AppModule);


/***/ }),
/* 4 */
/***/ ((module) => {

module.exports = require("tslib");

/***/ }),
/* 5 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a, _b;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AppController = void 0;
const tslib_1 = __webpack_require__(4);
const common_1 = __webpack_require__(1);
const app_service_1 = __webpack_require__(6);
const mysql_service_1 = __webpack_require__(7);
let AppController = class AppController {
    constructor(appService, mysqlService) {
        this.appService = appService;
        this.mysqlService = mysqlService;
    }
    getData() {
        return this.appService.getData();
    }
    async testDB() {
        return await this.mysqlService.testConnection();
    }
};
exports.AppController = AppController;
tslib_1.__decorate([
    (0, common_1.Get)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], AppController.prototype, "getData", null);
tslib_1.__decorate([
    (0, common_1.Get)('health-mysql'),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", Promise)
], AppController.prototype, "testDB", null);
exports.AppController = AppController = tslib_1.__decorate([
    (0, common_1.Controller)(),
    tslib_1.__metadata("design:paramtypes", [typeof (_a = typeof app_service_1.AppService !== "undefined" && app_service_1.AppService) === "function" ? _a : Object, typeof (_b = typeof mysql_service_1.MysqlService !== "undefined" && mysql_service_1.MysqlService) === "function" ? _b : Object])
], AppController);


/***/ }),
/* 6 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AppService = void 0;
const tslib_1 = __webpack_require__(4);
const common_1 = __webpack_require__(1);
let AppService = class AppService {
    getData() {
        return { message: 'Hello API' };
    }
};
exports.AppService = AppService;
exports.AppService = AppService = tslib_1.__decorate([
    (0, common_1.Injectable)()
], AppService);


/***/ }),
/* 7 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var MysqlService_1;
var _a;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MysqlService = void 0;
const tslib_1 = __webpack_require__(4);
const common_1 = __webpack_require__(1);
const typeorm_1 = __webpack_require__(8);
let MysqlService = MysqlService_1 = class MysqlService {
    constructor(dataSource) {
        this.dataSource = dataSource;
        this.logger = new common_1.Logger(MysqlService_1.name);
    }
    async testConnection() {
        try {
            await this.dataSource.query('SELECT 1 + 1 AS result');
            this.logger.log('Database connected successfully!');
        }
        catch (error) {
            this.logger.error('Database connection failed', error);
        }
    }
};
exports.MysqlService = MysqlService;
exports.MysqlService = MysqlService = MysqlService_1 = tslib_1.__decorate([
    (0, common_1.Injectable)(),
    tslib_1.__metadata("design:paramtypes", [typeof (_a = typeof typeorm_1.DataSource !== "undefined" && typeorm_1.DataSource) === "function" ? _a : Object])
], MysqlService);


/***/ }),
/* 8 */
/***/ ((module) => {

module.exports = require("typeorm");

/***/ }),
/* 9 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SupabaseModule = void 0;
const tslib_1 = __webpack_require__(4);
const common_1 = __webpack_require__(1);
const supabase_service_1 = __webpack_require__(10);
let SupabaseModule = class SupabaseModule {
};
exports.SupabaseModule = SupabaseModule;
exports.SupabaseModule = SupabaseModule = tslib_1.__decorate([
    (0, common_1.Module)({
        exports: [supabase_service_1.SupabaseService],
        providers: [supabase_service_1.SupabaseService],
    })
], SupabaseModule);


/***/ }),
/* 10 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var SupabaseService_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SupabaseService = void 0;
const tslib_1 = __webpack_require__(4);
const utils_1 = __webpack_require__(11);
const common_1 = __webpack_require__(1);
const supabase_js_1 = __webpack_require__(19);
let SupabaseService = SupabaseService_1 = class SupabaseService {
    constructor() {
        this.logger = new common_1.Logger(SupabaseService_1.name);
        const cloudSupabaseUrl = process.env.CLOUD_SUPABASE_URL;
        const cloudSupabaseKey = process.env.CLOUD_SUPABASE_ANON_KEY;
        const cloudServiceRoleKey = process.env.CLOUD_SUPABASE_SERVICE_ROLE_KEY;
        if (!cloudSupabaseUrl || !cloudSupabaseKey || !cloudServiceRoleKey) {
            this.logger.error(utils_1.API_RESPONSE.ERROR.SUPABASE.CREDENTIALS.MESSAGE);
            throw new Error(utils_1.API_RESPONSE.ERROR.SUPABASE.CREDENTIALS.MESSAGE);
        }
        this.supabase = (0, supabase_js_1.createClient)(cloudSupabaseUrl, cloudSupabaseKey);
        this.supabaseAdmin = (0, supabase_js_1.createClient)(cloudSupabaseUrl, cloudServiceRoleKey, {
            auth: {
                autoRefreshToken: false,
                persistSession: false,
            },
        });
    }
    get client() {
        return this.supabase;
    }
    get clientAdmin() {
        return this.supabaseAdmin;
    }
};
exports.SupabaseService = SupabaseService;
exports.SupabaseService = SupabaseService = SupabaseService_1 = tslib_1.__decorate([
    (0, common_1.Injectable)(),
    tslib_1.__metadata("design:paramtypes", [])
], SupabaseService);


/***/ }),
/* 11 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
const tslib_1 = __webpack_require__(4);
tslib_1.__exportStar(__webpack_require__(12), exports);
tslib_1.__exportStar(__webpack_require__(13), exports);
tslib_1.__exportStar(__webpack_require__(14), exports);
tslib_1.__exportStar(__webpack_require__(15), exports);
tslib_1.__exportStar(__webpack_require__(16), exports);
tslib_1.__exportStar(__webpack_require__(17), exports);
tslib_1.__exportStar(__webpack_require__(18), exports);


/***/ }),
/* 12 */
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
;


/***/ }),
/* 13 */
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
;
;


/***/ }),
/* 14 */
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ALLOWED_CORS_ORIGINS = void 0;
exports.ALLOWED_CORS_ORIGINS = [
    'http://localhost:4200',
    'http://localhost:4201',
    'https://staging.example.com',
    'https://aca.crm.perlasindustrade.ph',
    'https://aca.crm.perlasindustrade.ph/**',
];


/***/ }),
/* 15 */
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.API_RESPONSE = void 0;
exports.API_RESPONSE = {
    SUCCESS: {
        SUPABASE: {
            INITIALIZE: {
                CODE: 200,
                MESSAGE: "Supabase initialized successfully.",
            },
            CREDENTIALS: {
                CODE: 200,
                MESSAGE: "Supabase credentials verified successfully.",
            },
        },
        MY_SQL: {
            INITIALIZE: {
                CODE: 200,
                MESSAGE: "MySQL connection established successfully.",
            },
            CREDENTIALS: {
                CODE: 200,
                MESSAGE: "MySQL credentials validated successfully.",
            },
        },
        AUTH: {
            SIGN_IN: {
                CODE: 200,
                MESSAGE: "User signed in successfully.",
            },
            SIGN_UP: {
                CODE: 200,
                MESSAGE: "User registered successfully.",
            },
            SIGN_OUT: {
                CODE: 200,
                MESSAGE: "User sign-out successfully.",
            },
            RESET_PASSWORD: {
                CODE: 200,
                MESSAGE: "Password reset request processed successfully.",
            },
            RESEND_CONFIRMATION_LINK: {
                CODE: 200,
                MESSAGE: "Confirmation link sent successfully.",
            },
        },
        ATTACHMENT: {
            CREATE: { CODE: 200, MESSAGE: "Attachment created successfully." },
            UPDATE: { CODE: 200, MESSAGE: "Attachment updated successfully." },
            GET_BY_ID: { CODE: 200, MESSAGE: "Attachment retrieved successfully." },
            GET_ALL: { CODE: 200, MESSAGE: "All attachments retrieved successfully." },
            DELETE: { CODE: 200, MESSAGE: "Attachment deleted successfully." },
        },
        CLIENTS: {
            CREATE: { CODE: 200, MESSAGE: "Client created successfully." },
            UPDATE: { CODE: 200, MESSAGE: "Client updated successfully." },
            GET_BY_ID: { CODE: 200, MESSAGE: "Client retrieved successfully." },
            GET_ALL: { CODE: 200, MESSAGE: "All clients retrieved successfully." },
            DELETE: { CODE: 200, MESSAGE: "Client deleted successfully." },
        },
        COMPANY: {
            CREATE: { CODE: 200, MESSAGE: "Company created successfully." },
            UPDATE: { CODE: 200, MESSAGE: "Company updated successfully." },
            GET_BY_ID: { CODE: 200, MESSAGE: "Company retrieved successfully." },
            GET_ALL: { CODE: 200, MESSAGE: "All companies retrieved successfully." },
            DELETE: { CODE: 200, MESSAGE: "Company deleted successfully." },
        },
        FINANCIALS: {
            CREATE: { CODE: 200, MESSAGE: "Financial record created successfully." },
            UPDATE: { CODE: 200, MESSAGE: "Financial record updated successfully." },
            GET_BY_ID: { CODE: 200, MESSAGE: "Financial record retrieved successfully." },
            GET_ALL: { CODE: 200, MESSAGE: "All financial records retrieved successfully." },
            DELETE: { CODE: 200, MESSAGE: "Financial record deleted successfully." },
        },
        LEADS: {
            CREATE: { CODE: 200, MESSAGE: "Lead created successfully." },
            UPDATE: { CODE: 200, MESSAGE: "Lead updated successfully." },
            GET_BY_ID: { CODE: 200, MESSAGE: "Lead retrieved successfully." },
            GET_ALL: { CODE: 200, MESSAGE: "All leads retrieved successfully." },
            DELETE: { CODE: 200, MESSAGE: "Lead deleted successfully." },
        },
        MONITORINGS: {
            CREATE: { CODE: 200, MESSAGE: "Monitoring created successfully." },
            UPDATE: { CODE: 200, MESSAGE: "Monitoring updated successfully." },
            GET_BY_ID: { CODE: 200, MESSAGE: "Monitoring retrieved successfully." },
            GET_ALL: { CODE: 200, MESSAGE: "All monitorings retrieved successfully." },
            DELETE: { CODE: 200, MESSAGE: "Monitoring deleted successfully." },
        },
        PROPOSALS: {
            CREATE: { CODE: 200, MESSAGE: "Proposal created successfully." },
            UPDATE: { CODE: 200, MESSAGE: "Proposal updated successfully." },
            GET_BY_ID: { CODE: 200, MESSAGE: "Proposal retrieved successfully." },
            GET_ALL: { CODE: 200, MESSAGE: "All proposals retrieved successfully." },
            DELETE: { CODE: 200, MESSAGE: "Proposal deleted successfully." },
        },
        PROPOSAL_ITEMS: {
            CREATE: { CODE: 200, MESSAGE: "Proposal item created successfully." },
            UPDATE: { CODE: 200, MESSAGE: "Proposal item updated successfully." },
            GET_BY_ID: { CODE: 200, MESSAGE: "Proposal item retrieved successfully." },
            GET_ALL: { CODE: 200, MESSAGE: "All proposal items retrieved successfully." },
            DELETE: { CODE: 200, MESSAGE: "Proposal item deleted successfully." },
        },
        PROPOSAL_ATTACHMENT: {
            CREATE: { CODE: 200, MESSAGE: "Proposal attachment created successfully." },
            UPDATE: { CODE: 200, MESSAGE: "Proposal attachment updated successfully." },
            GET_BY_ID: { CODE: 200, MESSAGE: "Proposal attachment retrieved successfully." },
            GET_ALL: { CODE: 200, MESSAGE: "All proposal attachments retrieved successfully." },
            DELETE: { CODE: 200, MESSAGE: "Proposal attachment deleted successfully." },
        },
        PROPOSAL_PRICING_SUMMARY: {
            CREATE: { CODE: 200, MESSAGE: "Proposal pricing summary created successfully." },
            UPDATE: { CODE: 200, MESSAGE: "Proposal pricing summary updated successfully." },
            GET_BY_ID: { CODE: 200, MESSAGE: "Proposal pricing summary retrieved successfully." },
            GET_ALL: { CODE: 200, MESSAGE: "All proposal pricing summaries retrieved successfully." },
            DELETE: { CODE: 200, MESSAGE: "Proposal pricing summary deleted successfully." },
        },
        SALES: {
            CREATE: { CODE: 200, MESSAGE: "Sale created successfully." },
            UPDATE: { CODE: 200, MESSAGE: "Sale updated successfully." },
            GET_BY_ID: { CODE: 200, MESSAGE: "Sale retrieved successfully." },
            GET_ALL: { CODE: 200, MESSAGE: "All sales retrieved successfully." },
            DELETE: { CODE: 200, MESSAGE: "Sale deleted successfully." },
        },
        SALES_ATTACHMENT: {
            CREATE: { CODE: 200, MESSAGE: "Sales attachment created successfully." },
            UPDATE: { CODE: 200, MESSAGE: "Sales attachment updated successfully." },
            GET_BY_ID: { CODE: 200, MESSAGE: "Sales attachment retrieved successfully." },
            GET_ALL: { CODE: 200, MESSAGE: "All sales attachments retrieved successfully." },
            DELETE: { CODE: 200, MESSAGE: "Sales attachment deleted successfully." },
        },
        USERS: {
            CREATE: { CODE: 200, MESSAGE: "User created successfully." },
            UPDATE: { CODE: 200, MESSAGE: "User updated successfully." },
            GET_BY_ID: { CODE: 200, MESSAGE: "User retrieved successfully." },
            GET_ALL: { CODE: 200, MESSAGE: "All users retrieved successfully." },
            DELETE: { CODE: 200, MESSAGE: "User deleted successfully." },
        },
        SYSTEM: {
            NOT_FOUND: { CODE: 404, MESSAGE: "Requested resource not found." },
            INTERNAL_SERVER_ERROR: { CODE: 500, MESSAGE: "Internal server error occurred." },
        }
    },
    ERROR: {
        SUPABASE: {
            INITIALIZE: {
                CODE: 500,
                MESSAGE: "Failed to initialize Supabase.",
            },
            CREDENTIALS: {
                CODE: 401,
                MESSAGE: "Invalid Supabase credentials.",
            },
        },
        MY_SQL: {
            INITIALIZE: {
                CODE: 500,
                MESSAGE: "Failed to connect to MySQL.",
            },
            CREDENTIALS: {
                CODE: 401,
                MESSAGE: "Invalid MySQL credentials.",
            },
        },
        AUTH: {
            SIGN_IN: {
                CODE: 401,
                MESSAGE: "Sign-in failed. Invalid credentials.",
            },
            SIGN_UP: {
                CODE: 400,
                MESSAGE: "Sign-up failed. Invalid data provided.",
            },
            SIGN_OUT: {
                CODE: 400,
                MESSAGE: "Sign-out failed.",
            },
            RESET_PASSWORD: {
                CODE: 400,
                MESSAGE: "Password reset failed.",
            },
            RESEND_CONFIRMATION_LINK: {
                CODE: 400,
                MESSAGE: "Failed to resend confirmation link.",
            },
            USER_EXISTS: {
                CODE: 400,
                MESSAGE: "User already exist.",
            },
            USER_NOT_FOUND: {
                CODE: 404,
                MESSAGE: "User not found.",
            },
        },
        ATTACHMENT: {
            CREATE: { CODE: 400, MESSAGE: "Failed to create attachment." },
            UPDATE: { CODE: 400, MESSAGE: "Failed to update attachment." },
            GET_BY_ID: { CODE: 404, MESSAGE: "Attachment not found." },
            GET_ALL: { CODE: 500, MESSAGE: "Failed to retrieve attachments." },
            DELETE: { CODE: 400, MESSAGE: "Failed to delete attachment." },
        },
        CLIENTS: {
            CREATE: { CODE: 400, MESSAGE: "Failed to create client." },
            UPDATE: { CODE: 400, MESSAGE: "Failed to update client." },
            GET_BY_ID: { CODE: 404, MESSAGE: "Client not found." },
            GET_ALL: { CODE: 500, MESSAGE: "Failed to retrieve clients." },
            DELETE: { CODE: 400, MESSAGE: "Failed to delete client." },
        },
        COMPANY: {
            CREATE: { CODE: 400, MESSAGE: "Failed to create company." },
            UPDATE: { CODE: 400, MESSAGE: "Failed to update company." },
            GET_BY_ID: { CODE: 404, MESSAGE: "Company not found." },
            GET_ALL: { CODE: 500, MESSAGE: "Failed to retrieve companies." },
            DELETE: { CODE: 400, MESSAGE: "Failed to delete company." },
        },
        FINANCIALS: {
            CREATE: { CODE: 400, MESSAGE: "Failed to create financial record." },
            UPDATE: { CODE: 400, MESSAGE: "Failed to update financial record." },
            GET_BY_ID: { CODE: 404, MESSAGE: "Financial record not found." },
            GET_ALL: { CODE: 500, MESSAGE: "Failed to retrieve financial records." },
            DELETE: { CODE: 400, MESSAGE: "Failed to delete financial record." },
        },
        LEADS: {
            CREATE: { CODE: 400, MESSAGE: "Failed to create lead." },
            UPDATE: { CODE: 400, MESSAGE: "Failed to update lead." },
            GET_BY_ID: { CODE: 404, MESSAGE: "Lead not found." },
            GET_ALL: { CODE: 500, MESSAGE: "Failed to retrieve leads." },
            DELETE: { CODE: 400, MESSAGE: "Failed to delete lead." },
        },
        MONITORINGS: {
            CREATE: { CODE: 400, MESSAGE: "Failed to create monitoring." },
            UPDATE: { CODE: 400, MESSAGE: "Failed to update monitoring." },
            GET_BY_ID: { CODE: 404, MESSAGE: "Monitoring not found." },
            GET_ALL: { CODE: 500, MESSAGE: "Failed to retrieve monitorings." },
            DELETE: { CODE: 400, MESSAGE: "Failed to delete monitoring." },
        },
        PROPOSALS: {
            CREATE: { CODE: 400, MESSAGE: "Failed to create proposal." },
            UPDATE: { CODE: 400, MESSAGE: "Failed to update proposal." },
            GET_BY_ID: { CODE: 404, MESSAGE: "Proposal not found." },
            GET_ALL: { CODE: 500, MESSAGE: "Failed to retrieve proposals." },
            DELETE: { CODE: 400, MESSAGE: "Failed to delete proposal." },
        },
        PROPOSAL_ITEMS: {
            CREATE: { CODE: 400, MESSAGE: "Failed to create proposal item." },
            UPDATE: { CODE: 400, MESSAGE: "Failed to update proposal item." },
            GET_BY_ID: { CODE: 404, MESSAGE: "Proposal item not found." },
            GET_ALL: { CODE: 500, MESSAGE: "Failed to retrieve proposal items." },
            DELETE: { CODE: 400, MESSAGE: "Failed to delete proposal item." },
        },
        PROPOSAL_ATTACHMENT: {
            CREATE: { CODE: 400, MESSAGE: "Failed to create proposal attachment." },
            UPDATE: { CODE: 400, MESSAGE: "Failed to update proposal attachment." },
            GET_BY_ID: { CODE: 404, MESSAGE: "Proposal attachment not found." },
            GET_ALL: { CODE: 500, MESSAGE: "Failed to retrieve proposal attachments." },
            DELETE: { CODE: 400, MESSAGE: "Failed to delete proposal attachment." },
        },
        PROPOSAL_PRICING_SUMMARY: {
            CREATE: { CODE: 400, MESSAGE: "Failed to create proposal pricing summary." },
            UPDATE: { CODE: 400, MESSAGE: "Failed to update proposal pricing summary." },
            GET_BY_ID: { CODE: 404, MESSAGE: "Proposal pricing summary not found." },
            GET_ALL: { CODE: 500, MESSAGE: "Failed to retrieve proposal pricing summaries." },
            DELETE: { CODE: 400, MESSAGE: "Failed to delete proposal pricing summary." },
        },
        SALES: {
            CREATE: { CODE: 400, MESSAGE: "Failed to create sale." },
            UPDATE: { CODE: 400, MESSAGE: "Failed to update sale." },
            GET_BY_ID: { CODE: 404, MESSAGE: "Sale not found." },
            GET_ALL: { CODE: 500, MESSAGE: "Failed to retrieve sales." },
            DELETE: { CODE: 400, MESSAGE: "Failed to delete sale." },
        },
        SALES_ATTACHMENT: {
            CREATE: { CODE: 400, MESSAGE: "Failed to create sales attachment." },
            UPDATE: { CODE: 400, MESSAGE: "Failed to update sales attachment." },
            GET_BY_ID: { CODE: 404, MESSAGE: "Sales attachment not found." },
            GET_ALL: { CODE: 500, MESSAGE: "Failed to retrieve sales attachments." },
            DELETE: { CODE: 400, MESSAGE: "Failed to delete sales attachment." },
        },
        USERS: {
            CREATE: { CODE: 400, MESSAGE: "Failed to create user." },
            UPDATE: { CODE: 400, MESSAGE: "Failed to update user." },
            GET_BY_ID: { CODE: 404, MESSAGE: "User not found." },
            GET_ALL: { CODE: 500, MESSAGE: "Failed to retrieve users." },
            DELETE: { CODE: 400, MESSAGE: "Failed to delete user." },
        },
        SYSTEM: {
            NOT_FOUND: { CODE: 404, MESSAGE: "Requested system resource not found." },
            INTERNAL_SERVER_ERROR: { CODE: 500, MESSAGE: "Internal system error occurred." },
        }
    }
};


/***/ }),
/* 16 */
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CategoryTypes = exports.FormMode = exports.VatType = exports.Brand = exports.ProductCategory = exports.Industry = void 0;
var Industry;
(function (Industry) {
    Industry["AGRICULTURE"] = "Agriculture";
    Industry["AUTOMOTIVE"] = "Automotive";
    Industry["AVIATION_AIRLINES"] = "Aviation / Airlines";
    Industry["CHEMICALS"] = "Chemical";
    Industry["CONSTRUCTION"] = "Construction";
    Industry["ENERGY_POWER"] = "Energy / Power";
    Industry["ENGINEERING_SERVICES"] = "Engineering Services";
    Industry["ENVIRONMENTAL_WASTE_MANAGEMENT"] = "Environmental Waste Management";
    Industry["FOOD_BEV"] = "Food and Beverage";
    Industry["GOVERNMENT"] = "Government";
    Industry["HEALTHCARE_MEDICAL"] = "Healthcare / Medical";
    Industry["HOSPITALITY"] = "Hospitality (Hotel / Resort / Casino)";
    Industry["INDUSTRIAL_MANUFACTURING"] = "Industrial Manufacturing";
    Industry["LOGISTICS_SHIPPING_TRANSPORTATION"] = "Logistics / Shipping / Transportation";
    Industry["MARINE_SHIPYARD"] = "Marine / Shipyard";
    Industry["METAL_STEEL_FABRICATION"] = "Metals / Steel / Fabrication";
    Industry["MINING"] = "Mining";
    Industry["OIL_GAS_PETROCHEMICAL"] = "Oil & Gas / Petrochemical";
    Industry["PACKAGING"] = "Packaging";
    Industry["PAPER_PULP"] = "Paper / Pulp";
    Industry["PHARMACEUTICAL"] = "Pharmaceutical";
    Industry["PLASTICS"] = "Plastics";
    Industry["PRINTING_PUBLISHING"] = "Printing / Publishing";
    Industry["RETAIL_TRADE_IMPORTER"] = "Retail / Trading / Importer";
    Industry["SEMICONDUCTOR_ELECTRONICS"] = "Semiconductor / Electronics";
    Industry["UTILITIES"] = "Utilities (Water / Electric)";
    Industry["EDUCATION"] = "Education";
    Industry["REAL_ESTATE"] = "Real Estate / Property";
    Industry["SERVICES_GENERAL"] = "Services (General)";
    Industry["OTHER"] = "Other";
})(Industry || (exports.Industry = Industry = {}));
var ProductCategory;
(function (ProductCategory) {
    ProductCategory["SCADA_AUTOMATION"] = "Scada Automation";
    ProductCategory["PANEL_BUILDING"] = "Panel Building";
    ProductCategory["OT_SECURITY"] = "OT Security";
    ProductCategory["INSTRUMENTATION"] = "Instrumentation";
    ProductCategory["ELECTRICAL"] = "Electrical";
    ProductCategory["MECHANICAL"] = "Mechanical";
    ProductCategory["PNEUMATICS"] = "Pneumatics";
    ProductCategory["OTHER"] = "Other";
})(ProductCategory || (exports.ProductCategory = ProductCategory = {}));
var Brand;
(function (Brand) {
    Brand["AVEVA"] = "Aveva";
    Brand["SCHNEIDER"] = "Schneider";
    Brand["FORTINET"] = "Fortinet";
    Brand["YOKOGAWA"] = "Yokogawa";
    Brand["ALLEN_BRADLEY"] = "Allen-Bradley";
    Brand["CHARGE_UPS"] = "ChargeUPS";
    Brand["TURCK_BANNER"] = "Turck Banner";
    Brand["FESTO"] = "Festo";
    Brand["SIEMENS"] = "Siemens";
    Brand["FINETEK"] = "Finetek";
    Brand["OTHER"] = "Other";
})(Brand || (exports.Brand = Brand = {}));
var VatType;
(function (VatType) {
    VatType["EXCLUSIVE"] = "Exclusive";
    VatType["INCLUSIVE"] = "Inclusive";
    VatType["ZERO_RATED"] = "Zero - Rated";
})(VatType || (exports.VatType = VatType = {}));
var FormMode;
(function (FormMode) {
    FormMode["ADD"] = "add";
    FormMode["EDIT"] = "edit";
    FormMode["VIEW"] = "view";
})(FormMode || (exports.FormMode = FormMode = {}));
var CategoryTypes;
(function (CategoryTypes) {
    CategoryTypes["PROJECT"] = "Project";
    CategoryTypes["SUPPLIES"] = "Supplies";
})(CategoryTypes || (exports.CategoryTypes = CategoryTypes = {}));


/***/ }),
/* 17 */
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.prepareUpdateFields = void 0;
const prepareUpdateFields = (dto, relationMap) => {
    const fields = {};
    Object.entries(dto).forEach(([key, value]) => {
        if (value !== undefined && key !== 'id') {
            if (relationMap && relationMap[key]) {
                // Map to relation entity for TypeORM
                fields[relationMap[key]] = { id: value };
            }
            else {
                // normal field
                const column = key.replace(/[A-Z]/g, letter => `_${letter.toLowerCase()}`);
                fields[column] = value;
            }
        }
    });
    return fields;
};
exports.prepareUpdateFields = prepareUpdateFields;


/***/ }),
/* 18 */
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.toMiniUser = toMiniUser;
function toMiniUser(user) {
    if (!user)
        return null;
    return {
        id: user.id,
        email: user.email,
        role: user.role,
        first_name: user.first_name ?? null,
        last_name: user.last_name ?? null,
        phone_number: user.phone_number ?? null,
        position: user.position,
    };
}


/***/ }),
/* 19 */
/***/ ((module) => {

module.exports = require("@supabase/supabase-js");

/***/ }),
/* 20 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MysqlModule = void 0;
const tslib_1 = __webpack_require__(4);
const common_1 = __webpack_require__(1);
const mysql_service_1 = __webpack_require__(7);
const typeorm_1 = __webpack_require__(21);
const dto_1 = __webpack_require__(22);
let MysqlModule = class MysqlModule {
};
exports.MysqlModule = MysqlModule;
exports.MysqlModule = MysqlModule = tslib_1.__decorate([
    (0, common_1.Module)({
        imports: [
            typeorm_1.TypeOrmModule.forRoot({
                type: 'mysql',
                host: process.env.DB_HOST,
                port: parseInt(process.env.DB_PORT || '3306'),
                username: process.env.DB_USER,
                password: process.env.DB_PASSWORD,
                database: process.env.DB_NAME,
                entities: [__dirname + '/../**/*.entity{.ts,.js}'],
                synchronize: false,
                autoLoadEntities: true,
                connectTimeout: 10000,
                retryAttempts: 5,
                retryDelay: 3000,
            }),
            typeorm_1.TypeOrmModule.forFeature([
                dto_1.AttachmentsEntity,
                dto_1.ClientsEntity,
                dto_1.CompanyEntity,
                dto_1.FinancialsEntity,
                dto_1.LeadsEntity,
                dto_1.MonitoringsEntity,
                dto_1.MonitoringAttachmentsEntity,
                dto_1.ProposalsEntity,
                dto_1.ProposalItemsEntity,
                dto_1.ProposalAttachmentsEntity,
                dto_1.ProposalPricingSummaryEntity,
                dto_1.SalesEntity,
                dto_1.SaleAttachmentsEntity,
                dto_1.UsersEntity,
            ]),
        ],
        exports: [mysql_service_1.MysqlService],
        providers: [mysql_service_1.MysqlService],
    })
], MysqlModule);


/***/ }),
/* 21 */
/***/ ((module) => {

module.exports = require("@nestjs/typeorm");

/***/ }),
/* 22 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
const tslib_1 = __webpack_require__(4);
tslib_1.__exportStar(__webpack_require__(23), exports);
tslib_1.__exportStar(__webpack_require__(27), exports);
tslib_1.__exportStar(__webpack_require__(28), exports);
tslib_1.__exportStar(__webpack_require__(29), exports);
tslib_1.__exportStar(__webpack_require__(30), exports);
tslib_1.__exportStar(__webpack_require__(32), exports);
tslib_1.__exportStar(__webpack_require__(38), exports);
tslib_1.__exportStar(__webpack_require__(41), exports);
tslib_1.__exportStar(__webpack_require__(36), exports);
tslib_1.__exportStar(__webpack_require__(40), exports);
tslib_1.__exportStar(__webpack_require__(42), exports);
tslib_1.__exportStar(__webpack_require__(43), exports);
tslib_1.__exportStar(__webpack_require__(45), exports);
tslib_1.__exportStar(__webpack_require__(46), exports);
tslib_1.__exportStar(__webpack_require__(47), exports);
tslib_1.__exportStar(__webpack_require__(49), exports);
tslib_1.__exportStar(__webpack_require__(50), exports);
tslib_1.__exportStar(__webpack_require__(51), exports);
tslib_1.__exportStar(__webpack_require__(55), exports);
tslib_1.__exportStar(__webpack_require__(58), exports);
tslib_1.__exportStar(__webpack_require__(53), exports);
tslib_1.__exportStar(__webpack_require__(56), exports);
tslib_1.__exportStar(__webpack_require__(57), exports);
tslib_1.__exportStar(__webpack_require__(59), exports);
tslib_1.__exportStar(__webpack_require__(60), exports);
tslib_1.__exportStar(__webpack_require__(62), exports);
tslib_1.__exportStar(__webpack_require__(63), exports);
tslib_1.__exportStar(__webpack_require__(34), exports);
tslib_1.__exportStar(__webpack_require__(39), exports);
tslib_1.__exportStar(__webpack_require__(64), exports);
tslib_1.__exportStar(__webpack_require__(31), exports);


/***/ }),
/* 23 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AttachmentsDto = void 0;
const tslib_1 = __webpack_require__(4);
const class_validator_1 = __webpack_require__(24);
const class_transformer_1 = __webpack_require__(25);
const attachments_response_interface_1 = __webpack_require__(26);
class AttachmentsDto {
}
exports.AttachmentsDto = AttachmentsDto;
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], AttachmentsDto.prototype, "id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], AttachmentsDto.prototype, "bucket_name", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], AttachmentsDto.prototype, "storage_path", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], AttachmentsDto.prototype, "public_url", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], AttachmentsDto.prototype, "file_type", void 0);
tslib_1.__decorate([
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], AttachmentsDto.prototype, "file_size", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], AttachmentsDto.prototype, "file_name", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(attachments_response_interface_1.AttachmentsStatus),
    tslib_1.__metadata("design:type", typeof (_a = typeof attachments_response_interface_1.AttachmentsStatus !== "undefined" && attachments_response_interface_1.AttachmentsStatus) === "function" ? _a : Object)
], AttachmentsDto.prototype, "status", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsDateString)(),
    tslib_1.__metadata("design:type", String)
], AttachmentsDto.prototype, "created_at", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsDateString)(),
    tslib_1.__metadata("design:type", String)
], AttachmentsDto.prototype, "updated_at", void 0);


/***/ }),
/* 24 */
/***/ ((module) => {

module.exports = require("class-validator");

/***/ }),
/* 25 */
/***/ ((module) => {

module.exports = require("class-transformer");

/***/ }),
/* 26 */
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AttachmentsStatus = void 0;
var AttachmentsStatus;
(function (AttachmentsStatus) {
    AttachmentsStatus["ACTIVE"] = "ACTIVE";
    AttachmentsStatus["DELETED"] = "DELETED";
})(AttachmentsStatus || (exports.AttachmentsStatus = AttachmentsStatus = {}));


/***/ }),
/* 27 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a, _b;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UpdateAttachmentsDto = exports.CreateAttachmentsDto = void 0;
const tslib_1 = __webpack_require__(4);
const class_validator_1 = __webpack_require__(24);
const attachments_response_interface_1 = __webpack_require__(26);
class CreateAttachmentsDto {
}
exports.CreateAttachmentsDto = CreateAttachmentsDto;
tslib_1.__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    tslib_1.__metadata("design:type", String)
], CreateAttachmentsDto.prototype, "bucket_name", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    tslib_1.__metadata("design:type", String)
], CreateAttachmentsDto.prototype, "storage_path", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    tslib_1.__metadata("design:type", String)
], CreateAttachmentsDto.prototype, "public_url", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    tslib_1.__metadata("design:type", String)
], CreateAttachmentsDto.prototype, "file_type", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsNumber)(),
    tslib_1.__metadata("design:type", Number)
], CreateAttachmentsDto.prototype, "file_size", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    tslib_1.__metadata("design:type", String)
], CreateAttachmentsDto.prototype, "file_name", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(attachments_response_interface_1.AttachmentsStatus),
    tslib_1.__metadata("design:type", typeof (_a = typeof attachments_response_interface_1.AttachmentsStatus !== "undefined" && attachments_response_interface_1.AttachmentsStatus) === "function" ? _a : Object)
], CreateAttachmentsDto.prototype, "status", void 0);
class UpdateAttachmentsDto {
}
exports.UpdateAttachmentsDto = UpdateAttachmentsDto;
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    (0, class_validator_1.IsNotEmpty)(),
    tslib_1.__metadata("design:type", String)
], UpdateAttachmentsDto.prototype, "id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateAttachmentsDto.prototype, "bucket_name", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateAttachmentsDto.prototype, "storage_path", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateAttachmentsDto.prototype, "public_url", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateAttachmentsDto.prototype, "file_type", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    tslib_1.__metadata("design:type", Number)
], UpdateAttachmentsDto.prototype, "file_size", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateAttachmentsDto.prototype, "file_name", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEnum)(attachments_response_interface_1.AttachmentsStatus),
    tslib_1.__metadata("design:type", typeof (_b = typeof attachments_response_interface_1.AttachmentsStatus !== "undefined" && attachments_response_interface_1.AttachmentsStatus) === "function" ? _b : Object)
], UpdateAttachmentsDto.prototype, "status", void 0);


/***/ }),
/* 28 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a, _b, _c;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AttachmentsEntity = void 0;
const tslib_1 = __webpack_require__(4);
const typeorm_1 = __webpack_require__(8);
const attachments_response_interface_1 = __webpack_require__(26);
let AttachmentsEntity = class AttachmentsEntity {
};
exports.AttachmentsEntity = AttachmentsEntity;
tslib_1.__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)('uuid'),
    tslib_1.__metadata("design:type", String)
], AttachmentsEntity.prototype, "id", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)(),
    tslib_1.__metadata("design:type", String)
], AttachmentsEntity.prototype, "bucket_name", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)(),
    tslib_1.__metadata("design:type", String)
], AttachmentsEntity.prototype, "storage_path", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'text' }),
    tslib_1.__metadata("design:type", String)
], AttachmentsEntity.prototype, "public_url", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)(),
    tslib_1.__metadata("design:type", String)
], AttachmentsEntity.prototype, "file_type", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'int' }),
    tslib_1.__metadata("design:type", Number)
], AttachmentsEntity.prototype, "file_size", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)(),
    tslib_1.__metadata("design:type", String)
], AttachmentsEntity.prototype, "file_name", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'varchar' }),
    tslib_1.__metadata("design:type", typeof (_a = typeof attachments_response_interface_1.AttachmentsStatus !== "undefined" && attachments_response_interface_1.AttachmentsStatus) === "function" ? _a : Object)
], AttachmentsEntity.prototype, "status", void 0);
tslib_1.__decorate([
    (0, typeorm_1.CreateDateColumn)(),
    tslib_1.__metadata("design:type", typeof (_b = typeof Date !== "undefined" && Date) === "function" ? _b : Object)
], AttachmentsEntity.prototype, "created_at", void 0);
tslib_1.__decorate([
    (0, typeorm_1.UpdateDateColumn)(),
    tslib_1.__metadata("design:type", typeof (_c = typeof Date !== "undefined" && Date) === "function" ? _c : Object)
], AttachmentsEntity.prototype, "updated_at", void 0);
exports.AttachmentsEntity = AttachmentsEntity = tslib_1.__decorate([
    (0, typeorm_1.Entity)('attachments')
], AttachmentsEntity);


/***/ }),
/* 29 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SigninDto = void 0;
const tslib_1 = __webpack_require__(4);
const class_validator_1 = __webpack_require__(24);
class SigninDto {
}
exports.SigninDto = SigninDto;
tslib_1.__decorate([
    (0, class_validator_1.IsEmail)({}, { message: 'Email must be valid' }),
    tslib_1.__metadata("design:type", String)
], SigninDto.prototype, "email", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.MinLength)(8, { message: 'Password must be at least 8 characters' }),
    tslib_1.__metadata("design:type", String)
], SigninDto.prototype, "password", void 0);


/***/ }),
/* 30 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SignupDto = void 0;
const tslib_1 = __webpack_require__(4);
const class_validator_1 = __webpack_require__(24);
const match_string_decorator_1 = __webpack_require__(31);
class SignupDto {
}
exports.SignupDto = SignupDto;
tslib_1.__decorate([
    (0, class_validator_1.IsEmail)({}, { message: 'Email must be valid' }),
    tslib_1.__metadata("design:type", String)
], SignupDto.prototype, "email", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.MinLength)(8, { message: 'Password must be at least 8 characters' }),
    tslib_1.__metadata("design:type", String)
], SignupDto.prototype, "password", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsString)(),
    (0, match_string_decorator_1.MatchString)('password', { message: 'Passwords do not match' }),
    tslib_1.__metadata("design:type", String)
], SignupDto.prototype, "confirm_password", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], SignupDto.prototype, "redirectUrl", void 0);


/***/ }),
/* 31 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MatchString = MatchString;
const class_validator_1 = __webpack_require__(24);
function MatchString(property, validationOptions) {
    return (object, propertyName) => {
        (0, class_validator_1.registerDecorator)({
            name: 'match',
            target: object.constructor,
            propertyName: propertyName,
            options: validationOptions,
            constraints: [property],
            validator: {
                validate(value, args) {
                    const [relatedPropertyName] = args.constraints;
                    return value === args.object[relatedPropertyName];
                },
                defaultMessage(args) {
                    const [relatedPropertyName] = args.constraints;
                    return `${propertyName} must match ${relatedPropertyName}`;
                },
            },
        });
    };
}


/***/ }),
/* 32 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ClientsDto = void 0;
const tslib_1 = __webpack_require__(4);
const class_validator_1 = __webpack_require__(24);
const class_transformer_1 = __webpack_require__(25);
const clients_response_interface_1 = __webpack_require__(33);
const users_dto_1 = __webpack_require__(34);
const company_dto_1 = __webpack_require__(36);
class ClientsDto {
}
exports.ClientsDto = ClientsDto;
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], ClientsDto.prototype, "id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], ClientsDto.prototype, "contact_person", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], ClientsDto.prototype, "designation", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], ClientsDto.prototype, "contact_number", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEmail)(),
    tslib_1.__metadata("design:type", String)
], ClientsDto.prototype, "email", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(clients_response_interface_1.ClientStatus),
    tslib_1.__metadata("design:type", typeof (_a = typeof clients_response_interface_1.ClientStatus !== "undefined" && clients_response_interface_1.ClientStatus) === "function" ? _a : Object)
], ClientsDto.prototype, "status", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsDateString)(),
    tslib_1.__metadata("design:type", String)
], ClientsDto.prototype, "created_at", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsDateString)(),
    tslib_1.__metadata("design:type", String)
], ClientsDto.prototype, "updated_at", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => users_dto_1.MiniUsersDto),
    tslib_1.__metadata("design:type", typeof (_b = typeof users_dto_1.MiniUsersDto !== "undefined" && users_dto_1.MiniUsersDto) === "function" ? _b : Object)
], ClientsDto.prototype, "created_by", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => users_dto_1.MiniUsersDto),
    tslib_1.__metadata("design:type", typeof (_c = typeof users_dto_1.MiniUsersDto !== "undefined" && users_dto_1.MiniUsersDto) === "function" ? _c : Object)
], ClientsDto.prototype, "updated_by", void 0);
tslib_1.__decorate([
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => company_dto_1.CompanyDto),
    tslib_1.__metadata("design:type", typeof (_d = typeof company_dto_1.CompanyDto !== "undefined" && company_dto_1.CompanyDto) === "function" ? _d : Object)
], ClientsDto.prototype, "company", void 0);


/***/ }),
/* 33 */
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ClientStatus = void 0;
var ClientStatus;
(function (ClientStatus) {
    ClientStatus["ACTIVE"] = "active";
    ClientStatus["INACTIVE"] = "inactive";
    ClientStatus["PENDING"] = "pending";
    ClientStatus["APPROVED"] = "approved";
    ClientStatus["REJECTED"] = "rejected";
    ClientStatus["DELETED"] = "deleted";
})(ClientStatus || (exports.ClientStatus = ClientStatus = {}));


/***/ }),
/* 34 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a, _b, _c, _d, _e, _f, _g;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UsersDto = exports.MiniUsersDto = void 0;
const tslib_1 = __webpack_require__(4);
const class_validator_1 = __webpack_require__(24);
const class_transformer_1 = __webpack_require__(25);
const users_response_interface_1 = __webpack_require__(35);
const attachments_dto_1 = __webpack_require__(23);
class MiniUsersDto {
}
exports.MiniUsersDto = MiniUsersDto;
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], MiniUsersDto.prototype, "id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEmail)(),
    tslib_1.__metadata("design:type", String)
], MiniUsersDto.prototype, "email", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(users_response_interface_1.UserRole),
    tslib_1.__metadata("design:type", typeof (_a = typeof users_response_interface_1.UserRole !== "undefined" && users_response_interface_1.UserRole) === "function" ? _a : Object)
], MiniUsersDto.prototype, "role", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], MiniUsersDto.prototype, "first_name", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], MiniUsersDto.prototype, "last_name", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], MiniUsersDto.prototype, "phone_number", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(users_response_interface_1.UserPosition),
    tslib_1.__metadata("design:type", typeof (_b = typeof users_response_interface_1.UserPosition !== "undefined" && users_response_interface_1.UserPosition) === "function" ? _b : Object)
], MiniUsersDto.prototype, "position", void 0);
class UsersDto {
}
exports.UsersDto = UsersDto;
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], UsersDto.prototype, "id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEmail)(),
    tslib_1.__metadata("design:type", String)
], UsersDto.prototype, "email", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(users_response_interface_1.UserRole),
    tslib_1.__metadata("design:type", typeof (_c = typeof users_response_interface_1.UserRole !== "undefined" && users_response_interface_1.UserRole) === "function" ? _c : Object)
], UsersDto.prototype, "role", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UsersDto.prototype, "first_name", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UsersDto.prototype, "last_name", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UsersDto.prototype, "phone_number", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(users_response_interface_1.UserStatus),
    tslib_1.__metadata("design:type", typeof (_d = typeof users_response_interface_1.UserStatus !== "undefined" && users_response_interface_1.UserStatus) === "function" ? _d : Object)
], UsersDto.prototype, "status", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(users_response_interface_1.UserPosition),
    tslib_1.__metadata("design:type", typeof (_e = typeof users_response_interface_1.UserPosition !== "undefined" && users_response_interface_1.UserPosition) === "function" ? _e : Object)
], UsersDto.prototype, "position", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsDateString)(),
    tslib_1.__metadata("design:type", String)
], UsersDto.prototype, "created_at", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsDateString)(),
    tslib_1.__metadata("design:type", String)
], UsersDto.prototype, "updated_at", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => MiniUsersDto),
    tslib_1.__metadata("design:type", MiniUsersDto)
], UsersDto.prototype, "created_by", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => MiniUsersDto),
    tslib_1.__metadata("design:type", MiniUsersDto)
], UsersDto.prototype, "updated_by", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => attachments_dto_1.AttachmentsDto),
    tslib_1.__metadata("design:type", typeof (_f = typeof attachments_dto_1.AttachmentsDto !== "undefined" && attachments_dto_1.AttachmentsDto) === "function" ? _f : Object)
], UsersDto.prototype, "attachment_signature", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => attachments_dto_1.AttachmentsDto),
    tslib_1.__metadata("design:type", typeof (_g = typeof attachments_dto_1.AttachmentsDto !== "undefined" && attachments_dto_1.AttachmentsDto) === "function" ? _g : Object)
], UsersDto.prototype, "attachment_avatar", void 0);


/***/ }),
/* 35 */
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UserPosition = exports.UserRole = exports.UserStatus = void 0;
var UserStatus;
(function (UserStatus) {
    UserStatus["ACTIVE"] = "ACTIVE";
    UserStatus["INACTIVE"] = "INACTIVE";
    UserStatus["DELETED"] = "DELETED";
    UserStatus["PENDING"] = "PENDING";
    UserStatus["APPROVED"] = "APPROVED";
    UserStatus["REJECTED"] = "REJECTED";
})(UserStatus || (exports.UserStatus = UserStatus = {}));
var UserRole;
(function (UserRole) {
    UserRole["MANAGER"] = "MANAGER";
    UserRole["MANAGEMENT"] = "MANAGEMENT";
    UserRole["SUPERVISOR"] = "SUPERVISOR";
})(UserRole || (exports.UserRole = UserRole = {}));
var UserPosition;
(function (UserPosition) {
    UserPosition["INSIDE_SALES"] = "Inside Sales";
    UserPosition["ACCOUNT_MANAGER"] = "Account Manager";
    UserPosition["SENIOR_ACCOUNT_MANAGER"] = "Senior Account Manager";
    UserPosition["BUSINESS_UNIT_MANAGER"] = "Business Unit Manager";
    UserPosition["BUSINESS_DEVELOPMENT_MANAGER"] = "Business Development Manager";
    UserPosition["HEAD_OF_SALES"] = "Head of Sales";
    UserPosition["MANAGER_FOR_SALES_AND_OPERATION"] = "Manager for Sales and Operation";
})(UserPosition || (exports.UserPosition = UserPosition = {}));


/***/ }),
/* 36 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a, _b, _c, _d, _e, _f, _g;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CompanyDto = void 0;
const tslib_1 = __webpack_require__(4);
const class_validator_1 = __webpack_require__(24);
const class_transformer_1 = __webpack_require__(25);
const company_response_interface_1 = __webpack_require__(37);
const users_dto_1 = __webpack_require__(34);
const attachments_dto_1 = __webpack_require__(23);
const enums_utils_1 = __webpack_require__(16);
class CompanyDto {
}
exports.CompanyDto = CompanyDto;
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], CompanyDto.prototype, "id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CompanyDto.prototype, "company_name", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(enums_utils_1.Industry),
    tslib_1.__metadata("design:type", typeof (_a = typeof enums_utils_1.Industry !== "undefined" && enums_utils_1.Industry) === "function" ? _a : Object)
], CompanyDto.prototype, "industry", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(enums_utils_1.VatType),
    tslib_1.__metadata("design:type", typeof (_b = typeof enums_utils_1.VatType !== "undefined" && enums_utils_1.VatType) === "function" ? _b : Object)
], CompanyDto.prototype, "vat_type", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CompanyDto.prototype, "product_service", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CompanyDto.prototype, "payment_terms", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(company_response_interface_1.CompanyStatus),
    tslib_1.__metadata("design:type", typeof (_c = typeof company_response_interface_1.CompanyStatus !== "undefined" && company_response_interface_1.CompanyStatus) === "function" ? _c : Object)
], CompanyDto.prototype, "status", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CompanyDto.prototype, "address", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CompanyDto.prototype, "tin_number", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CompanyDto.prototype, "customer_code", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsDateString)(),
    tslib_1.__metadata("design:type", String)
], CompanyDto.prototype, "created_at", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsDateString)(),
    tslib_1.__metadata("design:type", String)
], CompanyDto.prototype, "updated_at", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => users_dto_1.MiniUsersDto),
    tslib_1.__metadata("design:type", typeof (_d = typeof users_dto_1.MiniUsersDto !== "undefined" && users_dto_1.MiniUsersDto) === "function" ? _d : Object)
], CompanyDto.prototype, "created_by", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => users_dto_1.MiniUsersDto),
    tslib_1.__metadata("design:type", typeof (_e = typeof users_dto_1.MiniUsersDto !== "undefined" && users_dto_1.MiniUsersDto) === "function" ? _e : Object)
], CompanyDto.prototype, "updated_by", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => attachments_dto_1.AttachmentsDto),
    tslib_1.__metadata("design:type", typeof (_f = typeof attachments_dto_1.AttachmentsDto !== "undefined" && attachments_dto_1.AttachmentsDto) === "function" ? _f : Object)
], CompanyDto.prototype, "attachment_company_logo", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => attachments_dto_1.AttachmentsDto),
    tslib_1.__metadata("design:type", typeof (_g = typeof attachments_dto_1.AttachmentsDto !== "undefined" && attachments_dto_1.AttachmentsDto) === "function" ? _g : Object)
], CompanyDto.prototype, "attachment_org_chart", void 0);


/***/ }),
/* 37 */
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CompanyStatus = void 0;
var CompanyStatus;
(function (CompanyStatus) {
    CompanyStatus["ACTIVE"] = "ACTIVE";
    CompanyStatus["INACTIVE"] = "INACTIVE";
    CompanyStatus["DELETED"] = "DELETED";
    CompanyStatus["PENDING"] = "PENDING";
})(CompanyStatus || (exports.CompanyStatus = CompanyStatus = {}));


/***/ }),
/* 38 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ClientsEntity = void 0;
const tslib_1 = __webpack_require__(4);
const typeorm_1 = __webpack_require__(8);
const clients_response_interface_1 = __webpack_require__(33);
const user_entity_1 = __webpack_require__(39);
const company_entity_1 = __webpack_require__(40);
let ClientsEntity = class ClientsEntity {
};
exports.ClientsEntity = ClientsEntity;
tslib_1.__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)('uuid'),
    tslib_1.__metadata("design:type", String)
], ClientsEntity.prototype, "id", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    tslib_1.__metadata("design:type", String)
], ClientsEntity.prototype, "contact_person", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    tslib_1.__metadata("design:type", String)
], ClientsEntity.prototype, "designation", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    tslib_1.__metadata("design:type", String)
], ClientsEntity.prototype, "contact_number", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    tslib_1.__metadata("design:type", String)
], ClientsEntity.prototype, "email", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'varchar' }),
    tslib_1.__metadata("design:type", typeof (_a = typeof clients_response_interface_1.ClientStatus !== "undefined" && clients_response_interface_1.ClientStatus) === "function" ? _a : Object)
], ClientsEntity.prototype, "status", void 0);
tslib_1.__decorate([
    (0, typeorm_1.CreateDateColumn)(),
    tslib_1.__metadata("design:type", typeof (_b = typeof Date !== "undefined" && Date) === "function" ? _b : Object)
], ClientsEntity.prototype, "created_at", void 0);
tslib_1.__decorate([
    (0, typeorm_1.UpdateDateColumn)(),
    tslib_1.__metadata("design:type", typeof (_c = typeof Date !== "undefined" && Date) === "function" ? _c : Object)
], ClientsEntity.prototype, "updated_at", void 0);
tslib_1.__decorate([
    (0, typeorm_1.ManyToOne)(() => user_entity_1.UsersEntity, { nullable: true }),
    (0, typeorm_1.JoinColumn)({ name: 'created_by_id' }),
    tslib_1.__metadata("design:type", typeof (_d = typeof user_entity_1.UsersEntity !== "undefined" && user_entity_1.UsersEntity) === "function" ? _d : Object)
], ClientsEntity.prototype, "created_by", void 0);
tslib_1.__decorate([
    (0, typeorm_1.ManyToOne)(() => user_entity_1.UsersEntity, { nullable: true }),
    (0, typeorm_1.JoinColumn)({ name: 'updated_by_id' }),
    tslib_1.__metadata("design:type", typeof (_e = typeof user_entity_1.UsersEntity !== "undefined" && user_entity_1.UsersEntity) === "function" ? _e : Object)
], ClientsEntity.prototype, "updated_by", void 0);
tslib_1.__decorate([
    (0, typeorm_1.ManyToOne)(() => company_entity_1.CompanyEntity, { nullable: false }),
    (0, typeorm_1.JoinColumn)({ name: 'company_id' }),
    tslib_1.__metadata("design:type", typeof (_f = typeof company_entity_1.CompanyEntity !== "undefined" && company_entity_1.CompanyEntity) === "function" ? _f : Object)
], ClientsEntity.prototype, "company", void 0);
exports.ClientsEntity = ClientsEntity = tslib_1.__decorate([
    (0, typeorm_1.Entity)('clients')
], ClientsEntity);


/***/ }),
/* 39 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a, _b, _c, _d, _e, _f, _g;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UsersEntity = void 0;
const tslib_1 = __webpack_require__(4);
const typeorm_1 = __webpack_require__(8);
const users_response_interface_1 = __webpack_require__(35);
const attachments_entity_1 = __webpack_require__(28);
let UsersEntity = class UsersEntity {
};
exports.UsersEntity = UsersEntity;
tslib_1.__decorate([
    (0, typeorm_1.PrimaryColumn)('uuid'),
    tslib_1.__metadata("design:type", String)
], UsersEntity.prototype, "id", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ unique: true }),
    tslib_1.__metadata("design:type", String)
], UsersEntity.prototype, "email", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'varchar' }),
    tslib_1.__metadata("design:type", typeof (_a = typeof users_response_interface_1.UserRole !== "undefined" && users_response_interface_1.UserRole) === "function" ? _a : Object)
], UsersEntity.prototype, "role", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'varchar' }),
    tslib_1.__metadata("design:type", typeof (_b = typeof users_response_interface_1.UserStatus !== "undefined" && users_response_interface_1.UserStatus) === "function" ? _b : Object)
], UsersEntity.prototype, "status", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'varchar' }),
    tslib_1.__metadata("design:type", typeof (_c = typeof users_response_interface_1.UserPosition !== "undefined" && users_response_interface_1.UserPosition) === "function" ? _c : Object)
], UsersEntity.prototype, "position", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    tslib_1.__metadata("design:type", String)
], UsersEntity.prototype, "first_name", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    tslib_1.__metadata("design:type", String)
], UsersEntity.prototype, "last_name", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    tslib_1.__metadata("design:type", String)
], UsersEntity.prototype, "phone_number", void 0);
tslib_1.__decorate([
    (0, typeorm_1.CreateDateColumn)(),
    tslib_1.__metadata("design:type", typeof (_d = typeof Date !== "undefined" && Date) === "function" ? _d : Object)
], UsersEntity.prototype, "created_at", void 0);
tslib_1.__decorate([
    (0, typeorm_1.UpdateDateColumn)(),
    tslib_1.__metadata("design:type", typeof (_e = typeof Date !== "undefined" && Date) === "function" ? _e : Object)
], UsersEntity.prototype, "updated_at", void 0);
tslib_1.__decorate([
    (0, typeorm_1.ManyToOne)(() => UsersEntity, { nullable: true }),
    (0, typeorm_1.JoinColumn)({ name: 'created_by' }),
    tslib_1.__metadata("design:type", UsersEntity)
], UsersEntity.prototype, "created_by", void 0);
tslib_1.__decorate([
    (0, typeorm_1.ManyToOne)(() => UsersEntity, { nullable: true }),
    (0, typeorm_1.JoinColumn)({ name: 'updated_by' }),
    tslib_1.__metadata("design:type", UsersEntity)
], UsersEntity.prototype, "updated_by", void 0);
tslib_1.__decorate([
    (0, typeorm_1.ManyToOne)(() => attachments_entity_1.AttachmentsEntity, { nullable: true }),
    (0, typeorm_1.JoinColumn)({ name: 'attachment_signature_id' }),
    tslib_1.__metadata("design:type", typeof (_f = typeof attachments_entity_1.AttachmentsEntity !== "undefined" && attachments_entity_1.AttachmentsEntity) === "function" ? _f : Object)
], UsersEntity.prototype, "attachment_signature", void 0);
tslib_1.__decorate([
    (0, typeorm_1.ManyToOne)(() => attachments_entity_1.AttachmentsEntity, { nullable: true }),
    (0, typeorm_1.JoinColumn)({ name: 'attachment_avatar_id' }),
    tslib_1.__metadata("design:type", typeof (_g = typeof attachments_entity_1.AttachmentsEntity !== "undefined" && attachments_entity_1.AttachmentsEntity) === "function" ? _g : Object)
], UsersEntity.prototype, "attachment_avatar", void 0);
exports.UsersEntity = UsersEntity = tslib_1.__decorate([
    (0, typeorm_1.Entity)('users')
], UsersEntity);


/***/ }),
/* 40 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a, _b, _c, _d, _e, _f, _g, _h, _j;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CompanyEntity = void 0;
const tslib_1 = __webpack_require__(4);
const typeorm_1 = __webpack_require__(8);
const enums_utils_1 = __webpack_require__(16);
const company_response_interface_1 = __webpack_require__(37);
const user_entity_1 = __webpack_require__(39);
const attachments_entity_1 = __webpack_require__(28);
let CompanyEntity = class CompanyEntity {
};
exports.CompanyEntity = CompanyEntity;
tslib_1.__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)('uuid'),
    tslib_1.__metadata("design:type", String)
], CompanyEntity.prototype, "id", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)(),
    tslib_1.__metadata("design:type", String)
], CompanyEntity.prototype, "company_name", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'varchar', nullable: true }),
    tslib_1.__metadata("design:type", typeof (_a = typeof enums_utils_1.Industry !== "undefined" && enums_utils_1.Industry) === "function" ? _a : Object)
], CompanyEntity.prototype, "industry", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'varchar' }),
    tslib_1.__metadata("design:type", typeof (_b = typeof enums_utils_1.VatType !== "undefined" && enums_utils_1.VatType) === "function" ? _b : Object)
], CompanyEntity.prototype, "vat_type", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ nullable: true, type: 'text' }),
    tslib_1.__metadata("design:type", String)
], CompanyEntity.prototype, "product_service", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    tslib_1.__metadata("design:type", String)
], CompanyEntity.prototype, "payment_terms", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'varchar' }),
    tslib_1.__metadata("design:type", typeof (_c = typeof company_response_interface_1.CompanyStatus !== "undefined" && company_response_interface_1.CompanyStatus) === "function" ? _c : Object)
], CompanyEntity.prototype, "status", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ nullable: true, type: 'text' }),
    tslib_1.__metadata("design:type", String)
], CompanyEntity.prototype, "address", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    tslib_1.__metadata("design:type", String)
], CompanyEntity.prototype, "tin_number", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ length: 100 }),
    tslib_1.__metadata("design:type", String)
], CompanyEntity.prototype, "customer_code", void 0);
tslib_1.__decorate([
    (0, typeorm_1.CreateDateColumn)(),
    tslib_1.__metadata("design:type", typeof (_d = typeof Date !== "undefined" && Date) === "function" ? _d : Object)
], CompanyEntity.prototype, "created_at", void 0);
tslib_1.__decorate([
    (0, typeorm_1.UpdateDateColumn)(),
    tslib_1.__metadata("design:type", typeof (_e = typeof Date !== "undefined" && Date) === "function" ? _e : Object)
], CompanyEntity.prototype, "updated_at", void 0);
tslib_1.__decorate([
    (0, typeorm_1.ManyToOne)(() => user_entity_1.UsersEntity, { nullable: true }),
    (0, typeorm_1.JoinColumn)({ name: 'created_by_id' }),
    tslib_1.__metadata("design:type", typeof (_f = typeof user_entity_1.UsersEntity !== "undefined" && user_entity_1.UsersEntity) === "function" ? _f : Object)
], CompanyEntity.prototype, "created_by", void 0);
tslib_1.__decorate([
    (0, typeorm_1.ManyToOne)(() => user_entity_1.UsersEntity, { nullable: true }),
    (0, typeorm_1.JoinColumn)({ name: 'updated_by_id' }),
    tslib_1.__metadata("design:type", typeof (_g = typeof user_entity_1.UsersEntity !== "undefined" && user_entity_1.UsersEntity) === "function" ? _g : Object)
], CompanyEntity.prototype, "updated_by", void 0);
tslib_1.__decorate([
    (0, typeorm_1.ManyToOne)(() => attachments_entity_1.AttachmentsEntity, { nullable: true }),
    (0, typeorm_1.JoinColumn)({ name: 'attachment_company_logo_id' }),
    tslib_1.__metadata("design:type", typeof (_h = typeof attachments_entity_1.AttachmentsEntity !== "undefined" && attachments_entity_1.AttachmentsEntity) === "function" ? _h : Object)
], CompanyEntity.prototype, "attachment_company_logo", void 0);
tslib_1.__decorate([
    (0, typeorm_1.ManyToOne)(() => attachments_entity_1.AttachmentsEntity, { nullable: true }),
    (0, typeorm_1.JoinColumn)({ name: 'attachment_org_chart_id' }),
    tslib_1.__metadata("design:type", typeof (_j = typeof attachments_entity_1.AttachmentsEntity !== "undefined" && attachments_entity_1.AttachmentsEntity) === "function" ? _j : Object)
], CompanyEntity.prototype, "attachment_org_chart", void 0);
exports.CompanyEntity = CompanyEntity = tslib_1.__decorate([
    (0, typeorm_1.Entity)('companies')
], CompanyEntity);


/***/ }),
/* 41 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a, _b;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UpdateClientsDto = exports.CreateClientsDto = void 0;
const tslib_1 = __webpack_require__(4);
const class_validator_1 = __webpack_require__(24);
const clients_response_interface_1 = __webpack_require__(33);
class CreateClientsDto {
}
exports.CreateClientsDto = CreateClientsDto;
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CreateClientsDto.prototype, "contact_person", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CreateClientsDto.prototype, "designation", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CreateClientsDto.prototype, "contact_number", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEmail)(),
    tslib_1.__metadata("design:type", String)
], CreateClientsDto.prototype, "email", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(clients_response_interface_1.ClientStatus),
    tslib_1.__metadata("design:type", typeof (_a = typeof clients_response_interface_1.ClientStatus !== "undefined" && clients_response_interface_1.ClientStatus) === "function" ? _a : Object)
], CreateClientsDto.prototype, "status", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], CreateClientsDto.prototype, "created_by_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], CreateClientsDto.prototype, "updated_by_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], CreateClientsDto.prototype, "company_id", void 0);
class UpdateClientsDto {
}
exports.UpdateClientsDto = UpdateClientsDto;
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], UpdateClientsDto.prototype, "id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateClientsDto.prototype, "contact_person", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateClientsDto.prototype, "designation", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateClientsDto.prototype, "contact_number", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEmail)(),
    tslib_1.__metadata("design:type", String)
], UpdateClientsDto.prototype, "email", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEnum)(clients_response_interface_1.ClientStatus),
    tslib_1.__metadata("design:type", typeof (_b = typeof clients_response_interface_1.ClientStatus !== "undefined" && clients_response_interface_1.ClientStatus) === "function" ? _b : Object)
], UpdateClientsDto.prototype, "status", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], UpdateClientsDto.prototype, "updated_by_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], UpdateClientsDto.prototype, "company_id", void 0);


/***/ }),
/* 42 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UpdateCompanyDto = exports.CreateCompanyDto = void 0;
const tslib_1 = __webpack_require__(4);
const class_validator_1 = __webpack_require__(24);
const enums_utils_1 = __webpack_require__(16);
const company_response_interface_1 = __webpack_require__(37);
class CreateCompanyDto {
}
exports.CreateCompanyDto = CreateCompanyDto;
tslib_1.__decorate([
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CreateCompanyDto.prototype, "company_name", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(enums_utils_1.Industry),
    tslib_1.__metadata("design:type", typeof (_a = typeof enums_utils_1.Industry !== "undefined" && enums_utils_1.Industry) === "function" ? _a : Object)
], CreateCompanyDto.prototype, "industry", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(enums_utils_1.VatType),
    tslib_1.__metadata("design:type", typeof (_b = typeof enums_utils_1.VatType !== "undefined" && enums_utils_1.VatType) === "function" ? _b : Object)
], CreateCompanyDto.prototype, "vat_type", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CreateCompanyDto.prototype, "product_service", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CreateCompanyDto.prototype, "payment_terms", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(company_response_interface_1.CompanyStatus),
    tslib_1.__metadata("design:type", typeof (_c = typeof company_response_interface_1.CompanyStatus !== "undefined" && company_response_interface_1.CompanyStatus) === "function" ? _c : Object)
], CreateCompanyDto.prototype, "status", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CreateCompanyDto.prototype, "address", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CreateCompanyDto.prototype, "tin_number", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CreateCompanyDto.prototype, "customer_code", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], CreateCompanyDto.prototype, "created_by_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], CreateCompanyDto.prototype, "updated_by_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], CreateCompanyDto.prototype, "attachment_company_logo_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], CreateCompanyDto.prototype, "attachment_org_chart_id", void 0);
class UpdateCompanyDto {
}
exports.UpdateCompanyDto = UpdateCompanyDto;
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], UpdateCompanyDto.prototype, "id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateCompanyDto.prototype, "company_name", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEnum)(enums_utils_1.Industry),
    tslib_1.__metadata("design:type", typeof (_d = typeof enums_utils_1.Industry !== "undefined" && enums_utils_1.Industry) === "function" ? _d : Object)
], UpdateCompanyDto.prototype, "industry", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEnum)(enums_utils_1.VatType),
    tslib_1.__metadata("design:type", typeof (_e = typeof enums_utils_1.VatType !== "undefined" && enums_utils_1.VatType) === "function" ? _e : Object)
], UpdateCompanyDto.prototype, "vat_type", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateCompanyDto.prototype, "product_service", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateCompanyDto.prototype, "payment_terms", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEnum)(company_response_interface_1.CompanyStatus),
    tslib_1.__metadata("design:type", typeof (_f = typeof company_response_interface_1.CompanyStatus !== "undefined" && company_response_interface_1.CompanyStatus) === "function" ? _f : Object)
], UpdateCompanyDto.prototype, "status", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateCompanyDto.prototype, "address", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateCompanyDto.prototype, "tin_number", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateCompanyDto.prototype, "customer_code", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], UpdateCompanyDto.prototype, "updated_by_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], UpdateCompanyDto.prototype, "attachment_company_logo_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], UpdateCompanyDto.prototype, "attachment_org_chart_id", void 0);


/***/ }),
/* 43 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a, _b, _c;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FinancialsDto = void 0;
const tslib_1 = __webpack_require__(4);
const class_validator_1 = __webpack_require__(24);
const class_transformer_1 = __webpack_require__(25);
const financials_response_interface_1 = __webpack_require__(44);
const users_dto_1 = __webpack_require__(34);
class FinancialsDto {
}
exports.FinancialsDto = FinancialsDto;
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], FinancialsDto.prototype, "id", void 0);
tslib_1.__decorate([
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsNumber)({ maxDecimalPlaces: 2 }),
    tslib_1.__metadata("design:type", Number)
], FinancialsDto.prototype, "annual_sales_target", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(financials_response_interface_1.FinancialsStatus),
    tslib_1.__metadata("design:type", typeof (_a = typeof financials_response_interface_1.FinancialsStatus !== "undefined" && financials_response_interface_1.FinancialsStatus) === "function" ? _a : Object)
], FinancialsDto.prototype, "status", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsDateString)(),
    tslib_1.__metadata("design:type", String)
], FinancialsDto.prototype, "created_at", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsDateString)(),
    tslib_1.__metadata("design:type", String)
], FinancialsDto.prototype, "updated_at", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => users_dto_1.MiniUsersDto),
    tslib_1.__metadata("design:type", typeof (_b = typeof users_dto_1.MiniUsersDto !== "undefined" && users_dto_1.MiniUsersDto) === "function" ? _b : Object)
], FinancialsDto.prototype, "created_by", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => users_dto_1.MiniUsersDto),
    tslib_1.__metadata("design:type", typeof (_c = typeof users_dto_1.MiniUsersDto !== "undefined" && users_dto_1.MiniUsersDto) === "function" ? _c : Object)
], FinancialsDto.prototype, "updated_by", void 0);


/***/ }),
/* 44 */
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FinancialsStatus = void 0;
var FinancialsStatus;
(function (FinancialsStatus) {
    FinancialsStatus["ACTIVE"] = "ACTIVE";
    FinancialsStatus["INACTIVE"] = "INACTIVE";
    FinancialsStatus["DELETED"] = "DELETED";
    FinancialsStatus["PENDING"] = "PENDING";
})(FinancialsStatus || (exports.FinancialsStatus = FinancialsStatus = {}));


/***/ }),
/* 45 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FinancialsEntity = void 0;
const tslib_1 = __webpack_require__(4);
const typeorm_1 = __webpack_require__(8);
const financials_response_interface_1 = __webpack_require__(44);
const user_entity_1 = __webpack_require__(39);
let FinancialsEntity = class FinancialsEntity {
};
exports.FinancialsEntity = FinancialsEntity;
tslib_1.__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)('uuid'),
    tslib_1.__metadata("design:type", String)
], FinancialsEntity.prototype, "id", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'decimal', precision: 15, scale: 2 }),
    tslib_1.__metadata("design:type", Number)
], FinancialsEntity.prototype, "annual_sales_target", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'varchar' }),
    tslib_1.__metadata("design:type", typeof (_a = typeof financials_response_interface_1.FinancialsStatus !== "undefined" && financials_response_interface_1.FinancialsStatus) === "function" ? _a : Object)
], FinancialsEntity.prototype, "status", void 0);
tslib_1.__decorate([
    (0, typeorm_1.CreateDateColumn)({ nullable: true }),
    tslib_1.__metadata("design:type", typeof (_b = typeof Date !== "undefined" && Date) === "function" ? _b : Object)
], FinancialsEntity.prototype, "created_at", void 0);
tslib_1.__decorate([
    (0, typeorm_1.UpdateDateColumn)({ nullable: true }),
    tslib_1.__metadata("design:type", typeof (_c = typeof Date !== "undefined" && Date) === "function" ? _c : Object)
], FinancialsEntity.prototype, "updated_at", void 0);
tslib_1.__decorate([
    (0, typeorm_1.ManyToOne)(() => user_entity_1.UsersEntity, { nullable: true }),
    (0, typeorm_1.JoinColumn)({ name: 'created_by' }),
    tslib_1.__metadata("design:type", typeof (_d = typeof user_entity_1.UsersEntity !== "undefined" && user_entity_1.UsersEntity) === "function" ? _d : Object)
], FinancialsEntity.prototype, "created_by", void 0);
tslib_1.__decorate([
    (0, typeorm_1.ManyToOne)(() => user_entity_1.UsersEntity, { nullable: true }),
    (0, typeorm_1.JoinColumn)({ name: 'updated_by' }),
    tslib_1.__metadata("design:type", typeof (_e = typeof user_entity_1.UsersEntity !== "undefined" && user_entity_1.UsersEntity) === "function" ? _e : Object)
], FinancialsEntity.prototype, "updated_by", void 0);
exports.FinancialsEntity = FinancialsEntity = tslib_1.__decorate([
    (0, typeorm_1.Entity)('financials')
], FinancialsEntity);


/***/ }),
/* 46 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a, _b;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UpdateFinancialsDto = exports.CreateFinancialsDto = void 0;
const tslib_1 = __webpack_require__(4);
const class_validator_1 = __webpack_require__(24);
const financials_response_interface_1 = __webpack_require__(44);
class CreateFinancialsDto {
}
exports.CreateFinancialsDto = CreateFinancialsDto;
tslib_1.__decorate([
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0, { message: 'Annual sales target must be at least 0' }),
    tslib_1.__metadata("design:type", Number)
], CreateFinancialsDto.prototype, "annual_sales_target", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(financials_response_interface_1.FinancialsStatus),
    tslib_1.__metadata("design:type", typeof (_a = typeof financials_response_interface_1.FinancialsStatus !== "undefined" && financials_response_interface_1.FinancialsStatus) === "function" ? _a : Object)
], CreateFinancialsDto.prototype, "status", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], CreateFinancialsDto.prototype, "created_by_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], CreateFinancialsDto.prototype, "updated_by_id", void 0);
class UpdateFinancialsDto {
}
exports.UpdateFinancialsDto = UpdateFinancialsDto;
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], UpdateFinancialsDto.prototype, "id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], UpdateFinancialsDto.prototype, "annual_sales_target", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEnum)(financials_response_interface_1.FinancialsStatus),
    tslib_1.__metadata("design:type", typeof (_b = typeof financials_response_interface_1.FinancialsStatus !== "undefined" && financials_response_interface_1.FinancialsStatus) === "function" ? _b : Object)
], UpdateFinancialsDto.prototype, "status", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], UpdateFinancialsDto.prototype, "updated_by_id", void 0);


/***/ }),
/* 47 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LeadsDto = void 0;
const tslib_1 = __webpack_require__(4);
const class_validator_1 = __webpack_require__(24);
const class_transformer_1 = __webpack_require__(25);
const leads_response_interface_1 = __webpack_require__(48);
const users_dto_1 = __webpack_require__(34);
const clients_dto_1 = __webpack_require__(32);
const enums_utils_1 = __webpack_require__(16);
class LeadsDto {
}
exports.LeadsDto = LeadsDto;
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], LeadsDto.prototype, "id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(enums_utils_1.Brand),
    tslib_1.__metadata("design:type", typeof (_a = typeof enums_utils_1.Brand !== "undefined" && enums_utils_1.Brand) === "function" ? _a : Object)
], LeadsDto.prototype, "brand", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], LeadsDto.prototype, "description", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsNumber)({ maxDecimalPlaces: 2 }),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], LeadsDto.prototype, "estimated_amount", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsDateString)(),
    tslib_1.__metadata("design:type", String)
], LeadsDto.prototype, "target_date", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(leads_response_interface_1.LeadStatus),
    tslib_1.__metadata("design:type", typeof (_b = typeof leads_response_interface_1.LeadStatus !== "undefined" && leads_response_interface_1.LeadStatus) === "function" ? _b : Object)
], LeadsDto.prototype, "status", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], LeadsDto.prototype, "remarks", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], LeadsDto.prototype, "brand_description", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsDateString)(),
    tslib_1.__metadata("design:type", String)
], LeadsDto.prototype, "created_at", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsDateString)(),
    tslib_1.__metadata("design:type", String)
], LeadsDto.prototype, "updated_at", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => users_dto_1.MiniUsersDto),
    tslib_1.__metadata("design:type", typeof (_c = typeof users_dto_1.MiniUsersDto !== "undefined" && users_dto_1.MiniUsersDto) === "function" ? _c : Object)
], LeadsDto.prototype, "created_by", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => users_dto_1.MiniUsersDto),
    tslib_1.__metadata("design:type", typeof (_d = typeof users_dto_1.MiniUsersDto !== "undefined" && users_dto_1.MiniUsersDto) === "function" ? _d : Object)
], LeadsDto.prototype, "updated_by", void 0);
tslib_1.__decorate([
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => clients_dto_1.ClientsDto),
    tslib_1.__metadata("design:type", typeof (_e = typeof clients_dto_1.ClientsDto !== "undefined" && clients_dto_1.ClientsDto) === "function" ? _e : Object)
], LeadsDto.prototype, "client", void 0);


/***/ }),
/* 48 */
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LeadStatus = void 0;
var LeadStatus;
(function (LeadStatus) {
    LeadStatus["PENDING"] = "Pending";
    LeadStatus["DECLINED"] = "Declined";
    LeadStatus["ACTIVE"] = "Active";
    LeadStatus["PROPOSAL_CREATED"] = "Proposal Created";
    LeadStatus["LOST"] = "Lost";
    LeadStatus["DELETED"] = "Deleted";
})(LeadStatus || (exports.LeadStatus = LeadStatus = {}));


/***/ }),
/* 49 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a, _b, _c, _d, _e, _f, _g, _h;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LeadsEntity = void 0;
const tslib_1 = __webpack_require__(4);
const typeorm_1 = __webpack_require__(8);
const enums_utils_1 = __webpack_require__(16);
const leads_response_interface_1 = __webpack_require__(48);
const user_entity_1 = __webpack_require__(39);
const clients_entity_1 = __webpack_require__(38);
let LeadsEntity = class LeadsEntity {
};
exports.LeadsEntity = LeadsEntity;
tslib_1.__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)('uuid'),
    tslib_1.__metadata("design:type", String)
], LeadsEntity.prototype, "id", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'varchar' }),
    tslib_1.__metadata("design:type", typeof (_a = typeof enums_utils_1.Brand !== "undefined" && enums_utils_1.Brand) === "function" ? _a : Object)
], LeadsEntity.prototype, "brand", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'text', nullable: true }),
    tslib_1.__metadata("design:type", String)
], LeadsEntity.prototype, "description", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({
        type: 'decimal',
        precision: 15,
        scale: 2,
        nullable: true,
    }),
    tslib_1.__metadata("design:type", Number)
], LeadsEntity.prototype, "estimated_amount", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'date', nullable: true }),
    tslib_1.__metadata("design:type", typeof (_b = typeof Date !== "undefined" && Date) === "function" ? _b : Object)
], LeadsEntity.prototype, "target_date", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'varchar' }),
    tslib_1.__metadata("design:type", typeof (_c = typeof leads_response_interface_1.LeadStatus !== "undefined" && leads_response_interface_1.LeadStatus) === "function" ? _c : Object)
], LeadsEntity.prototype, "status", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'text', nullable: true }),
    tslib_1.__metadata("design:type", String)
], LeadsEntity.prototype, "remarks", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'text', nullable: true }),
    tslib_1.__metadata("design:type", String)
], LeadsEntity.prototype, "brand_description", void 0);
tslib_1.__decorate([
    (0, typeorm_1.CreateDateColumn)(),
    tslib_1.__metadata("design:type", typeof (_d = typeof Date !== "undefined" && Date) === "function" ? _d : Object)
], LeadsEntity.prototype, "created_at", void 0);
tslib_1.__decorate([
    (0, typeorm_1.UpdateDateColumn)(),
    tslib_1.__metadata("design:type", typeof (_e = typeof Date !== "undefined" && Date) === "function" ? _e : Object)
], LeadsEntity.prototype, "updated_at", void 0);
tslib_1.__decorate([
    (0, typeorm_1.ManyToOne)(() => user_entity_1.UsersEntity, { nullable: false }),
    (0, typeorm_1.JoinColumn)({ name: 'created_by_id' }),
    tslib_1.__metadata("design:type", typeof (_f = typeof user_entity_1.UsersEntity !== "undefined" && user_entity_1.UsersEntity) === "function" ? _f : Object)
], LeadsEntity.prototype, "created_by", void 0);
tslib_1.__decorate([
    (0, typeorm_1.ManyToOne)(() => user_entity_1.UsersEntity, { nullable: true }),
    (0, typeorm_1.JoinColumn)({ name: 'updated_by_id' }),
    tslib_1.__metadata("design:type", typeof (_g = typeof user_entity_1.UsersEntity !== "undefined" && user_entity_1.UsersEntity) === "function" ? _g : Object)
], LeadsEntity.prototype, "updated_by", void 0);
tslib_1.__decorate([
    (0, typeorm_1.ManyToOne)(() => clients_entity_1.ClientsEntity, { nullable: false }),
    (0, typeorm_1.JoinColumn)({ name: 'client_id' }),
    tslib_1.__metadata("design:type", typeof (_h = typeof clients_entity_1.ClientsEntity !== "undefined" && clients_entity_1.ClientsEntity) === "function" ? _h : Object)
], LeadsEntity.prototype, "client", void 0);
exports.LeadsEntity = LeadsEntity = tslib_1.__decorate([
    (0, typeorm_1.Entity)('leads')
], LeadsEntity);


/***/ }),
/* 50 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UpdateLeadsDto = exports.CreateLeadsDto = void 0;
const tslib_1 = __webpack_require__(4);
const class_validator_1 = __webpack_require__(24);
const leads_response_interface_1 = __webpack_require__(48);
const enums_utils_1 = __webpack_require__(16);
class CreateLeadsDto {
}
exports.CreateLeadsDto = CreateLeadsDto;
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(enums_utils_1.Brand),
    tslib_1.__metadata("design:type", typeof (_a = typeof enums_utils_1.Brand !== "undefined" && enums_utils_1.Brand) === "function" ? _a : Object)
], CreateLeadsDto.prototype, "brand", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CreateLeadsDto.prototype, "description", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], CreateLeadsDto.prototype, "estimated_amount", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsDateString)(),
    tslib_1.__metadata("design:type", String)
], CreateLeadsDto.prototype, "target_date", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(leads_response_interface_1.LeadStatus),
    tslib_1.__metadata("design:type", typeof (_b = typeof leads_response_interface_1.LeadStatus !== "undefined" && leads_response_interface_1.LeadStatus) === "function" ? _b : Object)
], CreateLeadsDto.prototype, "status", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CreateLeadsDto.prototype, "remarks", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CreateLeadsDto.prototype, "brand_description", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], CreateLeadsDto.prototype, "created_by_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], CreateLeadsDto.prototype, "updated_by_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], CreateLeadsDto.prototype, "client_id", void 0);
class UpdateLeadsDto {
}
exports.UpdateLeadsDto = UpdateLeadsDto;
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], UpdateLeadsDto.prototype, "id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEnum)(enums_utils_1.Brand),
    tslib_1.__metadata("design:type", typeof (_c = typeof enums_utils_1.Brand !== "undefined" && enums_utils_1.Brand) === "function" ? _c : Object)
], UpdateLeadsDto.prototype, "brand", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateLeadsDto.prototype, "description", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], UpdateLeadsDto.prototype, "estimated_amount", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsDateString)(),
    tslib_1.__metadata("design:type", String)
], UpdateLeadsDto.prototype, "target_date", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEnum)(leads_response_interface_1.LeadStatus),
    tslib_1.__metadata("design:type", typeof (_d = typeof leads_response_interface_1.LeadStatus !== "undefined" && leads_response_interface_1.LeadStatus) === "function" ? _d : Object)
], UpdateLeadsDto.prototype, "status", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateLeadsDto.prototype, "remarks", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateLeadsDto.prototype, "brand_description", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], UpdateLeadsDto.prototype, "updated_by_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], UpdateLeadsDto.prototype, "client_id", void 0);


/***/ }),
/* 51 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MonitoringsDto = exports.MonitoringAttachmentsDto = void 0;
const tslib_1 = __webpack_require__(4);
const class_validator_1 = __webpack_require__(24);
const class_transformer_1 = __webpack_require__(25);
const monitorings_response_interface_1 = __webpack_require__(52);
const users_dto_1 = __webpack_require__(34);
const company_dto_1 = __webpack_require__(36);
const proposals_dto_1 = __webpack_require__(53);
const attachments_dto_1 = __webpack_require__(23);
const enums_utils_1 = __webpack_require__(16);
class MonitoringAttachmentsDto {
}
exports.MonitoringAttachmentsDto = MonitoringAttachmentsDto;
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], MonitoringAttachmentsDto.prototype, "monitoring_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => attachments_dto_1.AttachmentsDto),
    tslib_1.__metadata("design:type", typeof (_a = typeof attachments_dto_1.AttachmentsDto !== "undefined" && attachments_dto_1.AttachmentsDto) === "function" ? _a : Object)
], MonitoringAttachmentsDto.prototype, "attachment", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(monitorings_response_interface_1.MonitoringAttachmentsStatus),
    tslib_1.__metadata("design:type", typeof (_b = typeof monitorings_response_interface_1.MonitoringAttachmentsStatus !== "undefined" && monitorings_response_interface_1.MonitoringAttachmentsStatus) === "function" ? _b : Object)
], MonitoringAttachmentsDto.prototype, "status", void 0);
class MonitoringsDto {
}
exports.MonitoringsDto = MonitoringsDto;
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], MonitoringsDto.prototype, "id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(monitorings_response_interface_1.MonitoringStatus),
    tslib_1.__metadata("design:type", typeof (_c = typeof monitorings_response_interface_1.MonitoringStatus !== "undefined" && monitorings_response_interface_1.MonitoringStatus) === "function" ? _c : Object)
], MonitoringsDto.prototype, "status", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], MonitoringsDto.prototype, "category", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], MonitoringsDto.prototype, "monitoring_remarks", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsNumber)({ maxDecimalPlaces: 2 }),
    tslib_1.__metadata("design:type", Number)
], MonitoringsDto.prototype, "buying_amount_vat_inc", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsNumber)({ maxDecimalPlaces: 2 }),
    tslib_1.__metadata("design:type", Number)
], MonitoringsDto.prototype, "selling_amount_vat_inc", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsNumber)({ maxDecimalPlaces: 2 }),
    tslib_1.__metadata("design:type", Number)
], MonitoringsDto.prototype, "estimated_gross_profit", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsNumber)({ maxDecimalPlaces: 2 }),
    tslib_1.__metadata("design:type", Number)
], MonitoringsDto.prototype, "mark_up", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsNumber)({ maxDecimalPlaces: 2 }),
    tslib_1.__metadata("design:type", Number)
], MonitoringsDto.prototype, "selling_amount_vat_ex", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], MonitoringsDto.prototype, "project_code", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(enums_utils_1.Industry),
    tslib_1.__metadata("design:type", typeof (_d = typeof enums_utils_1.Industry !== "undefined" && enums_utils_1.Industry) === "function" ? _d : Object)
], MonitoringsDto.prototype, "industry", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(enums_utils_1.ProductCategory),
    tslib_1.__metadata("design:type", typeof (_e = typeof enums_utils_1.ProductCategory !== "undefined" && enums_utils_1.ProductCategory) === "function" ? _e : Object)
], MonitoringsDto.prototype, "product_category", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(enums_utils_1.Brand),
    tslib_1.__metadata("design:type", typeof (_f = typeof enums_utils_1.Brand !== "undefined" && enums_utils_1.Brand) === "function" ? _f : Object)
], MonitoringsDto.prototype, "brand", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], MonitoringsDto.prototype, "project_name", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], MonitoringsDto.prototype, "created_at", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], MonitoringsDto.prototype, "updated_at", void 0);
tslib_1.__decorate([
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => proposals_dto_1.ProposalsDto),
    tslib_1.__metadata("design:type", typeof (_g = typeof proposals_dto_1.ProposalsDto !== "undefined" && proposals_dto_1.ProposalsDto) === "function" ? _g : Object)
], MonitoringsDto.prototype, "proposal", void 0);
tslib_1.__decorate([
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => company_dto_1.CompanyDto),
    tslib_1.__metadata("design:type", typeof (_h = typeof company_dto_1.CompanyDto !== "undefined" && company_dto_1.CompanyDto) === "function" ? _h : Object)
], MonitoringsDto.prototype, "company", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => users_dto_1.MiniUsersDto),
    tslib_1.__metadata("design:type", typeof (_j = typeof users_dto_1.MiniUsersDto !== "undefined" && users_dto_1.MiniUsersDto) === "function" ? _j : Object)
], MonitoringsDto.prototype, "created_by", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => users_dto_1.MiniUsersDto),
    tslib_1.__metadata("design:type", typeof (_k = typeof users_dto_1.MiniUsersDto !== "undefined" && users_dto_1.MiniUsersDto) === "function" ? _k : Object)
], MonitoringsDto.prototype, "updated_by", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsArray)(),
    (0, class_validator_1.ValidateNested)({ each: true }),
    (0, class_transformer_1.Type)(() => MonitoringAttachmentsDto),
    tslib_1.__metadata("design:type", Array)
], MonitoringsDto.prototype, "attachments", void 0);


/***/ }),
/* 52 */
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MonitoringStatus = exports.MonitoringAttachmentsStatus = void 0;
var MonitoringAttachmentsStatus;
(function (MonitoringAttachmentsStatus) {
    MonitoringAttachmentsStatus["ACTIVE"] = "ACTIVE";
    MonitoringAttachmentsStatus["DELETED"] = "DELETED";
})(MonitoringAttachmentsStatus || (exports.MonitoringAttachmentsStatus = MonitoringAttachmentsStatus = {}));
var MonitoringStatus;
(function (MonitoringStatus) {
    MonitoringStatus["ACTIVE"] = "Active";
    MonitoringStatus["VERBALLY_WON"] = "Verbally Won";
    MonitoringStatus["WON"] = "Won";
    MonitoringStatus["LOST"] = "Lost";
    MonitoringStatus["DELETED"] = "Deleted";
})(MonitoringStatus || (exports.MonitoringStatus = MonitoringStatus = {}));


/***/ }),
/* 53 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ProposalsDto = exports.ProposalPricingSummaryDto = exports.ProposalItemsDto = exports.ProposalAttachmentsDto = void 0;
const tslib_1 = __webpack_require__(4);
const class_validator_1 = __webpack_require__(24);
const class_transformer_1 = __webpack_require__(25);
const proposals_response_interface_1 = __webpack_require__(54);
const attachments_dto_1 = __webpack_require__(23);
const users_dto_1 = __webpack_require__(34);
const company_dto_1 = __webpack_require__(36);
const enums_utils_1 = __webpack_require__(16);
class ProposalAttachmentsDto {
}
exports.ProposalAttachmentsDto = ProposalAttachmentsDto;
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], ProposalAttachmentsDto.prototype, "proposal_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => attachments_dto_1.AttachmentsDto),
    tslib_1.__metadata("design:type", typeof (_a = typeof attachments_dto_1.AttachmentsDto !== "undefined" && attachments_dto_1.AttachmentsDto) === "function" ? _a : Object)
], ProposalAttachmentsDto.prototype, "attachment", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(proposals_response_interface_1.ProposalAttachmentsStatus),
    tslib_1.__metadata("design:type", typeof (_b = typeof proposals_response_interface_1.ProposalAttachmentsStatus !== "undefined" && proposals_response_interface_1.ProposalAttachmentsStatus) === "function" ? _b : Object)
], ProposalAttachmentsDto.prototype, "status", void 0);
class ProposalItemsDto {
}
exports.ProposalItemsDto = ProposalItemsDto;
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], ProposalItemsDto.prototype, "id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], ProposalItemsDto.prototype, "item_details", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], ProposalItemsDto.prototype, "description", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsNumber)({ maxDecimalPlaces: 2 }),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], ProposalItemsDto.prototype, "quantity", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], ProposalItemsDto.prototype, "uom", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsNumber)({ maxDecimalPlaces: 2 }),
    tslib_1.__metadata("design:type", Number)
], ProposalItemsDto.prototype, "buying_vat_inc", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsNumber)({ maxDecimalPlaces: 2 }),
    tslib_1.__metadata("design:type", Number)
], ProposalItemsDto.prototype, "total_buying", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsNumber)({ maxDecimalPlaces: 2 }),
    tslib_1.__metadata("design:type", Number)
], ProposalItemsDto.prototype, "shipping_fee", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsNumber)({ maxDecimalPlaces: 2 }),
    tslib_1.__metadata("design:type", Number)
], ProposalItemsDto.prototype, "wsf", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsNumber)({ maxDecimalPlaces: 2 }),
    tslib_1.__metadata("design:type", Number)
], ProposalItemsDto.prototype, "markup", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsNumber)({ maxDecimalPlaces: 2 }),
    tslib_1.__metadata("design:type", Number)
], ProposalItemsDto.prototype, "sp", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsNumber)({ maxDecimalPlaces: 2 }),
    tslib_1.__metadata("design:type", Number)
], ProposalItemsDto.prototype, "sp_each", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsNumber)({ maxDecimalPlaces: 2 }),
    tslib_1.__metadata("design:type", Number)
], ProposalItemsDto.prototype, "misc", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsNumber)({ maxDecimalPlaces: 2 }),
    tslib_1.__metadata("design:type", Number)
], ProposalItemsDto.prototype, "tpc_price", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsNumber)({ maxDecimalPlaces: 2 }),
    tslib_1.__metadata("design:type", Number)
], ProposalItemsDto.prototype, "fsp", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsNumber)({ maxDecimalPlaces: 2 }),
    tslib_1.__metadata("design:type", Number)
], ProposalItemsDto.prototype, "fsp_each", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsNumber)({ maxDecimalPlaces: 2 }),
    tslib_1.__metadata("design:type", Number)
], ProposalItemsDto.prototype, "profit_each", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsNumber)({ maxDecimalPlaces: 2 }),
    tslib_1.__metadata("design:type", Number)
], ProposalItemsDto.prototype, "total_profit", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], ProposalItemsDto.prototype, "delivery", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], ProposalItemsDto.prototype, "project", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(enums_utils_1.Brand),
    tslib_1.__metadata("design:type", typeof (_c = typeof enums_utils_1.Brand !== "undefined" && enums_utils_1.Brand) === "function" ? _c : Object)
], ProposalItemsDto.prototype, "brand", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], ProposalItemsDto.prototype, "proposal_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => attachments_dto_1.AttachmentsDto),
    tslib_1.__metadata("design:type", typeof (_d = typeof attachments_dto_1.AttachmentsDto !== "undefined" && attachments_dto_1.AttachmentsDto) === "function" ? _d : Object)
], ProposalItemsDto.prototype, "attachment_item_img", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(proposals_response_interface_1.ProposalItemStatus),
    tslib_1.__metadata("design:type", typeof (_e = typeof proposals_response_interface_1.ProposalItemStatus !== "undefined" && proposals_response_interface_1.ProposalItemStatus) === "function" ? _e : Object)
], ProposalItemsDto.prototype, "status", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], ProposalItemsDto.prototype, "lof", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], ProposalItemsDto.prototype, "aof", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], ProposalItemsDto.prototype, "srf", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], ProposalItemsDto.prototype, "lsf", void 0);
class ProposalPricingSummaryDto {
}
exports.ProposalPricingSummaryDto = ProposalPricingSummaryDto;
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], ProposalPricingSummaryDto.prototype, "id", void 0);
tslib_1.__decorate([
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsNumber)({ maxDecimalPlaces: 2 }),
    tslib_1.__metadata("design:type", Number)
], ProposalPricingSummaryDto.prototype, "subtotal", void 0);
tslib_1.__decorate([
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsNumber)({ maxDecimalPlaces: 2 }),
    tslib_1.__metadata("design:type", Number)
], ProposalPricingSummaryDto.prototype, "shipping_fee", void 0);
tslib_1.__decorate([
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsNumber)({ maxDecimalPlaces: 2 }),
    tslib_1.__metadata("design:type", Number)
], ProposalPricingSummaryDto.prototype, "markup", void 0);
tslib_1.__decorate([
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsNumber)({ maxDecimalPlaces: 2 }),
    tslib_1.__metadata("design:type", Number)
], ProposalPricingSummaryDto.prototype, "misc", void 0);
tslib_1.__decorate([
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsNumber)({ maxDecimalPlaces: 2 }),
    tslib_1.__metadata("design:type", Number)
], ProposalPricingSummaryDto.prototype, "approval_discount", void 0);
tslib_1.__decorate([
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsNumber)({ maxDecimalPlaces: 2 }),
    tslib_1.__metadata("design:type", Number)
], ProposalPricingSummaryDto.prototype, "discount_percent", void 0);
tslib_1.__decorate([
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsNumber)({ maxDecimalPlaces: 2 }),
    tslib_1.__metadata("design:type", Number)
], ProposalPricingSummaryDto.prototype, "discount_amount", void 0);
tslib_1.__decorate([
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsNumber)({ maxDecimalPlaces: 2 }),
    tslib_1.__metadata("design:type", Number)
], ProposalPricingSummaryDto.prototype, "total_ex_vat", void 0);
tslib_1.__decorate([
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsNumber)({ maxDecimalPlaces: 2 }),
    tslib_1.__metadata("design:type", Number)
], ProposalPricingSummaryDto.prototype, "total_inc_vat", void 0);
tslib_1.__decorate([
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsNumber)({ maxDecimalPlaces: 2 }),
    tslib_1.__metadata("design:type", Number)
], ProposalPricingSummaryDto.prototype, "total_profit", void 0);
tslib_1.__decorate([
    (0, class_transformer_1.Type)(() => Number),
    (0, class_validator_1.IsNumber)({ maxDecimalPlaces: 2 }),
    tslib_1.__metadata("design:type", Number)
], ProposalPricingSummaryDto.prototype, "grand_total", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], ProposalPricingSummaryDto.prototype, "lead_time", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsDateString)(),
    tslib_1.__metadata("design:type", String)
], ProposalPricingSummaryDto.prototype, "created_at", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsDateString)(),
    tslib_1.__metadata("design:type", String)
], ProposalPricingSummaryDto.prototype, "updated_at", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], ProposalPricingSummaryDto.prototype, "proposal_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(proposals_response_interface_1.ProposalPricingSummaryStatus),
    tslib_1.__metadata("design:type", typeof (_f = typeof proposals_response_interface_1.ProposalPricingSummaryStatus !== "undefined" && proposals_response_interface_1.ProposalPricingSummaryStatus) === "function" ? _f : Object)
], ProposalPricingSummaryDto.prototype, "status", void 0);
class ProposalsDto {
}
exports.ProposalsDto = ProposalsDto;
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], ProposalsDto.prototype, "id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], ProposalsDto.prototype, "project_name", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], ProposalsDto.prototype, "project_code", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(proposals_response_interface_1.ProposalCompanies),
    tslib_1.__metadata("design:type", typeof (_g = typeof proposals_response_interface_1.ProposalCompanies !== "undefined" && proposals_response_interface_1.ProposalCompanies) === "function" ? _g : Object)
], ProposalsDto.prototype, "company", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(enums_utils_1.CategoryTypes),
    tslib_1.__metadata("design:type", typeof (_h = typeof enums_utils_1.CategoryTypes !== "undefined" && enums_utils_1.CategoryTypes) === "function" ? _h : Object)
], ProposalsDto.prototype, "category", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(enums_utils_1.ProductCategory),
    tslib_1.__metadata("design:type", typeof (_j = typeof enums_utils_1.ProductCategory !== "undefined" && enums_utils_1.ProductCategory) === "function" ? _j : Object)
], ProposalsDto.prototype, "product_category", void 0);
tslib_1.__decorate([
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => company_dto_1.CompanyDto),
    tslib_1.__metadata("design:type", typeof (_k = typeof company_dto_1.CompanyDto !== "undefined" && company_dto_1.CompanyDto) === "function" ? _k : Object)
], ProposalsDto.prototype, "company_ref", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsDateString)(),
    tslib_1.__metadata("design:type", String)
], ProposalsDto.prototype, "selected_date", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], ProposalsDto.prototype, "customer_ref", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], ProposalsDto.prototype, "quotation_number", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(proposals_response_interface_1.ProposalPaymentTerms),
    tslib_1.__metadata("design:type", typeof (_l = typeof proposals_response_interface_1.ProposalPaymentTerms !== "undefined" && proposals_response_interface_1.ProposalPaymentTerms) === "function" ? _l : Object)
], ProposalsDto.prototype, "payment_terms", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(proposals_response_interface_1.ProposalValidity),
    tslib_1.__metadata("design:type", typeof (_m = typeof proposals_response_interface_1.ProposalValidity !== "undefined" && proposals_response_interface_1.ProposalValidity) === "function" ? _m : Object)
], ProposalsDto.prototype, "quote_validity", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(proposals_response_interface_1.ProposalWarranty),
    tslib_1.__metadata("design:type", typeof (_o = typeof proposals_response_interface_1.ProposalWarranty !== "undefined" && proposals_response_interface_1.ProposalWarranty) === "function" ? _o : Object)
], ProposalsDto.prototype, "warranty", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], ProposalsDto.prototype, "company_remarks", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(proposals_response_interface_1.ProposalStatus),
    tslib_1.__metadata("design:type", typeof (_p = typeof proposals_response_interface_1.ProposalStatus !== "undefined" && proposals_response_interface_1.ProposalStatus) === "function" ? _p : Object)
], ProposalsDto.prototype, "status", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsDateString)(),
    tslib_1.__metadata("design:type", String)
], ProposalsDto.prototype, "created_at", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsDateString)(),
    tslib_1.__metadata("design:type", String)
], ProposalsDto.prototype, "updated_at", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.ValidateNested)({ each: true }),
    (0, class_transformer_1.Type)(() => ProposalAttachmentsDto),
    tslib_1.__metadata("design:type", Array)
], ProposalsDto.prototype, "proposal_attachments", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.ValidateNested)({ each: true }),
    (0, class_transformer_1.Type)(() => ProposalItemsDto),
    tslib_1.__metadata("design:type", Array)
], ProposalsDto.prototype, "proposal_items", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => ProposalPricingSummaryDto),
    tslib_1.__metadata("design:type", ProposalPricingSummaryDto)
], ProposalsDto.prototype, "proposal_pricing_summary", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => users_dto_1.MiniUsersDto),
    tslib_1.__metadata("design:type", typeof (_q = typeof users_dto_1.MiniUsersDto !== "undefined" && users_dto_1.MiniUsersDto) === "function" ? _q : Object)
], ProposalsDto.prototype, "created_by", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => users_dto_1.MiniUsersDto),
    tslib_1.__metadata("design:type", typeof (_r = typeof users_dto_1.MiniUsersDto !== "undefined" && users_dto_1.MiniUsersDto) === "function" ? _r : Object)
], ProposalsDto.prototype, "updated_by", void 0);


/***/ }),
/* 54 */
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ProposalWarranty = exports.ProposalValidity = exports.ProposalPaymentTerms = exports.ProposalCompanies = exports.ProposalPricingSummaryStatus = exports.ProposalItemStatus = exports.ProposalStatus = exports.ProposalAttachmentsStatus = void 0;
var ProposalAttachmentsStatus;
(function (ProposalAttachmentsStatus) {
    ProposalAttachmentsStatus["ACTIVE"] = "ACTIVE";
    ProposalAttachmentsStatus["DELETED"] = "DELETED";
})(ProposalAttachmentsStatus || (exports.ProposalAttachmentsStatus = ProposalAttachmentsStatus = {}));
var ProposalStatus;
(function (ProposalStatus) {
    ProposalStatus["PENDING"] = "Pending";
    ProposalStatus["RETURNED"] = "Returned";
    ProposalStatus["REJECTED"] = "Rejected";
    ProposalStatus["APPROVED"] = "Approved";
    ProposalStatus["DRAFT"] = "Draft";
    ProposalStatus["DELETED"] = "Deleted";
})(ProposalStatus || (exports.ProposalStatus = ProposalStatus = {}));
var ProposalItemStatus;
(function (ProposalItemStatus) {
    ProposalItemStatus["ACTIVE"] = "Active";
    ProposalItemStatus["INACTIVE"] = "Inactive";
    ProposalItemStatus["DELETED"] = "Deleted";
})(ProposalItemStatus || (exports.ProposalItemStatus = ProposalItemStatus = {}));
var ProposalPricingSummaryStatus;
(function (ProposalPricingSummaryStatus) {
    ProposalPricingSummaryStatus["ACTIVE"] = "Active";
    ProposalPricingSummaryStatus["INACTIVE"] = "Inactive";
    ProposalPricingSummaryStatus["DELETED"] = "Deleted";
})(ProposalPricingSummaryStatus || (exports.ProposalPricingSummaryStatus = ProposalPricingSummaryStatus = {}));
var ProposalCompanies;
(function (ProposalCompanies) {
    ProposalCompanies["ACA"] = "ACA";
    ProposalCompanies["PII"] = "PII";
})(ProposalCompanies || (exports.ProposalCompanies = ProposalCompanies = {}));
var ProposalPaymentTerms;
(function (ProposalPaymentTerms) {
    ProposalPaymentTerms["DP30_UD70"] = "30% Downpayment , 70% Upon Delivery";
    ProposalPaymentTerms["DP50_UD50"] = "50% Downpayment , 50% Upon Delivery";
    ProposalPaymentTerms["UD100"] = "100% Upon Delivery";
    ProposalPaymentTerms["DAYS_30"] = "30 Days Payment Terms";
    ProposalPaymentTerms["DAYS_120"] = "120 Days Payment Terms";
})(ProposalPaymentTerms || (exports.ProposalPaymentTerms = ProposalPaymentTerms = {}));
var ProposalValidity;
(function (ProposalValidity) {
    ProposalValidity["DAYS_15"] = "15 Days Validity";
    ProposalValidity["DAYS_30"] = "30 Days Validity";
    ProposalValidity["DAYS_60"] = "60 Days Validity";
})(ProposalValidity || (exports.ProposalValidity = ProposalValidity = {}));
var ProposalWarranty;
(function (ProposalWarranty) {
    ProposalWarranty["MONTHS_6"] = "6 Months Warranty";
    ProposalWarranty["MONTHS_9"] = "9 Months Warranty";
    ProposalWarranty["MONTHS_12"] = "12 Months Warranty";
})(ProposalWarranty || (exports.ProposalWarranty = ProposalWarranty = {}));


/***/ }),
/* 55 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MonitoringAttachmentsEntity = exports.MonitoringsEntity = void 0;
const tslib_1 = __webpack_require__(4);
const typeorm_1 = __webpack_require__(8);
const monitorings_response_interface_1 = __webpack_require__(52);
const company_entity_1 = __webpack_require__(40);
const proposals_entity_1 = __webpack_require__(56);
const user_entity_1 = __webpack_require__(39);
const enums_utils_1 = __webpack_require__(16);
const attachments_entity_1 = __webpack_require__(28);
let MonitoringsEntity = class MonitoringsEntity {
};
exports.MonitoringsEntity = MonitoringsEntity;
tslib_1.__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)('uuid'),
    tslib_1.__metadata("design:type", String)
], MonitoringsEntity.prototype, "id", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'varchar' }),
    tslib_1.__metadata("design:type", typeof (_a = typeof monitorings_response_interface_1.MonitoringStatus !== "undefined" && monitorings_response_interface_1.MonitoringStatus) === "function" ? _a : Object)
], MonitoringsEntity.prototype, "status", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)(),
    tslib_1.__metadata("design:type", String)
], MonitoringsEntity.prototype, "category", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'text', nullable: true }),
    tslib_1.__metadata("design:type", String)
], MonitoringsEntity.prototype, "monitoring_remarks", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'decimal', precision: 15, scale: 2, nullable: true }),
    tslib_1.__metadata("design:type", Number)
], MonitoringsEntity.prototype, "buying_amount_vat_inc", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'decimal', precision: 15, scale: 2, nullable: true }),
    tslib_1.__metadata("design:type", Number)
], MonitoringsEntity.prototype, "selling_amount_vat_inc", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'decimal', precision: 15, scale: 2, nullable: true }),
    tslib_1.__metadata("design:type", Number)
], MonitoringsEntity.prototype, "estimated_gross_profit", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'decimal', precision: 15, scale: 2, nullable: true }),
    tslib_1.__metadata("design:type", Number)
], MonitoringsEntity.prototype, "mark_up", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'decimal', precision: 15, scale: 2, nullable: true }),
    tslib_1.__metadata("design:type", Number)
], MonitoringsEntity.prototype, "selling_amount_vat_ex", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'varchar', nullable: true }),
    tslib_1.__metadata("design:type", String)
], MonitoringsEntity.prototype, "project_code", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'varchar' }),
    tslib_1.__metadata("design:type", typeof (_b = typeof enums_utils_1.Industry !== "undefined" && enums_utils_1.Industry) === "function" ? _b : Object)
], MonitoringsEntity.prototype, "industry", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'varchar' }),
    tslib_1.__metadata("design:type", typeof (_c = typeof enums_utils_1.ProductCategory !== "undefined" && enums_utils_1.ProductCategory) === "function" ? _c : Object)
], MonitoringsEntity.prototype, "product_category", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'varchar' }),
    tslib_1.__metadata("design:type", typeof (_d = typeof enums_utils_1.Brand !== "undefined" && enums_utils_1.Brand) === "function" ? _d : Object)
], MonitoringsEntity.prototype, "brand", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'varchar', nullable: true }),
    tslib_1.__metadata("design:type", String)
], MonitoringsEntity.prototype, "project_name", void 0);
tslib_1.__decorate([
    (0, typeorm_1.CreateDateColumn)(),
    tslib_1.__metadata("design:type", typeof (_e = typeof Date !== "undefined" && Date) === "function" ? _e : Object)
], MonitoringsEntity.prototype, "created_at", void 0);
tslib_1.__decorate([
    (0, typeorm_1.UpdateDateColumn)(),
    tslib_1.__metadata("design:type", typeof (_f = typeof Date !== "undefined" && Date) === "function" ? _f : Object)
], MonitoringsEntity.prototype, "updated_at", void 0);
tslib_1.__decorate([
    (0, typeorm_1.ManyToOne)(() => proposals_entity_1.ProposalsEntity, { nullable: false }),
    (0, typeorm_1.JoinColumn)({ name: 'proposal_id' }),
    tslib_1.__metadata("design:type", typeof (_g = typeof proposals_entity_1.ProposalsEntity !== "undefined" && proposals_entity_1.ProposalsEntity) === "function" ? _g : Object)
], MonitoringsEntity.prototype, "proposal", void 0);
tslib_1.__decorate([
    (0, typeorm_1.ManyToOne)(() => company_entity_1.CompanyEntity, { nullable: false }),
    (0, typeorm_1.JoinColumn)({ name: 'company_id' }),
    tslib_1.__metadata("design:type", typeof (_h = typeof company_entity_1.CompanyEntity !== "undefined" && company_entity_1.CompanyEntity) === "function" ? _h : Object)
], MonitoringsEntity.prototype, "company", void 0);
tslib_1.__decorate([
    (0, typeorm_1.ManyToOne)(() => user_entity_1.UsersEntity, { nullable: true }),
    (0, typeorm_1.JoinColumn)({ name: 'created_by_id' }),
    tslib_1.__metadata("design:type", typeof (_j = typeof user_entity_1.UsersEntity !== "undefined" && user_entity_1.UsersEntity) === "function" ? _j : Object)
], MonitoringsEntity.prototype, "created_by", void 0);
tslib_1.__decorate([
    (0, typeorm_1.ManyToOne)(() => user_entity_1.UsersEntity, { nullable: true }),
    (0, typeorm_1.JoinColumn)({ name: 'updated_by_id' }),
    tslib_1.__metadata("design:type", typeof (_k = typeof user_entity_1.UsersEntity !== "undefined" && user_entity_1.UsersEntity) === "function" ? _k : Object)
], MonitoringsEntity.prototype, "updated_by", void 0);
tslib_1.__decorate([
    (0, typeorm_1.OneToMany)(() => MonitoringAttachmentsEntity, attachment => attachment.monitoring, {
        cascade: true,
    }),
    tslib_1.__metadata("design:type", Array)
], MonitoringsEntity.prototype, "attachments", void 0);
exports.MonitoringsEntity = MonitoringsEntity = tslib_1.__decorate([
    (0, typeorm_1.Entity)('monitorings')
], MonitoringsEntity);
let MonitoringAttachmentsEntity = class MonitoringAttachmentsEntity {
};
exports.MonitoringAttachmentsEntity = MonitoringAttachmentsEntity;
tslib_1.__decorate([
    (0, typeorm_1.PrimaryColumn)('uuid', { name: 'monitoring_id' }),
    tslib_1.__metadata("design:type", String)
], MonitoringAttachmentsEntity.prototype, "monitoring_id", void 0);
tslib_1.__decorate([
    (0, typeorm_1.ManyToOne)(() => MonitoringsEntity, monitoring => monitoring.attachments, {
        nullable: false,
        onDelete: 'CASCADE',
    }),
    (0, typeorm_1.JoinColumn)({ name: 'monitoring_id' }),
    tslib_1.__metadata("design:type", MonitoringsEntity)
], MonitoringAttachmentsEntity.prototype, "monitoring", void 0);
tslib_1.__decorate([
    (0, typeorm_1.PrimaryColumn)('uuid', { name: 'attachment_id' }),
    tslib_1.__metadata("design:type", String)
], MonitoringAttachmentsEntity.prototype, "attachment_id", void 0);
tslib_1.__decorate([
    (0, typeorm_1.ManyToOne)(() => attachments_entity_1.AttachmentsEntity, { nullable: false }),
    (0, typeorm_1.JoinColumn)({ name: 'attachment_id' }),
    tslib_1.__metadata("design:type", typeof (_l = typeof attachments_entity_1.AttachmentsEntity !== "undefined" && attachments_entity_1.AttachmentsEntity) === "function" ? _l : Object)
], MonitoringAttachmentsEntity.prototype, "attachment", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'varchar' }),
    tslib_1.__metadata("design:type", typeof (_m = typeof monitorings_response_interface_1.MonitoringAttachmentsStatus !== "undefined" && monitorings_response_interface_1.MonitoringAttachmentsStatus) === "function" ? _m : Object)
], MonitoringAttachmentsEntity.prototype, "status", void 0);
exports.MonitoringAttachmentsEntity = MonitoringAttachmentsEntity = tslib_1.__decorate([
    (0, typeorm_1.Entity)('monitoring_attachments')
], MonitoringAttachmentsEntity);


/***/ }),
/* 56 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ProposalAttachmentsEntity = exports.ProposalItemsEntity = exports.ProposalsEntity = void 0;
const tslib_1 = __webpack_require__(4);
const typeorm_1 = __webpack_require__(8);
const proposals_response_interface_1 = __webpack_require__(54);
const user_entity_1 = __webpack_require__(39);
const company_entity_1 = __webpack_require__(40);
const attachments_entity_1 = __webpack_require__(28);
const enums_utils_1 = __webpack_require__(16);
const proposal_pricing_summary_entity_1 = __webpack_require__(57);
let ProposalsEntity = class ProposalsEntity {
};
exports.ProposalsEntity = ProposalsEntity;
tslib_1.__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)('uuid'),
    tslib_1.__metadata("design:type", String)
], ProposalsEntity.prototype, "id", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)(),
    tslib_1.__metadata("design:type", String)
], ProposalsEntity.prototype, "project_name", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    tslib_1.__metadata("design:type", String)
], ProposalsEntity.prototype, "project_code", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'varchar' }),
    tslib_1.__metadata("design:type", typeof (_a = typeof proposals_response_interface_1.ProposalCompanies !== "undefined" && proposals_response_interface_1.ProposalCompanies) === "function" ? _a : Object)
], ProposalsEntity.prototype, "company", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'varchar' }),
    tslib_1.__metadata("design:type", typeof (_b = typeof enums_utils_1.CategoryTypes !== "undefined" && enums_utils_1.CategoryTypes) === "function" ? _b : Object)
], ProposalsEntity.prototype, "category", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'varchar' }),
    tslib_1.__metadata("design:type", typeof (_c = typeof enums_utils_1.ProductCategory !== "undefined" && enums_utils_1.ProductCategory) === "function" ? _c : Object)
], ProposalsEntity.prototype, "product_category", void 0);
tslib_1.__decorate([
    (0, typeorm_1.ManyToOne)(() => company_entity_1.CompanyEntity, { nullable: false }),
    (0, typeorm_1.JoinColumn)({ name: 'company_id' }),
    tslib_1.__metadata("design:type", typeof (_d = typeof company_entity_1.CompanyEntity !== "undefined" && company_entity_1.CompanyEntity) === "function" ? _d : Object)
], ProposalsEntity.prototype, "company_ref", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'date' }),
    tslib_1.__metadata("design:type", typeof (_e = typeof Date !== "undefined" && Date) === "function" ? _e : Object)
], ProposalsEntity.prototype, "selected_date", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    tslib_1.__metadata("design:type", String)
], ProposalsEntity.prototype, "customer_ref", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    tslib_1.__metadata("design:type", String)
], ProposalsEntity.prototype, "quotation_number", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'varchar' }),
    tslib_1.__metadata("design:type", typeof (_f = typeof proposals_response_interface_1.ProposalPaymentTerms !== "undefined" && proposals_response_interface_1.ProposalPaymentTerms) === "function" ? _f : Object)
], ProposalsEntity.prototype, "payment_terms", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'varchar' }),
    tslib_1.__metadata("design:type", typeof (_g = typeof proposals_response_interface_1.ProposalValidity !== "undefined" && proposals_response_interface_1.ProposalValidity) === "function" ? _g : Object)
], ProposalsEntity.prototype, "quote_validity", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'varchar' }),
    tslib_1.__metadata("design:type", typeof (_h = typeof proposals_response_interface_1.ProposalWarranty !== "undefined" && proposals_response_interface_1.ProposalWarranty) === "function" ? _h : Object)
], ProposalsEntity.prototype, "warranty", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    tslib_1.__metadata("design:type", String)
], ProposalsEntity.prototype, "company_remarks", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'varchar' }),
    tslib_1.__metadata("design:type", typeof (_j = typeof proposals_response_interface_1.ProposalStatus !== "undefined" && proposals_response_interface_1.ProposalStatus) === "function" ? _j : Object)
], ProposalsEntity.prototype, "status", void 0);
tslib_1.__decorate([
    (0, typeorm_1.CreateDateColumn)(),
    tslib_1.__metadata("design:type", typeof (_k = typeof Date !== "undefined" && Date) === "function" ? _k : Object)
], ProposalsEntity.prototype, "created_at", void 0);
tslib_1.__decorate([
    (0, typeorm_1.UpdateDateColumn)(),
    tslib_1.__metadata("design:type", typeof (_l = typeof Date !== "undefined" && Date) === "function" ? _l : Object)
], ProposalsEntity.prototype, "updated_at", void 0);
tslib_1.__decorate([
    (0, typeorm_1.OneToMany)(() => ProposalAttachmentsEntity, attachment => attachment.proposal, { cascade: true }),
    tslib_1.__metadata("design:type", Array)
], ProposalsEntity.prototype, "proposal_attachments", void 0);
tslib_1.__decorate([
    (0, typeorm_1.OneToMany)(() => ProposalItemsEntity, item => item.proposal, { cascade: true }),
    tslib_1.__metadata("design:type", Array)
], ProposalsEntity.prototype, "proposal_items", void 0);
tslib_1.__decorate([
    (0, typeorm_1.OneToOne)(() => proposal_pricing_summary_entity_1.ProposalPricingSummaryEntity, summary => summary.proposal, { cascade: true }),
    tslib_1.__metadata("design:type", typeof (_m = typeof proposal_pricing_summary_entity_1.ProposalPricingSummaryEntity !== "undefined" && proposal_pricing_summary_entity_1.ProposalPricingSummaryEntity) === "function" ? _m : Object)
], ProposalsEntity.prototype, "proposal_pricing_summary", void 0);
tslib_1.__decorate([
    (0, typeorm_1.ManyToOne)(() => user_entity_1.UsersEntity, { nullable: true }),
    (0, typeorm_1.JoinColumn)({ name: 'created_by_id' }),
    tslib_1.__metadata("design:type", typeof (_o = typeof user_entity_1.UsersEntity !== "undefined" && user_entity_1.UsersEntity) === "function" ? _o : Object)
], ProposalsEntity.prototype, "created_by", void 0);
tslib_1.__decorate([
    (0, typeorm_1.ManyToOne)(() => user_entity_1.UsersEntity, { nullable: true }),
    (0, typeorm_1.JoinColumn)({ name: 'updated_by_id' }),
    tslib_1.__metadata("design:type", typeof (_p = typeof user_entity_1.UsersEntity !== "undefined" && user_entity_1.UsersEntity) === "function" ? _p : Object)
], ProposalsEntity.prototype, "updated_by", void 0);
exports.ProposalsEntity = ProposalsEntity = tslib_1.__decorate([
    (0, typeorm_1.Entity)('proposals')
], ProposalsEntity);
let ProposalItemsEntity = class ProposalItemsEntity {
};
exports.ProposalItemsEntity = ProposalItemsEntity;
tslib_1.__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)('uuid'),
    tslib_1.__metadata("design:type", String)
], ProposalItemsEntity.prototype, "id", void 0);
tslib_1.__decorate([
    (0, typeorm_1.ManyToOne)(() => ProposalsEntity, proposal => proposal.proposal_items, { nullable: false, onDelete: 'CASCADE' }),
    (0, typeorm_1.JoinColumn)({ name: 'proposal_id' }),
    tslib_1.__metadata("design:type", ProposalsEntity)
], ProposalItemsEntity.prototype, "proposal", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'text', nullable: true }),
    tslib_1.__metadata("design:type", String)
], ProposalItemsEntity.prototype, "item_details", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'text', nullable: true }),
    tslib_1.__metadata("design:type", String)
], ProposalItemsEntity.prototype, "description", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'decimal', precision: 15, scale: 2, nullable: true }),
    tslib_1.__metadata("design:type", Number)
], ProposalItemsEntity.prototype, "quantity", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    tslib_1.__metadata("design:type", String)
], ProposalItemsEntity.prototype, "uom", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'decimal', precision: 15, scale: 2, nullable: true }),
    tslib_1.__metadata("design:type", Number)
], ProposalItemsEntity.prototype, "buying_vat_inc", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'decimal', precision: 15, scale: 2, nullable: true }),
    tslib_1.__metadata("design:type", Number)
], ProposalItemsEntity.prototype, "total_buying", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'decimal', precision: 15, scale: 2, nullable: true }),
    tslib_1.__metadata("design:type", Number)
], ProposalItemsEntity.prototype, "shipping_fee", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'decimal', precision: 15, scale: 2, nullable: true }),
    tslib_1.__metadata("design:type", Number)
], ProposalItemsEntity.prototype, "wsf", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'decimal', precision: 15, scale: 2, nullable: true }),
    tslib_1.__metadata("design:type", Number)
], ProposalItemsEntity.prototype, "markup", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'decimal', precision: 15, scale: 2, nullable: true }),
    tslib_1.__metadata("design:type", Number)
], ProposalItemsEntity.prototype, "sp", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'decimal', precision: 15, scale: 2, nullable: true }),
    tslib_1.__metadata("design:type", Number)
], ProposalItemsEntity.prototype, "sp_each", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'decimal', precision: 15, scale: 2, nullable: true }),
    tslib_1.__metadata("design:type", Number)
], ProposalItemsEntity.prototype, "misc", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'decimal', precision: 15, scale: 2, nullable: true }),
    tslib_1.__metadata("design:type", Number)
], ProposalItemsEntity.prototype, "tpc_price", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'decimal', precision: 15, scale: 2, nullable: true }),
    tslib_1.__metadata("design:type", Number)
], ProposalItemsEntity.prototype, "fsp", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'decimal', precision: 15, scale: 2, nullable: true }),
    tslib_1.__metadata("design:type", Number)
], ProposalItemsEntity.prototype, "fsp_each", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'decimal', precision: 15, scale: 2, nullable: true }),
    tslib_1.__metadata("design:type", Number)
], ProposalItemsEntity.prototype, "profit_each", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'decimal', precision: 15, scale: 2, nullable: true }),
    tslib_1.__metadata("design:type", Number)
], ProposalItemsEntity.prototype, "total_profit", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    tslib_1.__metadata("design:type", String)
], ProposalItemsEntity.prototype, "delivery", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    tslib_1.__metadata("design:type", String)
], ProposalItemsEntity.prototype, "project", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'varchar' }),
    tslib_1.__metadata("design:type", typeof (_q = typeof enums_utils_1.Brand !== "undefined" && enums_utils_1.Brand) === "function" ? _q : Object)
], ProposalItemsEntity.prototype, "brand", void 0);
tslib_1.__decorate([
    (0, typeorm_1.ManyToOne)(() => attachments_entity_1.AttachmentsEntity, { nullable: true }),
    (0, typeorm_1.JoinColumn)({ name: 'attachment_item_img' }),
    tslib_1.__metadata("design:type", typeof (_r = typeof attachments_entity_1.AttachmentsEntity !== "undefined" && attachments_entity_1.AttachmentsEntity) === "function" ? _r : Object)
], ProposalItemsEntity.prototype, "attachment_item_img", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'varchar' }),
    tslib_1.__metadata("design:type", typeof (_s = typeof proposals_response_interface_1.ProposalItemStatus !== "undefined" && proposals_response_interface_1.ProposalItemStatus) === "function" ? _s : Object)
], ProposalItemsEntity.prototype, "status", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    tslib_1.__metadata("design:type", String)
], ProposalItemsEntity.prototype, "lof", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    tslib_1.__metadata("design:type", String)
], ProposalItemsEntity.prototype, "aof", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    tslib_1.__metadata("design:type", String)
], ProposalItemsEntity.prototype, "srf", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    tslib_1.__metadata("design:type", String)
], ProposalItemsEntity.prototype, "lsf", void 0);
exports.ProposalItemsEntity = ProposalItemsEntity = tslib_1.__decorate([
    (0, typeorm_1.Entity)('proposal_items')
], ProposalItemsEntity);
let ProposalAttachmentsEntity = class ProposalAttachmentsEntity {
};
exports.ProposalAttachmentsEntity = ProposalAttachmentsEntity;
tslib_1.__decorate([
    (0, typeorm_1.PrimaryColumn)('uuid', { name: 'proposal_id' }),
    tslib_1.__metadata("design:type", String)
], ProposalAttachmentsEntity.prototype, "proposal_id", void 0);
tslib_1.__decorate([
    (0, typeorm_1.ManyToOne)(() => ProposalsEntity, proposal => proposal.proposal_attachments, { nullable: false, onDelete: 'CASCADE' }),
    (0, typeorm_1.JoinColumn)({ name: 'proposal_id' }),
    tslib_1.__metadata("design:type", ProposalsEntity)
], ProposalAttachmentsEntity.prototype, "proposal", void 0);
tslib_1.__decorate([
    (0, typeorm_1.PrimaryColumn)('uuid', { name: 'attachment_id' }),
    tslib_1.__metadata("design:type", String)
], ProposalAttachmentsEntity.prototype, "attachment_id", void 0);
tslib_1.__decorate([
    (0, typeorm_1.ManyToOne)(() => attachments_entity_1.AttachmentsEntity, { nullable: false }),
    (0, typeorm_1.JoinColumn)({ name: 'attachment_id' }),
    tslib_1.__metadata("design:type", typeof (_t = typeof attachments_entity_1.AttachmentsEntity !== "undefined" && attachments_entity_1.AttachmentsEntity) === "function" ? _t : Object)
], ProposalAttachmentsEntity.prototype, "attachment", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'varchar' }),
    tslib_1.__metadata("design:type", typeof (_u = typeof proposals_response_interface_1.ProposalAttachmentsStatus !== "undefined" && proposals_response_interface_1.ProposalAttachmentsStatus) === "function" ? _u : Object)
], ProposalAttachmentsEntity.prototype, "status", void 0);
exports.ProposalAttachmentsEntity = ProposalAttachmentsEntity = tslib_1.__decorate([
    (0, typeorm_1.Entity)('proposal_attachments')
], ProposalAttachmentsEntity);


/***/ }),
/* 57 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ProposalPricingSummaryEntity = void 0;
const tslib_1 = __webpack_require__(4);
const typeorm_1 = __webpack_require__(8);
const proposals_response_interface_1 = __webpack_require__(54);
const proposals_entity_1 = __webpack_require__(56);
let ProposalPricingSummaryEntity = class ProposalPricingSummaryEntity {
};
exports.ProposalPricingSummaryEntity = ProposalPricingSummaryEntity;
tslib_1.__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)('uuid'),
    tslib_1.__metadata("design:type", String)
], ProposalPricingSummaryEntity.prototype, "id", void 0);
tslib_1.__decorate([
    (0, typeorm_1.OneToOne)(() => proposals_entity_1.ProposalsEntity, proposal => proposal.proposal_pricing_summary),
    (0, typeorm_1.JoinColumn)({ name: 'proposal_id', referencedColumnName: 'id' }),
    tslib_1.__metadata("design:type", typeof (_a = typeof proposals_entity_1.ProposalsEntity !== "undefined" && proposals_entity_1.ProposalsEntity) === "function" ? _a : Object)
], ProposalPricingSummaryEntity.prototype, "proposal", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'decimal', precision: 15, scale: 2 }),
    tslib_1.__metadata("design:type", Number)
], ProposalPricingSummaryEntity.prototype, "subtotal", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'decimal', precision: 15, scale: 2 }),
    tslib_1.__metadata("design:type", Number)
], ProposalPricingSummaryEntity.prototype, "shipping_fee", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'decimal', precision: 15, scale: 2 }),
    tslib_1.__metadata("design:type", Number)
], ProposalPricingSummaryEntity.prototype, "markup", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'decimal', precision: 15, scale: 2 }),
    tslib_1.__metadata("design:type", Number)
], ProposalPricingSummaryEntity.prototype, "misc", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'decimal', precision: 15, scale: 2 }),
    tslib_1.__metadata("design:type", Number)
], ProposalPricingSummaryEntity.prototype, "approval_discount", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'decimal', precision: 15, scale: 2 }),
    tslib_1.__metadata("design:type", Number)
], ProposalPricingSummaryEntity.prototype, "discount_percent", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'decimal', precision: 15, scale: 2 }),
    tslib_1.__metadata("design:type", Number)
], ProposalPricingSummaryEntity.prototype, "discount_amount", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'decimal', precision: 15, scale: 2 }),
    tslib_1.__metadata("design:type", Number)
], ProposalPricingSummaryEntity.prototype, "total_ex_vat", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'decimal', precision: 15, scale: 2 }),
    tslib_1.__metadata("design:type", Number)
], ProposalPricingSummaryEntity.prototype, "total_inc_vat", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'decimal', precision: 15, scale: 2 }),
    tslib_1.__metadata("design:type", Number)
], ProposalPricingSummaryEntity.prototype, "total_profit", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'decimal', precision: 15, scale: 2 }),
    tslib_1.__metadata("design:type", Number)
], ProposalPricingSummaryEntity.prototype, "grand_total", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    tslib_1.__metadata("design:type", String)
], ProposalPricingSummaryEntity.prototype, "lead_time", void 0);
tslib_1.__decorate([
    (0, typeorm_1.CreateDateColumn)(),
    tslib_1.__metadata("design:type", typeof (_b = typeof Date !== "undefined" && Date) === "function" ? _b : Object)
], ProposalPricingSummaryEntity.prototype, "created_at", void 0);
tslib_1.__decorate([
    (0, typeorm_1.UpdateDateColumn)(),
    tslib_1.__metadata("design:type", typeof (_c = typeof Date !== "undefined" && Date) === "function" ? _c : Object)
], ProposalPricingSummaryEntity.prototype, "updated_at", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'varchar' }),
    tslib_1.__metadata("design:type", typeof (_d = typeof proposals_response_interface_1.ProposalPricingSummaryStatus !== "undefined" && proposals_response_interface_1.ProposalPricingSummaryStatus) === "function" ? _d : Object)
], ProposalPricingSummaryEntity.prototype, "status", void 0);
exports.ProposalPricingSummaryEntity = ProposalPricingSummaryEntity = tslib_1.__decorate([
    (0, typeorm_1.Entity)('proposal_pricing_summary')
], ProposalPricingSummaryEntity);


/***/ }),
/* 58 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a, _b, _c, _d, _e, _f, _g, _h;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UpdateMonitoringsDto = exports.CreateMonitoringsDto = void 0;
const tslib_1 = __webpack_require__(4);
const class_validator_1 = __webpack_require__(24);
const monitorings_response_interface_1 = __webpack_require__(52);
const enums_utils_1 = __webpack_require__(16);
class CreateMonitoringsDto {
}
exports.CreateMonitoringsDto = CreateMonitoringsDto;
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(monitorings_response_interface_1.MonitoringStatus),
    tslib_1.__metadata("design:type", typeof (_a = typeof monitorings_response_interface_1.MonitoringStatus !== "undefined" && monitorings_response_interface_1.MonitoringStatus) === "function" ? _a : Object)
], CreateMonitoringsDto.prototype, "status", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CreateMonitoringsDto.prototype, "category", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CreateMonitoringsDto.prototype, "monitoring_remarks", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], CreateMonitoringsDto.prototype, "buying_amount_vat_inc", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], CreateMonitoringsDto.prototype, "selling_amount_vat_inc", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], CreateMonitoringsDto.prototype, "estimated_gross_profit", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], CreateMonitoringsDto.prototype, "mark_up", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], CreateMonitoringsDto.prototype, "selling_amount_vat_ex", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CreateMonitoringsDto.prototype, "project_code", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(enums_utils_1.Industry),
    tslib_1.__metadata("design:type", typeof (_b = typeof enums_utils_1.Industry !== "undefined" && enums_utils_1.Industry) === "function" ? _b : Object)
], CreateMonitoringsDto.prototype, "industry", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(enums_utils_1.ProductCategory),
    tslib_1.__metadata("design:type", typeof (_c = typeof enums_utils_1.ProductCategory !== "undefined" && enums_utils_1.ProductCategory) === "function" ? _c : Object)
], CreateMonitoringsDto.prototype, "product_category", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(enums_utils_1.Brand),
    tslib_1.__metadata("design:type", typeof (_d = typeof enums_utils_1.Brand !== "undefined" && enums_utils_1.Brand) === "function" ? _d : Object)
], CreateMonitoringsDto.prototype, "brand", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CreateMonitoringsDto.prototype, "project_name", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], CreateMonitoringsDto.prototype, "proposal_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], CreateMonitoringsDto.prototype, "company_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], CreateMonitoringsDto.prototype, "created_by_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], CreateMonitoringsDto.prototype, "updated_by_id", void 0);
class UpdateMonitoringsDto {
}
exports.UpdateMonitoringsDto = UpdateMonitoringsDto;
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], UpdateMonitoringsDto.prototype, "id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEnum)(monitorings_response_interface_1.MonitoringStatus),
    tslib_1.__metadata("design:type", typeof (_e = typeof monitorings_response_interface_1.MonitoringStatus !== "undefined" && monitorings_response_interface_1.MonitoringStatus) === "function" ? _e : Object)
], UpdateMonitoringsDto.prototype, "status", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateMonitoringsDto.prototype, "category", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateMonitoringsDto.prototype, "monitoring_remarks", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], UpdateMonitoringsDto.prototype, "buying_amount_vat_inc", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], UpdateMonitoringsDto.prototype, "selling_amount_vat_inc", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], UpdateMonitoringsDto.prototype, "estimated_gross_profit", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], UpdateMonitoringsDto.prototype, "mark_up", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], UpdateMonitoringsDto.prototype, "selling_amount_vat_ex", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateMonitoringsDto.prototype, "project_code", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEnum)(enums_utils_1.Industry),
    tslib_1.__metadata("design:type", typeof (_f = typeof enums_utils_1.Industry !== "undefined" && enums_utils_1.Industry) === "function" ? _f : Object)
], UpdateMonitoringsDto.prototype, "industry", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEnum)(enums_utils_1.ProductCategory),
    tslib_1.__metadata("design:type", typeof (_g = typeof enums_utils_1.ProductCategory !== "undefined" && enums_utils_1.ProductCategory) === "function" ? _g : Object)
], UpdateMonitoringsDto.prototype, "product_category", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEnum)(enums_utils_1.Brand),
    tslib_1.__metadata("design:type", typeof (_h = typeof enums_utils_1.Brand !== "undefined" && enums_utils_1.Brand) === "function" ? _h : Object)
], UpdateMonitoringsDto.prototype, "brand", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateMonitoringsDto.prototype, "project_name", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], UpdateMonitoringsDto.prototype, "company_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], UpdateMonitoringsDto.prototype, "updated_by_id", void 0);


/***/ }),
/* 59 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UpdateProposalPricingSummaryDto = exports.CreateProposalPricingSummaryDto = exports.UpdateProposalItemsDto = exports.CreateProposalItemsDto = exports.UpdateProposalAttachmentsDto = exports.CreateProposalAttachmentsDto = exports.UpdateProposalsDto = exports.CreateProposalsDto = void 0;
const tslib_1 = __webpack_require__(4);
const class_validator_1 = __webpack_require__(24);
const enums_utils_1 = __webpack_require__(16);
const proposals_response_interface_1 = __webpack_require__(54);
class CreateProposalsDto {
}
exports.CreateProposalsDto = CreateProposalsDto;
tslib_1.__decorate([
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CreateProposalsDto.prototype, "project_name", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CreateProposalsDto.prototype, "project_code", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(enums_utils_1.CategoryTypes),
    tslib_1.__metadata("design:type", typeof (_a = typeof enums_utils_1.CategoryTypes !== "undefined" && enums_utils_1.CategoryTypes) === "function" ? _a : Object)
], CreateProposalsDto.prototype, "category", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(enums_utils_1.ProductCategory),
    tslib_1.__metadata("design:type", typeof (_b = typeof enums_utils_1.ProductCategory !== "undefined" && enums_utils_1.ProductCategory) === "function" ? _b : Object)
], CreateProposalsDto.prototype, "product_category", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(proposals_response_interface_1.ProposalCompanies),
    tslib_1.__metadata("design:type", typeof (_c = typeof proposals_response_interface_1.ProposalCompanies !== "undefined" && proposals_response_interface_1.ProposalCompanies) === "function" ? _c : Object)
], CreateProposalsDto.prototype, "company", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsDateString)(),
    tslib_1.__metadata("design:type", String)
], CreateProposalsDto.prototype, "selected_date", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CreateProposalsDto.prototype, "customer_ref", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CreateProposalsDto.prototype, "quotation_number", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(proposals_response_interface_1.ProposalPaymentTerms),
    tslib_1.__metadata("design:type", typeof (_d = typeof proposals_response_interface_1.ProposalPaymentTerms !== "undefined" && proposals_response_interface_1.ProposalPaymentTerms) === "function" ? _d : Object)
], CreateProposalsDto.prototype, "payment_terms", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(proposals_response_interface_1.ProposalValidity),
    tslib_1.__metadata("design:type", typeof (_e = typeof proposals_response_interface_1.ProposalValidity !== "undefined" && proposals_response_interface_1.ProposalValidity) === "function" ? _e : Object)
], CreateProposalsDto.prototype, "quote_validity", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(proposals_response_interface_1.ProposalWarranty),
    tslib_1.__metadata("design:type", typeof (_f = typeof proposals_response_interface_1.ProposalWarranty !== "undefined" && proposals_response_interface_1.ProposalWarranty) === "function" ? _f : Object)
], CreateProposalsDto.prototype, "warranty", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CreateProposalsDto.prototype, "company_remarks", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(proposals_response_interface_1.ProposalStatus),
    tslib_1.__metadata("design:type", typeof (_g = typeof proposals_response_interface_1.ProposalStatus !== "undefined" && proposals_response_interface_1.ProposalStatus) === "function" ? _g : Object)
], CreateProposalsDto.prototype, "status", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], CreateProposalsDto.prototype, "company_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], CreateProposalsDto.prototype, "created_by_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], CreateProposalsDto.prototype, "updated_by_id", void 0);
class UpdateProposalsDto {
}
exports.UpdateProposalsDto = UpdateProposalsDto;
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], UpdateProposalsDto.prototype, "id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateProposalsDto.prototype, "project_name", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateProposalsDto.prototype, "project_code", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEnum)(enums_utils_1.CategoryTypes),
    tslib_1.__metadata("design:type", typeof (_h = typeof enums_utils_1.CategoryTypes !== "undefined" && enums_utils_1.CategoryTypes) === "function" ? _h : Object)
], UpdateProposalsDto.prototype, "category", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEnum)(enums_utils_1.ProductCategory),
    tslib_1.__metadata("design:type", typeof (_j = typeof enums_utils_1.ProductCategory !== "undefined" && enums_utils_1.ProductCategory) === "function" ? _j : Object)
], UpdateProposalsDto.prototype, "product_category", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEnum)(proposals_response_interface_1.ProposalCompanies),
    tslib_1.__metadata("design:type", typeof (_k = typeof proposals_response_interface_1.ProposalCompanies !== "undefined" && proposals_response_interface_1.ProposalCompanies) === "function" ? _k : Object)
], UpdateProposalsDto.prototype, "company", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsDateString)(),
    tslib_1.__metadata("design:type", String)
], UpdateProposalsDto.prototype, "selected_date", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateProposalsDto.prototype, "customer_ref", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateProposalsDto.prototype, "quotation_number", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEnum)(proposals_response_interface_1.ProposalPaymentTerms),
    tslib_1.__metadata("design:type", typeof (_l = typeof proposals_response_interface_1.ProposalPaymentTerms !== "undefined" && proposals_response_interface_1.ProposalPaymentTerms) === "function" ? _l : Object)
], UpdateProposalsDto.prototype, "payment_terms", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEnum)(proposals_response_interface_1.ProposalValidity),
    tslib_1.__metadata("design:type", typeof (_m = typeof proposals_response_interface_1.ProposalValidity !== "undefined" && proposals_response_interface_1.ProposalValidity) === "function" ? _m : Object)
], UpdateProposalsDto.prototype, "quote_validity", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEnum)(proposals_response_interface_1.ProposalWarranty),
    tslib_1.__metadata("design:type", typeof (_o = typeof proposals_response_interface_1.ProposalWarranty !== "undefined" && proposals_response_interface_1.ProposalWarranty) === "function" ? _o : Object)
], UpdateProposalsDto.prototype, "warranty", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateProposalsDto.prototype, "company_remarks", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEnum)(proposals_response_interface_1.ProposalStatus),
    tslib_1.__metadata("design:type", typeof (_p = typeof proposals_response_interface_1.ProposalStatus !== "undefined" && proposals_response_interface_1.ProposalStatus) === "function" ? _p : Object)
], UpdateProposalsDto.prototype, "status", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], UpdateProposalsDto.prototype, "company_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], UpdateProposalsDto.prototype, "updated_by_id", void 0);
// Attachments DTO
class CreateProposalAttachmentsDto {
}
exports.CreateProposalAttachmentsDto = CreateProposalAttachmentsDto;
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], CreateProposalAttachmentsDto.prototype, "proposal_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], CreateProposalAttachmentsDto.prototype, "attachment_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(proposals_response_interface_1.ProposalAttachmentsStatus),
    tslib_1.__metadata("design:type", typeof (_q = typeof proposals_response_interface_1.ProposalAttachmentsStatus !== "undefined" && proposals_response_interface_1.ProposalAttachmentsStatus) === "function" ? _q : Object)
], CreateProposalAttachmentsDto.prototype, "status", void 0);
class UpdateProposalAttachmentsDto {
}
exports.UpdateProposalAttachmentsDto = UpdateProposalAttachmentsDto;
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], UpdateProposalAttachmentsDto.prototype, "proposal_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], UpdateProposalAttachmentsDto.prototype, "attachment_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(proposals_response_interface_1.ProposalAttachmentsStatus),
    tslib_1.__metadata("design:type", typeof (_r = typeof proposals_response_interface_1.ProposalAttachmentsStatus !== "undefined" && proposals_response_interface_1.ProposalAttachmentsStatus) === "function" ? _r : Object)
], UpdateProposalAttachmentsDto.prototype, "status", void 0);
// Proposal Items DTO
class CreateProposalItemsDto {
}
exports.CreateProposalItemsDto = CreateProposalItemsDto;
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CreateProposalItemsDto.prototype, "item_details", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CreateProposalItemsDto.prototype, "description", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], CreateProposalItemsDto.prototype, "quantity", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CreateProposalItemsDto.prototype, "uom", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], CreateProposalItemsDto.prototype, "buying_vat_inc", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], CreateProposalItemsDto.prototype, "total_buying", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], CreateProposalItemsDto.prototype, "shipping_fee", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], CreateProposalItemsDto.prototype, "wsf", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], CreateProposalItemsDto.prototype, "markup", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], CreateProposalItemsDto.prototype, "sp", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], CreateProposalItemsDto.prototype, "sp_each", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], CreateProposalItemsDto.prototype, "misc", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], CreateProposalItemsDto.prototype, "tpc_price", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], CreateProposalItemsDto.prototype, "fsp", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], CreateProposalItemsDto.prototype, "fsp_each", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], CreateProposalItemsDto.prototype, "profit_each", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], CreateProposalItemsDto.prototype, "total_profit", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CreateProposalItemsDto.prototype, "delivery", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CreateProposalItemsDto.prototype, "project", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CreateProposalItemsDto.prototype, "lof", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CreateProposalItemsDto.prototype, "aof", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CreateProposalItemsDto.prototype, "srf", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CreateProposalItemsDto.prototype, "lsf", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(enums_utils_1.Brand),
    tslib_1.__metadata("design:type", typeof (_s = typeof enums_utils_1.Brand !== "undefined" && enums_utils_1.Brand) === "function" ? _s : Object)
], CreateProposalItemsDto.prototype, "brand", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], CreateProposalItemsDto.prototype, "proposal_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], CreateProposalItemsDto.prototype, "attachment_item_img", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(proposals_response_interface_1.ProposalItemStatus),
    tslib_1.__metadata("design:type", typeof (_t = typeof proposals_response_interface_1.ProposalItemStatus !== "undefined" && proposals_response_interface_1.ProposalItemStatus) === "function" ? _t : Object)
], CreateProposalItemsDto.prototype, "status", void 0);
class UpdateProposalItemsDto {
}
exports.UpdateProposalItemsDto = UpdateProposalItemsDto;
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], UpdateProposalItemsDto.prototype, "id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateProposalItemsDto.prototype, "item_details", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateProposalItemsDto.prototype, "description", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], UpdateProposalItemsDto.prototype, "quantity", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateProposalItemsDto.prototype, "uom", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], UpdateProposalItemsDto.prototype, "buying_vat_inc", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], UpdateProposalItemsDto.prototype, "total_buying", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], UpdateProposalItemsDto.prototype, "shipping_fee", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], UpdateProposalItemsDto.prototype, "wsf", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], UpdateProposalItemsDto.prototype, "markup", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], UpdateProposalItemsDto.prototype, "sp", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], UpdateProposalItemsDto.prototype, "sp_each", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], UpdateProposalItemsDto.prototype, "misc", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], UpdateProposalItemsDto.prototype, "tpc_price", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], UpdateProposalItemsDto.prototype, "fsp", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], UpdateProposalItemsDto.prototype, "fsp_each", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], UpdateProposalItemsDto.prototype, "profit_each", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], UpdateProposalItemsDto.prototype, "total_profit", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateProposalItemsDto.prototype, "delivery", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateProposalItemsDto.prototype, "project", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateProposalItemsDto.prototype, "lof", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateProposalItemsDto.prototype, "aof", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateProposalItemsDto.prototype, "srf", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateProposalItemsDto.prototype, "lsf", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEnum)(enums_utils_1.Brand),
    tslib_1.__metadata("design:type", typeof (_u = typeof enums_utils_1.Brand !== "undefined" && enums_utils_1.Brand) === "function" ? _u : Object)
], UpdateProposalItemsDto.prototype, "brand", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], UpdateProposalItemsDto.prototype, "attachment_item_img", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEnum)(proposals_response_interface_1.ProposalItemStatus),
    tslib_1.__metadata("design:type", typeof (_v = typeof proposals_response_interface_1.ProposalItemStatus !== "undefined" && proposals_response_interface_1.ProposalItemStatus) === "function" ? _v : Object)
], UpdateProposalItemsDto.prototype, "status", void 0);
// Proposal Pricing Summary DTO
class CreateProposalPricingSummaryDto {
}
exports.CreateProposalPricingSummaryDto = CreateProposalPricingSummaryDto;
tslib_1.__decorate([
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], CreateProposalPricingSummaryDto.prototype, "subtotal", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], CreateProposalPricingSummaryDto.prototype, "shipping_fee", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], CreateProposalPricingSummaryDto.prototype, "markup", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], CreateProposalPricingSummaryDto.prototype, "misc", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], CreateProposalPricingSummaryDto.prototype, "approval_discount", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], CreateProposalPricingSummaryDto.prototype, "discount_percent", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], CreateProposalPricingSummaryDto.prototype, "discount_amount", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], CreateProposalPricingSummaryDto.prototype, "total_ex_vat", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], CreateProposalPricingSummaryDto.prototype, "total_inc_vat", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], CreateProposalPricingSummaryDto.prototype, "total_profit", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], CreateProposalPricingSummaryDto.prototype, "grand_total", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CreateProposalPricingSummaryDto.prototype, "lead_time", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], CreateProposalPricingSummaryDto.prototype, "proposal_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(proposals_response_interface_1.ProposalPricingSummaryStatus),
    tslib_1.__metadata("design:type", typeof (_w = typeof proposals_response_interface_1.ProposalPricingSummaryStatus !== "undefined" && proposals_response_interface_1.ProposalPricingSummaryStatus) === "function" ? _w : Object)
], CreateProposalPricingSummaryDto.prototype, "status", void 0);
class UpdateProposalPricingSummaryDto {
}
exports.UpdateProposalPricingSummaryDto = UpdateProposalPricingSummaryDto;
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], UpdateProposalPricingSummaryDto.prototype, "id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], UpdateProposalPricingSummaryDto.prototype, "subtotal", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], UpdateProposalPricingSummaryDto.prototype, "shipping_fee", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], UpdateProposalPricingSummaryDto.prototype, "markup", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], UpdateProposalPricingSummaryDto.prototype, "misc", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], UpdateProposalPricingSummaryDto.prototype, "approval_discount", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], UpdateProposalPricingSummaryDto.prototype, "discount_percent", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], UpdateProposalPricingSummaryDto.prototype, "discount_amount", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], UpdateProposalPricingSummaryDto.prototype, "total_ex_vat", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], UpdateProposalPricingSummaryDto.prototype, "total_inc_vat", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], UpdateProposalPricingSummaryDto.prototype, "total_profit", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    tslib_1.__metadata("design:type", Number)
], UpdateProposalPricingSummaryDto.prototype, "grand_total", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateProposalPricingSummaryDto.prototype, "lead_time", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEnum)(proposals_response_interface_1.ProposalPricingSummaryStatus),
    tslib_1.__metadata("design:type", typeof (_x = typeof proposals_response_interface_1.ProposalPricingSummaryStatus !== "undefined" && proposals_response_interface_1.ProposalPricingSummaryStatus) === "function" ? _x : Object)
], UpdateProposalPricingSummaryDto.prototype, "status", void 0);


/***/ }),
/* 60 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a, _b, _c, _d, _e, _f, _g, _h;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SalesDto = exports.SaleAttachmentsDto = void 0;
const tslib_1 = __webpack_require__(4);
const class_validator_1 = __webpack_require__(24);
const class_transformer_1 = __webpack_require__(25);
const sales_response_interface_1 = __webpack_require__(61);
const users_dto_1 = __webpack_require__(34);
const monitorings_dto_1 = __webpack_require__(51);
const attachments_dto_1 = __webpack_require__(23);
const enums_utils_1 = __webpack_require__(16);
class SaleAttachmentsDto {
}
exports.SaleAttachmentsDto = SaleAttachmentsDto;
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], SaleAttachmentsDto.prototype, "sales_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => attachments_dto_1.AttachmentsDto),
    tslib_1.__metadata("design:type", typeof (_a = typeof attachments_dto_1.AttachmentsDto !== "undefined" && attachments_dto_1.AttachmentsDto) === "function" ? _a : Object)
], SaleAttachmentsDto.prototype, "attachment", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(sales_response_interface_1.SalesAttachmentsStatus),
    tslib_1.__metadata("design:type", typeof (_b = typeof sales_response_interface_1.SalesAttachmentsStatus !== "undefined" && sales_response_interface_1.SalesAttachmentsStatus) === "function" ? _b : Object)
], SaleAttachmentsDto.prototype, "status", void 0);
class SalesDto {
}
exports.SalesDto = SalesDto;
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], SalesDto.prototype, "id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(sales_response_interface_1.SalesQuarters),
    tslib_1.__metadata("design:type", typeof (_c = typeof sales_response_interface_1.SalesQuarters !== "undefined" && sales_response_interface_1.SalesQuarters) === "function" ? _c : Object)
], SalesDto.prototype, "quarter", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(sales_response_interface_1.SalesStatus),
    tslib_1.__metadata("design:type", typeof (_d = typeof sales_response_interface_1.SalesStatus !== "undefined" && sales_response_interface_1.SalesStatus) === "function" ? _d : Object)
], SalesDto.prototype, "status", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(enums_utils_1.CategoryTypes),
    tslib_1.__metadata("design:type", typeof (_e = typeof enums_utils_1.CategoryTypes !== "undefined" && enums_utils_1.CategoryTypes) === "function" ? _e : Object)
], SalesDto.prototype, "category", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], SalesDto.prototype, "po_number", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], SalesDto.prototype, "invoice_number", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], SalesDto.prototype, "dr_number", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], SalesDto.prototype, "sales_remark", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsDateString)(),
    tslib_1.__metadata("design:type", String)
], SalesDto.prototype, "created_at", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsDateString)(),
    tslib_1.__metadata("design:type", String)
], SalesDto.prototype, "updated_at", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => users_dto_1.MiniUsersDto),
    tslib_1.__metadata("design:type", typeof (_f = typeof users_dto_1.MiniUsersDto !== "undefined" && users_dto_1.MiniUsersDto) === "function" ? _f : Object)
], SalesDto.prototype, "created_by", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => users_dto_1.MiniUsersDto),
    tslib_1.__metadata("design:type", typeof (_g = typeof users_dto_1.MiniUsersDto !== "undefined" && users_dto_1.MiniUsersDto) === "function" ? _g : Object)
], SalesDto.prototype, "updated_by", void 0);
tslib_1.__decorate([
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => monitorings_dto_1.MonitoringsDto),
    tslib_1.__metadata("design:type", typeof (_h = typeof monitorings_dto_1.MonitoringsDto !== "undefined" && monitorings_dto_1.MonitoringsDto) === "function" ? _h : Object)
], SalesDto.prototype, "monitoring", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsArray)(),
    (0, class_validator_1.ValidateNested)({ each: true }),
    (0, class_transformer_1.Type)(() => SaleAttachmentsDto),
    tslib_1.__metadata("design:type", Array)
], SalesDto.prototype, "attachments", void 0);


/***/ }),
/* 61 */
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SalesQuarters = exports.SalesStatus = exports.SalesAttachmentsStatus = void 0;
var SalesAttachmentsStatus;
(function (SalesAttachmentsStatus) {
    SalesAttachmentsStatus["ACTIVE"] = "ACTIVE";
    SalesAttachmentsStatus["DELETED"] = "DELETED";
})(SalesAttachmentsStatus || (exports.SalesAttachmentsStatus = SalesAttachmentsStatus = {}));
var SalesStatus;
(function (SalesStatus) {
    SalesStatus["IN_PROGRESS"] = "In Progress";
    SalesStatus["PO_FOLLOW_UP"] = "PO to Follow";
    SalesStatus["DELIVERED"] = "Delivered";
    SalesStatus["COLLECTED"] = "Collected";
    SalesStatus["DELETED"] = "Deleted";
})(SalesStatus || (exports.SalesStatus = SalesStatus = {}));
var SalesQuarters;
(function (SalesQuarters) {
    SalesQuarters["Q1"] = "Q1";
    SalesQuarters["Q2"] = "Q2";
    SalesQuarters["Q3"] = "Q3";
    SalesQuarters["Q4"] = "Q4";
})(SalesQuarters || (exports.SalesQuarters = SalesQuarters = {}));


/***/ }),
/* 62 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SaleAttachmentsEntity = exports.SalesEntity = void 0;
const tslib_1 = __webpack_require__(4);
const typeorm_1 = __webpack_require__(8);
const sales_response_interface_1 = __webpack_require__(61);
const user_entity_1 = __webpack_require__(39);
const monitorings_entity_1 = __webpack_require__(55);
const attachments_entity_1 = __webpack_require__(28);
const enums_utils_1 = __webpack_require__(16);
let SalesEntity = class SalesEntity {
};
exports.SalesEntity = SalesEntity;
tslib_1.__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)('uuid'),
    tslib_1.__metadata("design:type", String)
], SalesEntity.prototype, "id", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'varchar' }),
    tslib_1.__metadata("design:type", typeof (_a = typeof sales_response_interface_1.SalesQuarters !== "undefined" && sales_response_interface_1.SalesQuarters) === "function" ? _a : Object)
], SalesEntity.prototype, "quarter", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'varchar' }),
    tslib_1.__metadata("design:type", typeof (_b = typeof sales_response_interface_1.SalesStatus !== "undefined" && sales_response_interface_1.SalesStatus) === "function" ? _b : Object)
], SalesEntity.prototype, "status", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'varchar' }),
    tslib_1.__metadata("design:type", typeof (_c = typeof enums_utils_1.CategoryTypes !== "undefined" && enums_utils_1.CategoryTypes) === "function" ? _c : Object)
], SalesEntity.prototype, "category", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    tslib_1.__metadata("design:type", String)
], SalesEntity.prototype, "po_number", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    tslib_1.__metadata("design:type", String)
], SalesEntity.prototype, "invoice_number", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    tslib_1.__metadata("design:type", String)
], SalesEntity.prototype, "dr_number", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'text', nullable: true }),
    tslib_1.__metadata("design:type", String)
], SalesEntity.prototype, "sales_remark", void 0);
tslib_1.__decorate([
    (0, typeorm_1.CreateDateColumn)(),
    tslib_1.__metadata("design:type", typeof (_d = typeof Date !== "undefined" && Date) === "function" ? _d : Object)
], SalesEntity.prototype, "created_at", void 0);
tslib_1.__decorate([
    (0, typeorm_1.UpdateDateColumn)(),
    tslib_1.__metadata("design:type", typeof (_e = typeof Date !== "undefined" && Date) === "function" ? _e : Object)
], SalesEntity.prototype, "updated_at", void 0);
tslib_1.__decorate([
    (0, typeorm_1.ManyToOne)(() => user_entity_1.UsersEntity, { nullable: true }),
    (0, typeorm_1.JoinColumn)({ name: 'created_by_id' }),
    tslib_1.__metadata("design:type", typeof (_f = typeof user_entity_1.UsersEntity !== "undefined" && user_entity_1.UsersEntity) === "function" ? _f : Object)
], SalesEntity.prototype, "created_by", void 0);
tslib_1.__decorate([
    (0, typeorm_1.ManyToOne)(() => user_entity_1.UsersEntity, { nullable: true }),
    (0, typeorm_1.JoinColumn)({ name: 'updated_by_id' }),
    tslib_1.__metadata("design:type", typeof (_g = typeof user_entity_1.UsersEntity !== "undefined" && user_entity_1.UsersEntity) === "function" ? _g : Object)
], SalesEntity.prototype, "updated_by", void 0);
tslib_1.__decorate([
    (0, typeorm_1.ManyToOne)(() => monitorings_entity_1.MonitoringsEntity, { nullable: false }),
    (0, typeorm_1.JoinColumn)({ name: 'monitoring_id' }),
    tslib_1.__metadata("design:type", typeof (_h = typeof monitorings_entity_1.MonitoringsEntity !== "undefined" && monitorings_entity_1.MonitoringsEntity) === "function" ? _h : Object)
], SalesEntity.prototype, "monitoring", void 0);
tslib_1.__decorate([
    (0, typeorm_1.OneToMany)(() => SaleAttachmentsEntity, attachment => attachment.sale, { cascade: true }),
    tslib_1.__metadata("design:type", Array)
], SalesEntity.prototype, "attachments", void 0);
exports.SalesEntity = SalesEntity = tslib_1.__decorate([
    (0, typeorm_1.Entity)('sales')
], SalesEntity);
let SaleAttachmentsEntity = class SaleAttachmentsEntity {
};
exports.SaleAttachmentsEntity = SaleAttachmentsEntity;
tslib_1.__decorate([
    (0, typeorm_1.PrimaryColumn)('uuid', { name: 'sales_id' }),
    tslib_1.__metadata("design:type", String)
], SaleAttachmentsEntity.prototype, "sales_id", void 0);
tslib_1.__decorate([
    (0, typeorm_1.ManyToOne)(() => SalesEntity, sale => sale.attachments, {
        nullable: false,
        onDelete: 'CASCADE',
    }),
    (0, typeorm_1.JoinColumn)({ name: 'sales_id' }),
    tslib_1.__metadata("design:type", SalesEntity)
], SaleAttachmentsEntity.prototype, "sale", void 0);
tslib_1.__decorate([
    (0, typeorm_1.PrimaryColumn)('uuid', { name: 'attachment_id' }),
    tslib_1.__metadata("design:type", String)
], SaleAttachmentsEntity.prototype, "attachment_id", void 0);
tslib_1.__decorate([
    (0, typeorm_1.ManyToOne)(() => attachments_entity_1.AttachmentsEntity, { nullable: false }),
    (0, typeorm_1.JoinColumn)({ name: 'attachment_id' }),
    tslib_1.__metadata("design:type", typeof (_j = typeof attachments_entity_1.AttachmentsEntity !== "undefined" && attachments_entity_1.AttachmentsEntity) === "function" ? _j : Object)
], SaleAttachmentsEntity.prototype, "attachment", void 0);
tslib_1.__decorate([
    (0, typeorm_1.Column)({ type: 'enum', enum: sales_response_interface_1.SalesAttachmentsStatus }),
    tslib_1.__metadata("design:type", typeof (_k = typeof sales_response_interface_1.SalesAttachmentsStatus !== "undefined" && sales_response_interface_1.SalesAttachmentsStatus) === "function" ? _k : Object)
], SaleAttachmentsEntity.prototype, "status", void 0);
exports.SaleAttachmentsEntity = SaleAttachmentsEntity = tslib_1.__decorate([
    (0, typeorm_1.Entity)('sales_attachments')
], SaleAttachmentsEntity);


/***/ }),
/* 63 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a, _b, _c, _d, _e, _f, _g, _h;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UpdateSaleAttachmentsDto = exports.CreateSaleAttachmentsDto = exports.UpdateSalesDto = exports.CreateSalesDto = void 0;
const tslib_1 = __webpack_require__(4);
const class_validator_1 = __webpack_require__(24);
const enums_utils_1 = __webpack_require__(16);
const sales_response_interface_1 = __webpack_require__(61);
class CreateSalesDto {
}
exports.CreateSalesDto = CreateSalesDto;
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(sales_response_interface_1.SalesQuarters),
    tslib_1.__metadata("design:type", typeof (_a = typeof sales_response_interface_1.SalesQuarters !== "undefined" && sales_response_interface_1.SalesQuarters) === "function" ? _a : Object)
], CreateSalesDto.prototype, "quarter", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(sales_response_interface_1.SalesStatus),
    tslib_1.__metadata("design:type", typeof (_b = typeof sales_response_interface_1.SalesStatus !== "undefined" && sales_response_interface_1.SalesStatus) === "function" ? _b : Object)
], CreateSalesDto.prototype, "status", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(enums_utils_1.CategoryTypes),
    tslib_1.__metadata("design:type", typeof (_c = typeof enums_utils_1.CategoryTypes !== "undefined" && enums_utils_1.CategoryTypes) === "function" ? _c : Object)
], CreateSalesDto.prototype, "category", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CreateSalesDto.prototype, "po_number", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CreateSalesDto.prototype, "invoice_number", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CreateSalesDto.prototype, "dr_number", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CreateSalesDto.prototype, "sales_remark", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CreateSalesDto.prototype, "created_by_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], CreateSalesDto.prototype, "updated_by_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    (0, class_validator_1.IsNotEmpty)(),
    tslib_1.__metadata("design:type", String)
], CreateSalesDto.prototype, "monitoring_id", void 0);
class UpdateSalesDto {
}
exports.UpdateSalesDto = UpdateSalesDto;
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    (0, class_validator_1.IsNotEmpty)(),
    tslib_1.__metadata("design:type", String)
], UpdateSalesDto.prototype, "id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEnum)(sales_response_interface_1.SalesQuarters),
    tslib_1.__metadata("design:type", typeof (_d = typeof sales_response_interface_1.SalesQuarters !== "undefined" && sales_response_interface_1.SalesQuarters) === "function" ? _d : Object)
], UpdateSalesDto.prototype, "quarter", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEnum)(sales_response_interface_1.SalesStatus),
    tslib_1.__metadata("design:type", typeof (_e = typeof sales_response_interface_1.SalesStatus !== "undefined" && sales_response_interface_1.SalesStatus) === "function" ? _e : Object)
], UpdateSalesDto.prototype, "status", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEnum)(enums_utils_1.CategoryTypes),
    tslib_1.__metadata("design:type", typeof (_f = typeof enums_utils_1.CategoryTypes !== "undefined" && enums_utils_1.CategoryTypes) === "function" ? _f : Object)
], UpdateSalesDto.prototype, "category", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateSalesDto.prototype, "po_number", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateSalesDto.prototype, "invoice_number", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateSalesDto.prototype, "dr_number", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateSalesDto.prototype, "sales_remark", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateSalesDto.prototype, "updated_by_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], UpdateSalesDto.prototype, "monitoring_id", void 0);
class CreateSaleAttachmentsDto {
}
exports.CreateSaleAttachmentsDto = CreateSaleAttachmentsDto;
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    (0, class_validator_1.IsNotEmpty)(),
    tslib_1.__metadata("design:type", String)
], CreateSaleAttachmentsDto.prototype, "sales_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    (0, class_validator_1.IsNotEmpty)(),
    tslib_1.__metadata("design:type", String)
], CreateSaleAttachmentsDto.prototype, "attachment_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(sales_response_interface_1.SalesAttachmentsStatus),
    tslib_1.__metadata("design:type", typeof (_g = typeof sales_response_interface_1.SalesAttachmentsStatus !== "undefined" && sales_response_interface_1.SalesAttachmentsStatus) === "function" ? _g : Object)
], CreateSaleAttachmentsDto.prototype, "status", void 0);
class UpdateSaleAttachmentsDto {
}
exports.UpdateSaleAttachmentsDto = UpdateSaleAttachmentsDto;
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    (0, class_validator_1.IsNotEmpty)(),
    tslib_1.__metadata("design:type", String)
], UpdateSaleAttachmentsDto.prototype, "sales_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    (0, class_validator_1.IsNotEmpty)(),
    tslib_1.__metadata("design:type", String)
], UpdateSaleAttachmentsDto.prototype, "attachment_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(sales_response_interface_1.SalesAttachmentsStatus),
    tslib_1.__metadata("design:type", typeof (_h = typeof sales_response_interface_1.SalesAttachmentsStatus !== "undefined" && sales_response_interface_1.SalesAttachmentsStatus) === "function" ? _h : Object)
], UpdateSaleAttachmentsDto.prototype, "status", void 0);


/***/ }),
/* 64 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UpdateUser = exports.CreateUser = void 0;
const tslib_1 = __webpack_require__(4);
const class_validator_1 = __webpack_require__(24);
const users_response_interface_1 = __webpack_require__(35);
class CreateUser {
}
exports.CreateUser = CreateUser;
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], CreateUser.prototype, "id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEmail)(),
    tslib_1.__metadata("design:type", String)
], CreateUser.prototype, "email", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(users_response_interface_1.UserRole),
    tslib_1.__metadata("design:type", typeof (_a = typeof users_response_interface_1.UserRole !== "undefined" && users_response_interface_1.UserRole) === "function" ? _a : Object)
], CreateUser.prototype, "role", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    tslib_1.__metadata("design:type", String)
], CreateUser.prototype, "first_name", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    tslib_1.__metadata("design:type", String)
], CreateUser.prototype, "last_name", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    tslib_1.__metadata("design:type", String)
], CreateUser.prototype, "phone_number", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(users_response_interface_1.UserStatus),
    tslib_1.__metadata("design:type", typeof (_b = typeof users_response_interface_1.UserStatus !== "undefined" && users_response_interface_1.UserStatus) === "function" ? _b : Object)
], CreateUser.prototype, "status", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(users_response_interface_1.UserPosition),
    (0, class_validator_1.IsOptional)(),
    tslib_1.__metadata("design:type", typeof (_c = typeof users_response_interface_1.UserPosition !== "undefined" && users_response_interface_1.UserPosition) === "function" ? _c : Object)
], CreateUser.prototype, "position", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], CreateUser.prototype, "created_by_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], CreateUser.prototype, "updated_by_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    (0, class_validator_1.IsOptional)(),
    tslib_1.__metadata("design:type", String)
], CreateUser.prototype, "attachment_signature_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    (0, class_validator_1.IsOptional)(),
    tslib_1.__metadata("design:type", String)
], CreateUser.prototype, "attachment_avatar_id", void 0);
class UpdateUser {
}
exports.UpdateUser = UpdateUser;
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    (0, class_validator_1.IsNotEmpty)(),
    tslib_1.__metadata("design:type", String)
], UpdateUser.prototype, "id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEmail)(),
    tslib_1.__metadata("design:type", String)
], UpdateUser.prototype, "email", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(users_response_interface_1.UserRole),
    tslib_1.__metadata("design:type", typeof (_d = typeof users_response_interface_1.UserRole !== "undefined" && users_response_interface_1.UserRole) === "function" ? _d : Object)
], UpdateUser.prototype, "role", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateUser.prototype, "first_name", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateUser.prototype, "last_name", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateUser.prototype, "phone_number", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEnum)(users_response_interface_1.UserStatus),
    tslib_1.__metadata("design:type", typeof (_e = typeof users_response_interface_1.UserStatus !== "undefined" && users_response_interface_1.UserStatus) === "function" ? _e : Object)
], UpdateUser.prototype, "status", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEnum)(users_response_interface_1.UserPosition),
    tslib_1.__metadata("design:type", typeof (_f = typeof users_response_interface_1.UserPosition !== "undefined" && users_response_interface_1.UserPosition) === "function" ? _f : Object)
], UpdateUser.prototype, "position", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], UpdateUser.prototype, "updated_by_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], UpdateUser.prototype, "attachment_signature_id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], UpdateUser.prototype, "attachment_avatar_id", void 0);


/***/ }),
/* 65 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AuthModule = void 0;
const tslib_1 = __webpack_require__(4);
const common_1 = __webpack_require__(1);
const auth_service_1 = __webpack_require__(66);
const auth_controller_1 = __webpack_require__(80);
const supabase_module_1 = __webpack_require__(9);
const dto_1 = __webpack_require__(22);
const typeorm_1 = __webpack_require__(21);
let AuthModule = class AuthModule {
};
exports.AuthModule = AuthModule;
exports.AuthModule = AuthModule = tslib_1.__decorate([
    (0, common_1.Module)({
        controllers: [auth_controller_1.AuthController],
        providers: [auth_service_1.AuthService],
        imports: [supabase_module_1.SupabaseModule, typeorm_1.TypeOrmModule.forFeature([dto_1.UsersEntity])]
    })
], AuthModule);


/***/ }),
/* 66 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var AuthService_1;
var _a, _b;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AuthService = void 0;
const tslib_1 = __webpack_require__(4);
const common_1 = __webpack_require__(1);
const typeorm_1 = __webpack_require__(21);
const typeorm_2 = __webpack_require__(8);
const supabase_service_1 = __webpack_require__(10);
const dto_1 = __webpack_require__(22);
const interface_1 = __webpack_require__(67);
const utils_1 = __webpack_require__(11);
let AuthService = AuthService_1 = class AuthService {
    constructor(usersRepo, supabase) {
        this.usersRepo = usersRepo;
        this.supabase = supabase;
        this.logger = new common_1.Logger(AuthService_1.name);
    }
    /**
     * Flow:
     * 1. Check if user exists in users table using TypeORM
     * 2. If exists, return error
     * 3. Sign up user via Supabase (confirmation email sent automatically)
     * 4. Save user in MySQL users table
     * 5. Return success
     */
    async signup(dto) {
        try {
            const existingUser = await this.usersRepo.findOne({
                where: { email: dto.email },
            });
            if (existingUser) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.AUTH.USER_EXISTS.CODE,
                    message: utils_1.API_RESPONSE.ERROR.AUTH.USER_EXISTS.MESSAGE,
                    data: null,
                };
            }
            const { data, error } = await this.supabase.client.auth.signUp({
                email: dto.email,
                password: dto.password,
                options: {
                    emailRedirectTo: dto.redirectUrl
                }
            });
            if (error) {
                this.logger.error(error.message, error);
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.AUTH.SIGN_UP.CODE,
                    message: utils_1.API_RESPONSE.ERROR.AUTH.SIGN_UP.MESSAGE,
                    data: error,
                };
            }
            const newUser = this.usersRepo.create({
                id: data.user.id,
                email: dto.email,
                role: interface_1.UserRole.MANAGER,
                status: interface_1.UserStatus.PENDING
            });
            await this.usersRepo.save(newUser);
            newUser.created_by = newUser;
            newUser.updated_by = newUser;
            await this.usersRepo.save(newUser);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.AUTH.SIGN_UP.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.AUTH.SIGN_UP.MESSAGE,
                data: {
                    user: {
                        ...newUser,
                        created_by: (0, utils_1.toMiniUser)(newUser.created_by),
                        updated_by: (0, utils_1.toMiniUser)(newUser.updated_by),
                    }
                },
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.AUTH.SIGN_UP.CODE,
                message: utils_1.API_RESPONSE.ERROR.AUTH.SIGN_UP.MESSAGE,
                data: error,
            };
        }
    }
    /**
     * flow:
     * 1. check if user exist in users table
     * 2. if !exist return error else continue
     * 3. signin user using supabase auth signin
     * 4. if error return error else continue
     * 5. get user data from user db
     * 6. check if first_name, last_name, and position are empty
     * 7. if true return user data, session details, and redirect url to /account-setup
     * 8. if false return user data and session details
    */
    async signin(dto) {
        try {
            const user = await this.usersRepo.findOne({
                where: { email: dto.email },
            });
            if (!user) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.AUTH.USER_NOT_FOUND.CODE,
                    message: utils_1.API_RESPONSE.ERROR.AUTH.USER_NOT_FOUND.MESSAGE,
                    data: null,
                };
            }
            const { data, error } = await this.supabase.client.auth.signInWithPassword({
                email: dto.email,
                password: dto.password
            });
            if (error) {
                this.logger.error(error.message, error);
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.AUTH.SIGN_IN.CODE,
                    message: utils_1.API_RESPONSE.ERROR.AUTH.SIGN_IN.MESSAGE,
                    data: error,
                };
            }
            const isProfileIncomplete = !user.first_name || !user.last_name || !user.position;
            const responseData = {
                user: user,
                session: data.session,
            };
            if (isProfileIncomplete) {
                responseData.redirectUrl = '/account-setup';
            }
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.AUTH.SIGN_IN.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.AUTH.SIGN_IN.MESSAGE,
                data: responseData,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.AUTH.SIGN_IN.CODE,
                message: utils_1.API_RESPONSE.ERROR.AUTH.SIGN_IN.MESSAGE,
                data: error,
            };
        }
    }
    /**
     * flow
     * 1. sign in user with google using supabase oath provider google
     * 2. if error return error else continue
     * 3. check if user exist in user db
     * 4. if !exist create user with the id of supabase auth id then go to step 8
     * 5. else check if first_name, last_name, and position are empty
     * 6. if true go to step 8
     * 7. else go to step 9
     * 8. return user data, session details, and redirect url to /account-setup
     * 9. return user data and session details
     * */
    async signinWithOAth(requestUrl) {
        try {
            const { data, error } = await this.supabase.client.auth.signInWithOAuth({
                provider: 'google',
                options: {
                    redirectTo: `${requestUrl}/sign-in`
                }
            });
            if (error) {
                this.logger.error(error.message, error.stack);
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.AUTH.SIGN_IN.CODE,
                    message: utils_1.API_RESPONSE.ERROR.AUTH.SIGN_IN.MESSAGE,
                    data: error
                };
            }
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.AUTH.SIGN_IN.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.AUTH.SIGN_IN.MESSAGE,
                data: data
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.AUTH.SIGN_IN.CODE,
                message: utils_1.API_RESPONSE.ERROR.AUTH.SIGN_IN.MESSAGE,
                data: error,
            };
        }
    }
    async signout() {
        try {
            const { error } = await this.supabase.client.auth.signOut();
            if (error) {
                this.logger.error(error.message, error.stack);
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.AUTH.SIGN_OUT.CODE,
                    message: utils_1.API_RESPONSE.ERROR.AUTH.SIGN_OUT.MESSAGE,
                    data: error
                };
            }
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.AUTH.SIGN_OUT.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.AUTH.SIGN_OUT.MESSAGE,
                data: true
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.AUTH.SIGN_OUT.CODE,
                message: utils_1.API_RESPONSE.ERROR.AUTH.SIGN_OUT.MESSAGE,
                data: error,
            };
        }
    }
    /**
     * POST /auth/forgot-password/request
     * 1. Check if user exists in MySQL
     * 2. If not, return error
     * 3. Send password reset email via Supabase
     */
    async forgotPasswordRequest(email, redirectTo) {
        try {
            const user = await this.usersRepo.findOne({ where: { email } });
            if (!user) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.AUTH.USER_NOT_FOUND.CODE,
                    message: utils_1.API_RESPONSE.ERROR.AUTH.USER_NOT_FOUND.MESSAGE,
                    data: null,
                };
            }
            const { error } = await this.supabase.client.auth.resetPasswordForEmail(email, {
                redirectTo,
            });
            if (error) {
                this.logger.error(error.message, error);
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.AUTH.RESET_PASSWORD.CODE,
                    message: utils_1.API_RESPONSE.ERROR.AUTH.RESET_PASSWORD.MESSAGE,
                    data: error,
                };
            }
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.AUTH.RESET_PASSWORD.CODE,
                message: 'Password reset email sent. Please check your inbox.',
                data: null,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.AUTH.RESET_PASSWORD.CODE,
                message: utils_1.API_RESPONSE.ERROR.AUTH.RESET_PASSWORD.MESSAGE,
                data: error,
            };
        }
    }
    /**
     * POST /auth/forgot-password/reset
     * 1. Verify the access token via Supabase
     * 2. Update the password using admin client
     */
    async forgotPasswordReset(accessToken, newPassword) {
        try {
            const { data: userData, error: userError } = await this.supabase.client.auth.getUser(accessToken);
            if (userError || !userData?.user) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.AUTH.RESET_PASSWORD.CODE,
                    message: 'Invalid or expired reset token.',
                    data: null,
                };
            }
            const { error } = await this.supabase.clientAdmin.auth.admin.updateUserById(userData.user.id, { password: newPassword });
            if (error) {
                this.logger.error(error.message, error);
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.AUTH.RESET_PASSWORD.CODE,
                    message: utils_1.API_RESPONSE.ERROR.AUTH.RESET_PASSWORD.MESSAGE,
                    data: error,
                };
            }
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.AUTH.RESET_PASSWORD.CODE,
                message: 'Password updated successfully.',
                data: null,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.AUTH.RESET_PASSWORD.CODE,
                message: utils_1.API_RESPONSE.ERROR.AUTH.RESET_PASSWORD.MESSAGE,
                data: error,
            };
        }
    }
    /**
     * POST /auth/resend-confirmation
     * Resend email confirmation for unconfirmed users.
     */
    async resendConfirmation(email) {
        try {
            const user = await this.usersRepo.findOne({ where: { email } });
            if (!user) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.AUTH.USER_NOT_FOUND.CODE,
                    message: utils_1.API_RESPONSE.ERROR.AUTH.USER_NOT_FOUND.MESSAGE,
                    data: null,
                };
            }
            const { error } = await this.supabase.client.auth.resend({
                type: 'signup',
                email,
            });
            if (error) {
                this.logger.error(error.message, error);
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.AUTH.RESEND_CONFIRMATION_LINK.CODE,
                    message: utils_1.API_RESPONSE.ERROR.AUTH.RESEND_CONFIRMATION_LINK.MESSAGE,
                    data: error,
                };
            }
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.AUTH.RESEND_CONFIRMATION_LINK.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.AUTH.RESEND_CONFIRMATION_LINK.MESSAGE,
                data: null,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.AUTH.RESEND_CONFIRMATION_LINK.CODE,
                message: utils_1.API_RESPONSE.ERROR.AUTH.RESEND_CONFIRMATION_LINK.MESSAGE,
                data: error,
            };
        }
    }
};
exports.AuthService = AuthService;
exports.AuthService = AuthService = AuthService_1 = tslib_1.__decorate([
    (0, common_1.Injectable)(),
    tslib_1.__param(0, (0, typeorm_1.InjectRepository)(dto_1.UsersEntity)),
    tslib_1.__metadata("design:paramtypes", [typeof (_a = typeof typeorm_2.Repository !== "undefined" && typeorm_2.Repository) === "function" ? _a : Object, typeof (_b = typeof supabase_service_1.SupabaseService !== "undefined" && supabase_service_1.SupabaseService) === "function" ? _b : Object])
], AuthService);


/***/ }),
/* 67 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
const tslib_1 = __webpack_require__(4);
tslib_1.__exportStar(__webpack_require__(26), exports);
tslib_1.__exportStar(__webpack_require__(68), exports);
tslib_1.__exportStar(__webpack_require__(69), exports);
tslib_1.__exportStar(__webpack_require__(70), exports);
tslib_1.__exportStar(__webpack_require__(33), exports);
tslib_1.__exportStar(__webpack_require__(71), exports);
tslib_1.__exportStar(__webpack_require__(37), exports);
tslib_1.__exportStar(__webpack_require__(72), exports);
tslib_1.__exportStar(__webpack_require__(44), exports);
tslib_1.__exportStar(__webpack_require__(73), exports);
tslib_1.__exportStar(__webpack_require__(48), exports);
tslib_1.__exportStar(__webpack_require__(74), exports);
tslib_1.__exportStar(__webpack_require__(54), exports);
tslib_1.__exportStar(__webpack_require__(75), exports);
tslib_1.__exportStar(__webpack_require__(61), exports);
tslib_1.__exportStar(__webpack_require__(76), exports);
tslib_1.__exportStar(__webpack_require__(35), exports);
tslib_1.__exportStar(__webpack_require__(77), exports);
tslib_1.__exportStar(__webpack_require__(52), exports);
tslib_1.__exportStar(__webpack_require__(78), exports);
tslib_1.__exportStar(__webpack_require__(79), exports);


/***/ }),
/* 68 */
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));


/***/ }),
/* 69 */
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));


/***/ }),
/* 70 */
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));


/***/ }),
/* 71 */
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));


/***/ }),
/* 72 */
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));


/***/ }),
/* 73 */
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));


/***/ }),
/* 74 */
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));


/***/ }),
/* 75 */
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));


/***/ }),
/* 76 */
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));


/***/ }),
/* 77 */
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));


/***/ }),
/* 78 */
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));


/***/ }),
/* 79 */
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ApiResponseStatus = void 0;
var ApiResponseStatus;
(function (ApiResponseStatus) {
    ApiResponseStatus["SUCCESS"] = "SUCCESS";
    ApiResponseStatus["ERROR"] = "ERROR";
})(ApiResponseStatus || (exports.ApiResponseStatus = ApiResponseStatus = {}));


/***/ }),
/* 80 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AuthController = void 0;
const tslib_1 = __webpack_require__(4);
const common_1 = __webpack_require__(1);
const auth_service_1 = __webpack_require__(66);
const dto_1 = __webpack_require__(22);
const class_validator_1 = __webpack_require__(24);
class ForgotPasswordRequestDto {
}
tslib_1.__decorate([
    (0, class_validator_1.IsEmail)(),
    tslib_1.__metadata("design:type", String)
], ForgotPasswordRequestDto.prototype, "email", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], ForgotPasswordRequestDto.prototype, "redirectTo", void 0);
class ForgotPasswordResetDto {
}
tslib_1.__decorate([
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], ForgotPasswordResetDto.prototype, "access_token", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.MinLength)(8),
    tslib_1.__metadata("design:type", String)
], ForgotPasswordResetDto.prototype, "new_password", void 0);
class ResendConfirmationDto {
}
tslib_1.__decorate([
    (0, class_validator_1.IsEmail)(),
    tslib_1.__metadata("design:type", String)
], ResendConfirmationDto.prototype, "email", void 0);
let AuthController = class AuthController {
    constructor(authService) {
        this.authService = authService;
    }
    /**
     * POST /auth/signup
     * Body: { email, password }
     */
    async signup(dto) {
        return this.authService.signup(dto);
    }
    /**
     * POST /auth/signin
     * Body: { email, password }
     */
    async signin(dto) {
        return this.authService.signin(dto);
    }
    /**
     * GET /auth/oauth/google
     * Query param: redirectUrl (your frontend callback URL)
     */
    async signinWithOAuth(redirectUrl) {
        return this.authService.signinWithOAth(redirectUrl);
    }
    /**
     * POST /auth/signout
     */
    async signout() {
        return this.authService.signout();
    }
    /**
     * POST /auth/forgot-password/request
     * Body: { email, redirectTo }
     */
    async forgotPasswordRequest(dto) {
        return this.authService.forgotPasswordRequest(dto.email, dto.redirectTo);
    }
    /**
     * POST /auth/forgot-password/reset
     * Body: { access_token, new_password }
     */
    async forgotPasswordReset(dto) {
        return this.authService.forgotPasswordReset(dto.access_token, dto.new_password);
    }
    /**
     * POST /auth/resend-confirmation
     * Body: { email }
     */
    async resendConfirmation(dto) {
        return this.authService.resendConfirmation(dto.email);
    }
};
exports.AuthController = AuthController;
tslib_1.__decorate([
    (0, common_1.Post)('signup'),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [typeof (_b = typeof dto_1.SignupDto !== "undefined" && dto_1.SignupDto) === "function" ? _b : Object]),
    tslib_1.__metadata("design:returntype", typeof (_c = typeof Promise !== "undefined" && Promise) === "function" ? _c : Object)
], AuthController.prototype, "signup", null);
tslib_1.__decorate([
    (0, common_1.Post)('signin'),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [typeof (_d = typeof dto_1.SigninDto !== "undefined" && dto_1.SigninDto) === "function" ? _d : Object]),
    tslib_1.__metadata("design:returntype", typeof (_e = typeof Promise !== "undefined" && Promise) === "function" ? _e : Object)
], AuthController.prototype, "signin", null);
tslib_1.__decorate([
    (0, common_1.Get)('oauth/google'),
    tslib_1.__param(0, (0, common_1.Query)('redirectUrl')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [String]),
    tslib_1.__metadata("design:returntype", typeof (_f = typeof Promise !== "undefined" && Promise) === "function" ? _f : Object)
], AuthController.prototype, "signinWithOAuth", null);
tslib_1.__decorate([
    (0, common_1.Post)('signout'),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", typeof (_g = typeof Promise !== "undefined" && Promise) === "function" ? _g : Object)
], AuthController.prototype, "signout", null);
tslib_1.__decorate([
    (0, common_1.Post)('forgot-password/request'),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [ForgotPasswordRequestDto]),
    tslib_1.__metadata("design:returntype", typeof (_h = typeof Promise !== "undefined" && Promise) === "function" ? _h : Object)
], AuthController.prototype, "forgotPasswordRequest", null);
tslib_1.__decorate([
    (0, common_1.Post)('forgot-password/reset'),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [ForgotPasswordResetDto]),
    tslib_1.__metadata("design:returntype", typeof (_j = typeof Promise !== "undefined" && Promise) === "function" ? _j : Object)
], AuthController.prototype, "forgotPasswordReset", null);
tslib_1.__decorate([
    (0, common_1.Post)('resend-confirmation'),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [ResendConfirmationDto]),
    tslib_1.__metadata("design:returntype", typeof (_k = typeof Promise !== "undefined" && Promise) === "function" ? _k : Object)
], AuthController.prototype, "resendConfirmation", null);
exports.AuthController = AuthController = tslib_1.__decorate([
    (0, common_1.Controller)('auth'),
    tslib_1.__metadata("design:paramtypes", [typeof (_a = typeof auth_service_1.AuthService !== "undefined" && auth_service_1.AuthService) === "function" ? _a : Object])
], AuthController);


/***/ }),
/* 81 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AttachmentsModule = void 0;
const tslib_1 = __webpack_require__(4);
const common_1 = __webpack_require__(1);
const attachments_service_1 = __webpack_require__(82);
const attachments_controller_1 = __webpack_require__(86);
const typeorm_1 = __webpack_require__(21);
const platform_express_1 = __webpack_require__(87);
const multer_1 = __webpack_require__(89);
const dto_1 = __webpack_require__(22);
let AttachmentsModule = class AttachmentsModule {
};
exports.AttachmentsModule = AttachmentsModule;
exports.AttachmentsModule = AttachmentsModule = tslib_1.__decorate([
    (0, common_1.Module)({
        imports: [
            typeorm_1.TypeOrmModule.forFeature([dto_1.AttachmentsEntity]),
            platform_express_1.MulterModule.register({ storage: (0, multer_1.memoryStorage)() }),
        ],
        controllers: [attachments_controller_1.AttachmentsController],
        providers: [attachments_service_1.AttachmentsService],
        exports: [attachments_service_1.AttachmentsService],
    })
], AttachmentsModule);


/***/ }),
/* 82 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var AttachmentsService_1;
var _a;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AttachmentsService = void 0;
const tslib_1 = __webpack_require__(4);
const dto_1 = __webpack_require__(22);
const interface_1 = __webpack_require__(67);
const utils_1 = __webpack_require__(11);
const common_1 = __webpack_require__(1);
const typeorm_1 = __webpack_require__(21);
const typeorm_2 = __webpack_require__(8);
const fs_1 = __webpack_require__(83);
const path_1 = __webpack_require__(84);
const crypto_1 = __webpack_require__(85);
const ALLOWED_MIME_TYPES = [
    'image/jpeg',
    'image/png',
    'image/gif',
    'image/webp',
    'application/pdf',
    'application/msword',
    'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
    'application/vnd.ms-excel',
    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
];
const MAX_FILE_SIZE = parseInt(process.env.MAX_FILE_SIZE_BYTES || '10485760'); // 10MB default
let AttachmentsService = AttachmentsService_1 = class AttachmentsService {
    constructor(attachmentRepo) {
        this.attachmentRepo = attachmentRepo;
        this.logger = new common_1.Logger(AttachmentsService_1.name);
        this.uploadDir =
            process.env.FILE_UPLOAD_PATH ||
                (0, path_1.join)(process.cwd(), 'file_uploads', 'acc-crm');
        this.baseUrl =
            process.env.FILE_UPLOAD_BASE_URL ||
                'http://localhost:3000/api/attachments/file';
        if (!(0, fs_1.existsSync)(this.uploadDir)) {
            (0, fs_1.mkdirSync)(this.uploadDir, { recursive: true });
        }
    }
    // ====== UPLOAD FILE ======
    async upload(file, bucketName) {
        try {
            if (!ALLOWED_MIME_TYPES.includes(file.mimetype)) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: 400,
                    message: `File type '${file.mimetype}' is not allowed.`,
                    data: null,
                };
            }
            if (file.size > MAX_FILE_SIZE) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: 400,
                    message: `File size exceeds the ${MAX_FILE_SIZE / 1024 / 1024}MB limit.`,
                    data: null,
                };
            }
            const fileId = (0, crypto_1.randomUUID)();
            const ext = (0, path_1.extname)(file.originalname);
            const storedFileName = `${fileId}${ext}`;
            const storagePath = (0, path_1.join)(this.uploadDir, storedFileName);
            (0, fs_1.writeFileSync)(storagePath, file.buffer);
            const publicUrl = `${this.baseUrl}/${fileId}`;
            const newAttachment = this.attachmentRepo.create({
                bucket_name: bucketName,
                storage_path: storagePath,
                public_url: publicUrl,
                file_type: file.mimetype,
                file_size: file.size,
                file_name: file.originalname,
                status: interface_1.AttachmentsStatus.ACTIVE,
            });
            await this.attachmentRepo.save(newAttachment);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.ATTACHMENT.CREATE.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.ATTACHMENT.CREATE.MESSAGE,
                data: newAttachment,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.ATTACHMENT.CREATE.CODE,
                message: utils_1.API_RESPONSE.ERROR.ATTACHMENT.CREATE.MESSAGE,
                data: error,
            };
        }
    }
    // ====== SERVE FILE ======
    async serveFile(id, res) {
        try {
            const attachment = await this.attachmentRepo.findOne({ where: { id } });
            if (!attachment || attachment.status === interface_1.AttachmentsStatus.DELETED) {
                res.status(404).json({
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.ATTACHMENT.GET_BY_ID.CODE,
                    message: utils_1.API_RESPONSE.ERROR.ATTACHMENT.GET_BY_ID.MESSAGE,
                    data: null,
                });
                return;
            }
            if (!(0, fs_1.existsSync)(attachment.storage_path)) {
                res.status(404).json({
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: 404,
                    message: 'File not found on disk.',
                    data: null,
                });
                return;
            }
            res.setHeader('Content-Type', attachment.file_type);
            res.setHeader('Content-Disposition', `inline; filename="${attachment.file_name}"`);
            const stream = (0, fs_1.createReadStream)(attachment.storage_path);
            stream.pipe(res);
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            res.status(500).json({
                status: interface_1.ApiResponseStatus.ERROR,
                code: 500,
                message: 'Failed to serve file.',
                data: null,
            });
        }
    }
    // ====== GET ALL ATTACHMENTS ======
    async getAll() {
        try {
            const attachments = await this.attachmentRepo.find();
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.ATTACHMENT.GET_ALL.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.ATTACHMENT.GET_ALL.MESSAGE,
                data: attachments,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.ATTACHMENT.GET_ALL.CODE,
                message: utils_1.API_RESPONSE.ERROR.ATTACHMENT.GET_ALL.MESSAGE,
                data: error,
            };
        }
    }
    // ====== GET ATTACHMENT BY ID ======
    async getById(id) {
        try {
            const attachment = await this.attachmentRepo.findOne({ where: { id } });
            if (!attachment) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.ATTACHMENT.GET_BY_ID.CODE,
                    message: utils_1.API_RESPONSE.ERROR.ATTACHMENT.GET_BY_ID.MESSAGE,
                    data: null,
                };
            }
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.ATTACHMENT.GET_BY_ID.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.ATTACHMENT.GET_BY_ID.MESSAGE,
                data: attachment,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.ATTACHMENT.GET_BY_ID.CODE,
                message: utils_1.API_RESPONSE.ERROR.ATTACHMENT.GET_BY_ID.MESSAGE,
                data: error,
            };
        }
    }
    // ====== UPDATE ATTACHMENT ======
    async update(dto) {
        try {
            const attachment = await this.attachmentRepo.findOne({ where: { id: dto.id } });
            if (!attachment) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.ATTACHMENT.UPDATE.CODE,
                    message: utils_1.API_RESPONSE.ERROR.ATTACHMENT.UPDATE.MESSAGE,
                    data: null,
                };
            }
            const updateData = (0, utils_1.prepareUpdateFields)(dto);
            Object.assign(attachment, updateData);
            await this.attachmentRepo.save(attachment);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.ATTACHMENT.UPDATE.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.ATTACHMENT.UPDATE.MESSAGE,
                data: attachment,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.ATTACHMENT.UPDATE.CODE,
                message: utils_1.API_RESPONSE.ERROR.ATTACHMENT.UPDATE.MESSAGE,
                data: error,
            };
        }
    }
    // ====== SOFT DELETE ATTACHMENT ======
    async softDelete(dto) {
        try {
            const attachment = await this.attachmentRepo.findOne({ where: { id: dto.id } });
            if (!attachment) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.ATTACHMENT.DELETE.CODE,
                    message: utils_1.API_RESPONSE.ERROR.ATTACHMENT.DELETE.MESSAGE,
                    data: null,
                };
            }
            attachment.status = interface_1.AttachmentsStatus.DELETED;
            await this.attachmentRepo.save(attachment);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.ATTACHMENT.DELETE.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.ATTACHMENT.DELETE.MESSAGE,
                data: attachment,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.ATTACHMENT.DELETE.CODE,
                message: utils_1.API_RESPONSE.ERROR.ATTACHMENT.DELETE.MESSAGE,
                data: error,
            };
        }
    }
    // ====== DELETE FILE FROM DISK ======
    async deleteFile(id) {
        try {
            const attachment = await this.attachmentRepo.findOne({ where: { id } });
            if (!attachment) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.ATTACHMENT.DELETE.CODE,
                    message: utils_1.API_RESPONSE.ERROR.ATTACHMENT.DELETE.MESSAGE,
                    data: null,
                };
            }
            if ((0, fs_1.existsSync)(attachment.storage_path)) {
                (0, fs_1.unlinkSync)(attachment.storage_path);
            }
            attachment.status = interface_1.AttachmentsStatus.DELETED;
            await this.attachmentRepo.save(attachment);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.ATTACHMENT.DELETE.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.ATTACHMENT.DELETE.MESSAGE,
                data: attachment,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.ATTACHMENT.DELETE.CODE,
                message: utils_1.API_RESPONSE.ERROR.ATTACHMENT.DELETE.MESSAGE,
                data: error,
            };
        }
    }
};
exports.AttachmentsService = AttachmentsService;
exports.AttachmentsService = AttachmentsService = AttachmentsService_1 = tslib_1.__decorate([
    (0, common_1.Injectable)(),
    tslib_1.__param(0, (0, typeorm_1.InjectRepository)(dto_1.AttachmentsEntity)),
    tslib_1.__metadata("design:paramtypes", [typeof (_a = typeof typeorm_2.Repository !== "undefined" && typeorm_2.Repository) === "function" ? _a : Object])
], AttachmentsService);


/***/ }),
/* 83 */
/***/ ((module) => {

module.exports = require("fs");

/***/ }),
/* 84 */
/***/ ((module) => {

module.exports = require("path");

/***/ }),
/* 85 */
/***/ ((module) => {

module.exports = require("crypto");

/***/ }),
/* 86 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AttachmentsController = void 0;
const tslib_1 = __webpack_require__(4);
const common_1 = __webpack_require__(1);
const platform_express_1 = __webpack_require__(87);
const express_1 = __webpack_require__(88);
const attachments_service_1 = __webpack_require__(82);
const dto_1 = __webpack_require__(22);
let AttachmentsController = class AttachmentsController {
    constructor(attachmentsService) {
        this.attachmentsService = attachmentsService;
    }
    // ====== UPLOAD FILE ======
    async upload(file, bucket) {
        if (!file) {
            throw new common_1.BadRequestException('No file provided.');
        }
        return this.attachmentsService.upload(file, bucket || 'acc-crm');
    }
    // ====== SERVE FILE ======
    async serveFile(id, res) {
        return this.attachmentsService.serveFile(id, res);
    }
    // ====== GET ALL ATTACHMENTS ======
    async getAll() {
        return this.attachmentsService.getAll();
    }
    // ====== GET ATTACHMENT BY ID ======
    async getById(id) {
        return this.attachmentsService.getById(id);
    }
    // ====== UPDATE ATTACHMENT ======
    async update(dto) {
        return this.attachmentsService.update(dto);
    }
    // ====== SOFT DELETE ATTACHMENT ======
    async softDelete(dto) {
        return this.attachmentsService.softDelete(dto);
    }
    // ====== HARD DELETE (removes file from disk) ======
    async deleteFile(id) {
        return this.attachmentsService.deleteFile(id);
    }
};
exports.AttachmentsController = AttachmentsController;
tslib_1.__decorate([
    (0, common_1.Post)('upload'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FileInterceptor)('file')),
    tslib_1.__param(0, (0, common_1.UploadedFile)()),
    tslib_1.__param(1, (0, common_1.Query)('bucket')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [typeof (_c = typeof Express !== "undefined" && (_b = Express.Multer) !== void 0 && _b.File) === "function" ? _c : Object, String]),
    tslib_1.__metadata("design:returntype", typeof (_d = typeof Promise !== "undefined" && Promise) === "function" ? _d : Object)
], AttachmentsController.prototype, "upload", null);
tslib_1.__decorate([
    (0, common_1.Get)('file/:id'),
    tslib_1.__param(0, (0, common_1.Param)('id')),
    tslib_1.__param(1, (0, common_1.Res)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [String, typeof (_e = typeof express_1.Response !== "undefined" && express_1.Response) === "function" ? _e : Object]),
    tslib_1.__metadata("design:returntype", typeof (_f = typeof Promise !== "undefined" && Promise) === "function" ? _f : Object)
], AttachmentsController.prototype, "serveFile", null);
tslib_1.__decorate([
    (0, common_1.Get)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", typeof (_g = typeof Promise !== "undefined" && Promise) === "function" ? _g : Object)
], AttachmentsController.prototype, "getAll", null);
tslib_1.__decorate([
    (0, common_1.Get)(':id'),
    tslib_1.__param(0, (0, common_1.Param)('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [String]),
    tslib_1.__metadata("design:returntype", typeof (_h = typeof Promise !== "undefined" && Promise) === "function" ? _h : Object)
], AttachmentsController.prototype, "getById", null);
tslib_1.__decorate([
    (0, common_1.Patch)(),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [typeof (_j = typeof dto_1.UpdateAttachmentsDto !== "undefined" && dto_1.UpdateAttachmentsDto) === "function" ? _j : Object]),
    tslib_1.__metadata("design:returntype", typeof (_k = typeof Promise !== "undefined" && Promise) === "function" ? _k : Object)
], AttachmentsController.prototype, "update", null);
tslib_1.__decorate([
    (0, common_1.Patch)('soft-delete'),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [typeof (_l = typeof dto_1.UpdateAttachmentsDto !== "undefined" && dto_1.UpdateAttachmentsDto) === "function" ? _l : Object]),
    tslib_1.__metadata("design:returntype", typeof (_m = typeof Promise !== "undefined" && Promise) === "function" ? _m : Object)
], AttachmentsController.prototype, "softDelete", null);
tslib_1.__decorate([
    (0, common_1.Delete)(':id'),
    tslib_1.__param(0, (0, common_1.Param)('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [String]),
    tslib_1.__metadata("design:returntype", typeof (_o = typeof Promise !== "undefined" && Promise) === "function" ? _o : Object)
], AttachmentsController.prototype, "deleteFile", null);
exports.AttachmentsController = AttachmentsController = tslib_1.__decorate([
    (0, common_1.Controller)('attachments'),
    tslib_1.__metadata("design:paramtypes", [typeof (_a = typeof attachments_service_1.AttachmentsService !== "undefined" && attachments_service_1.AttachmentsService) === "function" ? _a : Object])
], AttachmentsController);


/***/ }),
/* 87 */
/***/ ((module) => {

module.exports = require("@nestjs/platform-express");

/***/ }),
/* 88 */
/***/ ((module) => {

module.exports = require("express");

/***/ }),
/* 89 */
/***/ ((module) => {

module.exports = require("multer");

/***/ }),
/* 90 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ClientsModule = void 0;
const tslib_1 = __webpack_require__(4);
const common_1 = __webpack_require__(1);
const clients_service_1 = __webpack_require__(91);
const clients_controller_1 = __webpack_require__(92);
const dto_1 = __webpack_require__(22);
const typeorm_1 = __webpack_require__(21);
let ClientsModule = class ClientsModule {
};
exports.ClientsModule = ClientsModule;
exports.ClientsModule = ClientsModule = tslib_1.__decorate([
    (0, common_1.Module)({
        controllers: [clients_controller_1.ClientsController],
        providers: [clients_service_1.ClientsService],
        imports: [typeorm_1.TypeOrmModule.forFeature([dto_1.ClientsEntity])],
    })
], ClientsModule);


/***/ }),
/* 91 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var ClientsService_1;
var _a;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ClientsService = void 0;
const tslib_1 = __webpack_require__(4);
const dto_1 = __webpack_require__(22);
const interface_1 = __webpack_require__(67);
const utils_1 = __webpack_require__(11);
const common_1 = __webpack_require__(1);
const typeorm_1 = __webpack_require__(21);
const typeorm_2 = __webpack_require__(8);
let ClientsService = ClientsService_1 = class ClientsService {
    constructor(clientsRepo) {
        this.clientsRepo = clientsRepo;
        this.logger = new common_1.Logger(ClientsService_1.name);
    }
    // Get all clients
    async getAll() {
        try {
            const clients = await this.clientsRepo.find({
                relations: ['created_by', 'updated_by', 'company'],
            });
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.CLIENTS.GET_ALL.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.CLIENTS.GET_ALL.MESSAGE,
                data: clients,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.CLIENTS.GET_ALL.CODE,
                message: utils_1.API_RESPONSE.ERROR.CLIENTS.GET_ALL.MESSAGE,
                data: error,
            };
        }
    }
    // Get clients for supervisor: created by managers or supervisors only
    async getForSupervisor() {
        try {
            const clients = await this.clientsRepo.find({
                where: { created_by: { role: (0, typeorm_2.In)([interface_1.UserRole.MANAGER, interface_1.UserRole.SUPERVISOR]) } },
                relations: ['created_by', 'updated_by', 'company'],
            });
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.CLIENTS.GET_ALL.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.CLIENTS.GET_ALL.MESSAGE,
                data: clients,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.CLIENTS.GET_ALL.CODE,
                message: utils_1.API_RESPONSE.ERROR.CLIENTS.GET_ALL.MESSAGE,
                data: error,
            };
        }
    }
    // Get clients by user ID (creator)
    async getByUserId(userId) {
        try {
            const clients = await this.clientsRepo.find({
                where: { created_by: { id: userId } },
                relations: ['created_by', 'updated_by', 'company'],
            });
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.CLIENTS.GET_BY_ID.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.CLIENTS.GET_BY_ID.MESSAGE,
                data: clients,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.CLIENTS.GET_BY_ID.CODE,
                message: utils_1.API_RESPONSE.ERROR.CLIENTS.GET_BY_ID.MESSAGE,
                data: error,
            };
        }
    }
    // Get client by ID
    async getById(id) {
        try {
            const client = await this.clientsRepo.findOne({
                where: { id },
                relations: ['created_by', 'updated_by', 'company'],
            });
            if (!client) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.CLIENTS.GET_BY_ID.CODE,
                    message: 'Client not found',
                    data: null,
                };
            }
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.CLIENTS.GET_BY_ID.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.CLIENTS.GET_BY_ID.MESSAGE,
                data: client,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.CLIENTS.GET_BY_ID.CODE,
                message: utils_1.API_RESPONSE.ERROR.CLIENTS.GET_BY_ID.MESSAGE,
                data: error,
            };
        }
    }
    // Create new client
    async create(dto) {
        try {
            const newClient = this.clientsRepo.create(dto);
            await this.clientsRepo.save(newClient);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.CLIENTS.CREATE.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.CLIENTS.CREATE.MESSAGE,
                data: newClient,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.CLIENTS.CREATE.CODE,
                message: utils_1.API_RESPONSE.ERROR.CLIENTS.CREATE.MESSAGE,
                data: error,
            };
        }
    }
    // Update existing client
    async update(dto) {
        try {
            const client = await this.clientsRepo.findOne({
                where: { id: dto.id },
                relations: ['updated_by', 'company'],
            });
            if (!client) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.CLIENTS.UPDATE.CODE,
                    message: 'Client not found',
                    data: null,
                };
            }
            const updateData = (0, utils_1.prepareUpdateFields)(dto, {
                updated_by_id: 'updated_by',
                company_id: 'company',
            });
            Object.assign(client, updateData);
            await this.clientsRepo.save(client);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.CLIENTS.UPDATE.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.CLIENTS.UPDATE.MESSAGE,
                data: client,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.CLIENTS.UPDATE.CODE,
                message: utils_1.API_RESPONSE.ERROR.CLIENTS.UPDATE.MESSAGE,
                data: error,
            };
        }
    }
    // Soft delete client (set status to DELETED)
    async softDelete(dto) {
        try {
            const client = await this.clientsRepo.findOne({ where: { id: dto.id } });
            if (!client) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.CLIENTS.DELETE.CODE,
                    message: utils_1.API_RESPONSE.ERROR.CLIENTS.DELETE.MESSAGE,
                    data: null,
                };
            }
            client.status = interface_1.ClientStatus.DELETED;
            await this.clientsRepo.save(client);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.CLIENTS.DELETE.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.CLIENTS.DELETE.MESSAGE,
                data: client,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.CLIENTS.DELETE.CODE,
                message: utils_1.API_RESPONSE.ERROR.CLIENTS.DELETE.MESSAGE,
                data: error,
            };
        }
    }
};
exports.ClientsService = ClientsService;
exports.ClientsService = ClientsService = ClientsService_1 = tslib_1.__decorate([
    (0, common_1.Injectable)(),
    tslib_1.__param(0, (0, typeorm_1.InjectRepository)(dto_1.ClientsEntity)),
    tslib_1.__metadata("design:paramtypes", [typeof (_a = typeof typeorm_2.Repository !== "undefined" && typeorm_2.Repository) === "function" ? _a : Object])
], ClientsService);


/***/ }),
/* 92 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ClientsController = void 0;
const tslib_1 = __webpack_require__(4);
const common_1 = __webpack_require__(1);
const clients_service_1 = __webpack_require__(91);
const dto_1 = __webpack_require__(22);
let ClientsController = class ClientsController {
    constructor(clientsService) {
        this.clientsService = clientsService;
    }
    // Get all clients (management)
    async getAll() {
        return this.clientsService.getAll();
    }
    // Get clients for supervisor role
    async getForSupervisor() {
        return this.clientsService.getForSupervisor();
    }
    // Get clients by user ID (creator)
    async getByUserId(userId) {
        return this.clientsService.getByUserId(userId);
    }
    // Get client by ID
    async getById(id) {
        return this.clientsService.getById(id);
    }
    // Create new client
    async create(dto) {
        return this.clientsService.create(dto);
    }
    // Update existing client
    async update(dto) {
        return this.clientsService.update(dto);
    }
    // Soft delete client
    async softDelete(dto) {
        return this.clientsService.softDelete(dto);
    }
};
exports.ClientsController = ClientsController;
tslib_1.__decorate([
    (0, common_1.Get)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", typeof (_b = typeof Promise !== "undefined" && Promise) === "function" ? _b : Object)
], ClientsController.prototype, "getAll", null);
tslib_1.__decorate([
    (0, common_1.Get)('supervisor'),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", typeof (_c = typeof Promise !== "undefined" && Promise) === "function" ? _c : Object)
], ClientsController.prototype, "getForSupervisor", null);
tslib_1.__decorate([
    (0, common_1.Get)('user/:userId'),
    tslib_1.__param(0, (0, common_1.Param)('userId')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [String]),
    tslib_1.__metadata("design:returntype", typeof (_d = typeof Promise !== "undefined" && Promise) === "function" ? _d : Object)
], ClientsController.prototype, "getByUserId", null);
tslib_1.__decorate([
    (0, common_1.Get)(':id'),
    tslib_1.__param(0, (0, common_1.Param)('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [String]),
    tslib_1.__metadata("design:returntype", typeof (_e = typeof Promise !== "undefined" && Promise) === "function" ? _e : Object)
], ClientsController.prototype, "getById", null);
tslib_1.__decorate([
    (0, common_1.Post)(),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [typeof (_f = typeof dto_1.CreateClientsDto !== "undefined" && dto_1.CreateClientsDto) === "function" ? _f : Object]),
    tslib_1.__metadata("design:returntype", typeof (_g = typeof Promise !== "undefined" && Promise) === "function" ? _g : Object)
], ClientsController.prototype, "create", null);
tslib_1.__decorate([
    (0, common_1.Put)(),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [typeof (_h = typeof dto_1.UpdateClientsDto !== "undefined" && dto_1.UpdateClientsDto) === "function" ? _h : Object]),
    tslib_1.__metadata("design:returntype", typeof (_j = typeof Promise !== "undefined" && Promise) === "function" ? _j : Object)
], ClientsController.prototype, "update", null);
tslib_1.__decorate([
    (0, common_1.Delete)(),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [typeof (_k = typeof dto_1.UpdateClientsDto !== "undefined" && dto_1.UpdateClientsDto) === "function" ? _k : Object]),
    tslib_1.__metadata("design:returntype", typeof (_l = typeof Promise !== "undefined" && Promise) === "function" ? _l : Object)
], ClientsController.prototype, "softDelete", null);
exports.ClientsController = ClientsController = tslib_1.__decorate([
    (0, common_1.Controller)('clients'),
    tslib_1.__metadata("design:paramtypes", [typeof (_a = typeof clients_service_1.ClientsService !== "undefined" && clients_service_1.ClientsService) === "function" ? _a : Object])
], ClientsController);


/***/ }),
/* 93 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CompaniesModule = void 0;
const tslib_1 = __webpack_require__(4);
const common_1 = __webpack_require__(1);
const companies_service_1 = __webpack_require__(94);
const companies_controller_1 = __webpack_require__(95);
const dto_1 = __webpack_require__(22);
const typeorm_1 = __webpack_require__(21);
let CompaniesModule = class CompaniesModule {
};
exports.CompaniesModule = CompaniesModule;
exports.CompaniesModule = CompaniesModule = tslib_1.__decorate([
    (0, common_1.Module)({
        controllers: [companies_controller_1.CompaniesController],
        providers: [companies_service_1.CompaniesService],
        imports: [typeorm_1.TypeOrmModule.forFeature([dto_1.CompanyEntity])],
    })
], CompaniesModule);


/***/ }),
/* 94 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var CompaniesService_1;
var _a;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CompaniesService = void 0;
const tslib_1 = __webpack_require__(4);
const common_1 = __webpack_require__(1);
const typeorm_1 = __webpack_require__(21);
const typeorm_2 = __webpack_require__(8);
const dto_1 = __webpack_require__(22);
const interface_1 = __webpack_require__(67);
const utils_1 = __webpack_require__(11);
let CompaniesService = CompaniesService_1 = class CompaniesService {
    constructor(companyRepo) {
        this.companyRepo = companyRepo;
        this.logger = new common_1.Logger(CompaniesService_1.name);
    }
    // Get all companies
    async getAll() {
        try {
            const companies = await this.companyRepo.find({
                relations: [
                    'created_by',
                    'updated_by',
                    'attachment_company_logo',
                    'attachment_org_chart'
                ],
            });
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.COMPANY.GET_ALL.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.COMPANY.GET_ALL.MESSAGE,
                data: companies,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.COMPANY.GET_ALL.CODE,
                message: utils_1.API_RESPONSE.ERROR.COMPANY.GET_ALL.MESSAGE,
                data: error,
            };
        }
    }
    // Get companies by user id (creator)
    async getByUserId(userId) {
        try {
            const companies = await this.companyRepo.find({
                where: { created_by: { id: userId } },
                relations: [
                    'created_by',
                    'updated_by',
                    'attachment_company_logo',
                    'attachment_org_chart'
                ],
            });
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.COMPANY.GET_BY_ID.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.COMPANY.GET_BY_ID.MESSAGE,
                data: companies,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.COMPANY.GET_BY_ID.CODE,
                message: utils_1.API_RESPONSE.ERROR.COMPANY.GET_BY_ID.MESSAGE,
                data: error,
            };
        }
    }
    // Get company by id
    async getById(id) {
        try {
            const company = await this.companyRepo.findOne({
                where: { id },
                relations: [
                    'created_by',
                    'updated_by',
                    'attachment_company_logo',
                    'attachment_org_chart'
                ],
            });
            if (!company) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.COMPANY.GET_BY_ID.CODE,
                    message: 'Company not found',
                    data: null,
                };
            }
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.COMPANY.GET_BY_ID.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.COMPANY.GET_BY_ID.MESSAGE,
                data: company,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.COMPANY.GET_BY_ID.CODE,
                message: utils_1.API_RESPONSE.ERROR.COMPANY.GET_BY_ID.MESSAGE,
                data: error,
            };
        }
    }
    // Create a new company
    async create(dto) {
        try {
            const newCompany = this.companyRepo.create(dto);
            await this.companyRepo.save(newCompany);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.COMPANY.CREATE.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.COMPANY.CREATE.MESSAGE,
                data: newCompany,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.COMPANY.CREATE.CODE,
                message: utils_1.API_RESPONSE.ERROR.COMPANY.CREATE.MESSAGE,
                data: error,
            };
        }
    }
    // Update existing company
    async update(dto) {
        try {
            const company = await this.companyRepo.findOne({
                where: { id: dto.id },
                relations: [
                    'updated_by',
                    'attachment_company_logo',
                    'attachment_org_chart'
                ],
            });
            if (!company) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.COMPANY.UPDATE.CODE,
                    message: 'Company not found',
                    data: null,
                };
            }
            const updateData = (0, utils_1.prepareUpdateFields)(dto, {
                updated_by_id: 'updated_by',
                attachment_company_logo_id: 'attachment_company_logo',
                attachment_org_chart_id: 'attachment_org_chart',
            });
            Object.assign(company, updateData);
            await this.companyRepo.save(company);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.COMPANY.UPDATE.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.COMPANY.UPDATE.MESSAGE,
                data: company,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.COMPANY.UPDATE.CODE,
                message: utils_1.API_RESPONSE.ERROR.COMPANY.UPDATE.MESSAGE,
                data: error,
            };
        }
    }
    // Soft delete (set status to inactive or deleted)
    async softDelete(dto) {
        try {
            const company = await this.companyRepo.findOne({ where: { id: dto.id } });
            if (!company) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.COMPANY.DELETE.CODE,
                    message: 'Company not found',
                    data: null,
                };
            }
            company.status = interface_1.CompanyStatus.DELETED;
            await this.companyRepo.save(company);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.COMPANY.DELETE.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.COMPANY.DELETE.MESSAGE,
                data: company,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.COMPANY.DELETE.CODE,
                message: utils_1.API_RESPONSE.ERROR.COMPANY.DELETE.MESSAGE,
                data: error,
            };
        }
    }
};
exports.CompaniesService = CompaniesService;
exports.CompaniesService = CompaniesService = CompaniesService_1 = tslib_1.__decorate([
    (0, common_1.Injectable)(),
    tslib_1.__param(0, (0, typeorm_1.InjectRepository)(dto_1.CompanyEntity)),
    tslib_1.__metadata("design:paramtypes", [typeof (_a = typeof typeorm_2.Repository !== "undefined" && typeorm_2.Repository) === "function" ? _a : Object])
], CompaniesService);


/***/ }),
/* 95 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CompaniesController = void 0;
const tslib_1 = __webpack_require__(4);
const common_1 = __webpack_require__(1);
const companies_service_1 = __webpack_require__(94);
const dto_1 = __webpack_require__(22);
let CompaniesController = class CompaniesController {
    constructor(companiesService) {
        this.companiesService = companiesService;
    }
    // GET /companies
    async getAll() {
        return this.companiesService.getAll();
    }
    // GET /companies/user/:userId
    async getByUserId(userId) {
        return this.companiesService.getByUserId(userId);
    }
    // GET /companies/:id
    async getById(id) {
        return this.companiesService.getById(id);
    }
    // POST /companies
    async create(dto) {
        return this.companiesService.create(dto);
    }
    // PATCH /companies
    async update(dto) {
        return this.companiesService.update(dto);
    }
    // DELETE /companies
    async softDelete(dto) {
        return this.companiesService.softDelete(dto);
    }
};
exports.CompaniesController = CompaniesController;
tslib_1.__decorate([
    (0, common_1.Get)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", typeof (_b = typeof Promise !== "undefined" && Promise) === "function" ? _b : Object)
], CompaniesController.prototype, "getAll", null);
tslib_1.__decorate([
    (0, common_1.Get)('user/:userId'),
    tslib_1.__param(0, (0, common_1.Param)('userId')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [String]),
    tslib_1.__metadata("design:returntype", typeof (_c = typeof Promise !== "undefined" && Promise) === "function" ? _c : Object)
], CompaniesController.prototype, "getByUserId", null);
tslib_1.__decorate([
    (0, common_1.Get)(':id'),
    tslib_1.__param(0, (0, common_1.Param)('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [String]),
    tslib_1.__metadata("design:returntype", typeof (_d = typeof Promise !== "undefined" && Promise) === "function" ? _d : Object)
], CompaniesController.prototype, "getById", null);
tslib_1.__decorate([
    (0, common_1.Post)(),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [typeof (_e = typeof dto_1.CreateCompanyDto !== "undefined" && dto_1.CreateCompanyDto) === "function" ? _e : Object]),
    tslib_1.__metadata("design:returntype", typeof (_f = typeof Promise !== "undefined" && Promise) === "function" ? _f : Object)
], CompaniesController.prototype, "create", null);
tslib_1.__decorate([
    (0, common_1.Patch)(),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [typeof (_g = typeof dto_1.UpdateCompanyDto !== "undefined" && dto_1.UpdateCompanyDto) === "function" ? _g : Object]),
    tslib_1.__metadata("design:returntype", typeof (_h = typeof Promise !== "undefined" && Promise) === "function" ? _h : Object)
], CompaniesController.prototype, "update", null);
tslib_1.__decorate([
    (0, common_1.Delete)(),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [typeof (_j = typeof dto_1.UpdateCompanyDto !== "undefined" && dto_1.UpdateCompanyDto) === "function" ? _j : Object]),
    tslib_1.__metadata("design:returntype", typeof (_k = typeof Promise !== "undefined" && Promise) === "function" ? _k : Object)
], CompaniesController.prototype, "softDelete", null);
exports.CompaniesController = CompaniesController = tslib_1.__decorate([
    (0, common_1.Controller)('companies'),
    tslib_1.__metadata("design:paramtypes", [typeof (_a = typeof companies_service_1.CompaniesService !== "undefined" && companies_service_1.CompaniesService) === "function" ? _a : Object])
], CompaniesController);


/***/ }),
/* 96 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FinancialsModule = void 0;
const tslib_1 = __webpack_require__(4);
const common_1 = __webpack_require__(1);
const financials_service_1 = __webpack_require__(97);
const financials_controller_1 = __webpack_require__(98);
const dto_1 = __webpack_require__(22);
const typeorm_1 = __webpack_require__(21);
let FinancialsModule = class FinancialsModule {
};
exports.FinancialsModule = FinancialsModule;
exports.FinancialsModule = FinancialsModule = tslib_1.__decorate([
    (0, common_1.Module)({
        controllers: [financials_controller_1.FinancialsController],
        providers: [financials_service_1.FinancialsService],
        imports: [typeorm_1.TypeOrmModule.forFeature([dto_1.FinancialsEntity])],
    })
], FinancialsModule);


/***/ }),
/* 97 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var FinancialsService_1;
var _a;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FinancialsService = void 0;
const tslib_1 = __webpack_require__(4);
const dto_1 = __webpack_require__(22);
const interface_1 = __webpack_require__(67);
const utils_1 = __webpack_require__(11);
const common_1 = __webpack_require__(1);
const typeorm_1 = __webpack_require__(21);
const typeorm_2 = __webpack_require__(8);
let FinancialsService = FinancialsService_1 = class FinancialsService {
    constructor(financialsRepo) {
        this.financialsRepo = financialsRepo;
        this.logger = new common_1.Logger(FinancialsService_1.name);
    }
    // Get all financials
    async getAll() {
        try {
            const financials = await this.financialsRepo.find({
                relations: ['created_by', 'updated_by'],
            });
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.FINANCIALS.GET_ALL.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.FINANCIALS.GET_ALL.MESSAGE,
                data: financials,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.FINANCIALS.GET_ALL.CODE,
                message: utils_1.API_RESPONSE.ERROR.FINANCIALS.GET_ALL.MESSAGE,
                data: error,
            };
        }
    }
    // Get financials by user ID (creator)
    async getByUserId(userId) {
        try {
            const financials = await this.financialsRepo.find({
                where: { created_by: { id: userId } },
                relations: ['created_by', 'updated_by'],
            });
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.FINANCIALS.GET_BY_ID.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.FINANCIALS.GET_BY_ID.MESSAGE,
                data: financials,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.FINANCIALS.GET_BY_ID.CODE,
                message: utils_1.API_RESPONSE.ERROR.FINANCIALS.GET_BY_ID.MESSAGE,
                data: error,
            };
        }
    }
    // Get financials by ID
    async getById(id) {
        try {
            const financial = await this.financialsRepo.findOne({
                where: { id },
                relations: ['created_by', 'updated_by'],
            });
            if (!financial) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.FINANCIALS.GET_BY_ID.CODE,
                    message: utils_1.API_RESPONSE.ERROR.FINANCIALS.GET_BY_ID.MESSAGE,
                    data: null,
                };
            }
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.FINANCIALS.GET_BY_ID.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.FINANCIALS.GET_BY_ID.MESSAGE,
                data: financial,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.FINANCIALS.GET_BY_ID.CODE,
                message: utils_1.API_RESPONSE.ERROR.FINANCIALS.GET_BY_ID.MESSAGE,
                data: error,
            };
        }
    }
    // Create a new financial record
    async create(dto) {
        try {
            const newFinancial = this.financialsRepo.create(dto);
            await this.financialsRepo.save(newFinancial);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.FINANCIALS.CREATE.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.FINANCIALS.CREATE.MESSAGE,
                data: newFinancial,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.FINANCIALS.CREATE.CODE,
                message: utils_1.API_RESPONSE.ERROR.FINANCIALS.CREATE.MESSAGE,
                data: error,
            };
        }
    }
    // Update existing financial record
    async update(dto) {
        try {
            const financial = await this.financialsRepo.findOne({
                where: { id: dto.id },
                relations: ['updated_by'],
            });
            if (!financial) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.FINANCIALS.UPDATE.CODE,
                    message: utils_1.API_RESPONSE.ERROR.FINANCIALS.UPDATE.MESSAGE,
                    data: null,
                };
            }
            const updateData = (0, utils_1.prepareUpdateFields)(dto, {
                updated_by_id: 'updated_by',
            });
            Object.assign(financial, updateData);
            await this.financialsRepo.save(financial);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.FINANCIALS.UPDATE.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.FINANCIALS.UPDATE.MESSAGE,
                data: financial,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.FINANCIALS.UPDATE.CODE,
                message: utils_1.API_RESPONSE.ERROR.FINANCIALS.UPDATE.MESSAGE,
                data: error,
            };
        }
    }
    // Soft delete financial record
    async softDelete(dto) {
        try {
            const financial = await this.financialsRepo.findOne({
                where: { id: dto.id },
            });
            if (!financial) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.FINANCIALS.DELETE.CODE,
                    message: utils_1.API_RESPONSE.ERROR.FINANCIALS.DELETE.MESSAGE,
                    data: null,
                };
            }
            financial.status = interface_1.FinancialsStatus.DELETED;
            await this.financialsRepo.save(financial);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.FINANCIALS.DELETE.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.FINANCIALS.DELETE.MESSAGE,
                data: financial,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.FINANCIALS.DELETE.CODE,
                message: utils_1.API_RESPONSE.ERROR.FINANCIALS.DELETE.MESSAGE,
                data: error,
            };
        }
    }
};
exports.FinancialsService = FinancialsService;
exports.FinancialsService = FinancialsService = FinancialsService_1 = tslib_1.__decorate([
    (0, common_1.Injectable)(),
    tslib_1.__param(0, (0, typeorm_1.InjectRepository)(dto_1.FinancialsEntity)),
    tslib_1.__metadata("design:paramtypes", [typeof (_a = typeof typeorm_2.Repository !== "undefined" && typeorm_2.Repository) === "function" ? _a : Object])
], FinancialsService);


/***/ }),
/* 98 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FinancialsController = void 0;
const tslib_1 = __webpack_require__(4);
const common_1 = __webpack_require__(1);
const financials_service_1 = __webpack_require__(97);
const dto_1 = __webpack_require__(22);
let FinancialsController = class FinancialsController {
    constructor(financialsService) {
        this.financialsService = financialsService;
    }
    // GET /financials
    async getAll() {
        return this.financialsService.getAll();
    }
    // GET /financials/user/:userId
    async getByUserId(userId) {
        return this.financialsService.getByUserId(userId);
    }
    // GET /financials/:id
    async getById(id) {
        return this.financialsService.getById(id);
    }
    // POST /financials
    async create(dto) {
        return this.financialsService.create(dto);
    }
    // PUT /financials
    async update(dto) {
        return this.financialsService.update(dto);
    }
    // DELETE /financials
    async softDelete(dto) {
        return this.financialsService.softDelete(dto);
    }
};
exports.FinancialsController = FinancialsController;
tslib_1.__decorate([
    (0, common_1.Get)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", typeof (_b = typeof Promise !== "undefined" && Promise) === "function" ? _b : Object)
], FinancialsController.prototype, "getAll", null);
tslib_1.__decorate([
    (0, common_1.Get)('user/:userId'),
    tslib_1.__param(0, (0, common_1.Param)('userId')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [String]),
    tslib_1.__metadata("design:returntype", typeof (_c = typeof Promise !== "undefined" && Promise) === "function" ? _c : Object)
], FinancialsController.prototype, "getByUserId", null);
tslib_1.__decorate([
    (0, common_1.Get)(':id'),
    tslib_1.__param(0, (0, common_1.Param)('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [String]),
    tslib_1.__metadata("design:returntype", typeof (_d = typeof Promise !== "undefined" && Promise) === "function" ? _d : Object)
], FinancialsController.prototype, "getById", null);
tslib_1.__decorate([
    (0, common_1.Post)(),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [typeof (_e = typeof dto_1.CreateFinancialsDto !== "undefined" && dto_1.CreateFinancialsDto) === "function" ? _e : Object]),
    tslib_1.__metadata("design:returntype", typeof (_f = typeof Promise !== "undefined" && Promise) === "function" ? _f : Object)
], FinancialsController.prototype, "create", null);
tslib_1.__decorate([
    (0, common_1.Put)(),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [typeof (_g = typeof dto_1.UpdateFinancialsDto !== "undefined" && dto_1.UpdateFinancialsDto) === "function" ? _g : Object]),
    tslib_1.__metadata("design:returntype", typeof (_h = typeof Promise !== "undefined" && Promise) === "function" ? _h : Object)
], FinancialsController.prototype, "update", null);
tslib_1.__decorate([
    (0, common_1.Delete)(),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [typeof (_j = typeof dto_1.UpdateFinancialsDto !== "undefined" && dto_1.UpdateFinancialsDto) === "function" ? _j : Object]),
    tslib_1.__metadata("design:returntype", typeof (_k = typeof Promise !== "undefined" && Promise) === "function" ? _k : Object)
], FinancialsController.prototype, "softDelete", null);
exports.FinancialsController = FinancialsController = tslib_1.__decorate([
    (0, common_1.Controller)('financials'),
    tslib_1.__metadata("design:paramtypes", [typeof (_a = typeof financials_service_1.FinancialsService !== "undefined" && financials_service_1.FinancialsService) === "function" ? _a : Object])
], FinancialsController);


/***/ }),
/* 99 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LeadsModule = void 0;
const tslib_1 = __webpack_require__(4);
const common_1 = __webpack_require__(1);
const leads_service_1 = __webpack_require__(100);
const leads_controller_1 = __webpack_require__(101);
const dto_1 = __webpack_require__(22);
const typeorm_1 = __webpack_require__(21);
let LeadsModule = class LeadsModule {
};
exports.LeadsModule = LeadsModule;
exports.LeadsModule = LeadsModule = tslib_1.__decorate([
    (0, common_1.Module)({
        controllers: [leads_controller_1.LeadsController],
        providers: [leads_service_1.LeadsService],
        imports: [typeorm_1.TypeOrmModule.forFeature([dto_1.LeadsEntity])],
    })
], LeadsModule);


/***/ }),
/* 100 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var LeadsService_1;
var _a;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LeadsService = void 0;
const tslib_1 = __webpack_require__(4);
const dto_1 = __webpack_require__(22);
const interface_1 = __webpack_require__(67);
const utils_1 = __webpack_require__(11);
const common_1 = __webpack_require__(1);
const typeorm_1 = __webpack_require__(21);
const typeorm_2 = __webpack_require__(8);
let LeadsService = LeadsService_1 = class LeadsService {
    constructor(leadsRepo) {
        this.leadsRepo = leadsRepo;
        this.logger = new common_1.Logger(LeadsService_1.name);
    }
    // Get all leads
    async getAll() {
        try {
            const leads = await this.leadsRepo.find({
                relations: ['created_by', 'updated_by', 'client'],
            });
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.LEADS.GET_ALL.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.LEADS.GET_ALL.MESSAGE,
                data: leads,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.LEADS.GET_ALL.CODE,
                message: utils_1.API_RESPONSE.ERROR.LEADS.GET_ALL.MESSAGE,
                data: error,
            };
        }
    }
    // Get leads for supervisor: created by managers or supervisors only
    async getForSupervisor() {
        try {
            const leads = await this.leadsRepo.find({
                where: { created_by: { role: (0, typeorm_2.In)([interface_1.UserRole.MANAGER, interface_1.UserRole.SUPERVISOR]) } },
                relations: ['created_by', 'updated_by', 'client'],
            });
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.LEADS.GET_ALL.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.LEADS.GET_ALL.MESSAGE,
                data: leads,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.LEADS.GET_ALL.CODE,
                message: utils_1.API_RESPONSE.ERROR.LEADS.GET_ALL.MESSAGE,
                data: error,
            };
        }
    }
    // Get leads by user ID (creator)
    async getByUserId(userId) {
        try {
            const leads = await this.leadsRepo.find({
                where: { created_by: { id: userId } },
                relations: ['created_by', 'updated_by', 'client'],
            });
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.LEADS.GET_BY_ID.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.LEADS.GET_BY_ID.MESSAGE,
                data: leads,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.LEADS.GET_BY_ID.CODE,
                message: utils_1.API_RESPONSE.ERROR.LEADS.GET_BY_ID.MESSAGE,
                data: error,
            };
        }
    }
    // Get lead by ID
    async getById(id) {
        try {
            const lead = await this.leadsRepo.findOne({
                where: { id },
                relations: ['created_by', 'updated_by', 'client'],
            });
            if (!lead) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.LEADS.GET_BY_ID.CODE,
                    message: 'Lead not found',
                    data: null,
                };
            }
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.LEADS.GET_BY_ID.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.LEADS.GET_BY_ID.MESSAGE,
                data: lead,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.LEADS.GET_BY_ID.CODE,
                message: utils_1.API_RESPONSE.ERROR.LEADS.GET_BY_ID.MESSAGE,
                data: error,
            };
        }
    }
    // Create new lead
    async create(dto) {
        try {
            const newLead = this.leadsRepo.create(dto);
            await this.leadsRepo.save(newLead);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.LEADS.CREATE.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.LEADS.CREATE.MESSAGE,
                data: newLead,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.LEADS.CREATE.CODE,
                message: utils_1.API_RESPONSE.ERROR.LEADS.CREATE.MESSAGE,
                data: error,
            };
        }
    }
    // Update existing lead
    async update(dto) {
        try {
            const lead = await this.leadsRepo.findOne({
                where: { id: dto.id },
                relations: ['updated_by', 'client'],
            });
            if (!lead) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.LEADS.UPDATE.CODE,
                    message: 'Lead not found',
                    data: null,
                };
            }
            const updateData = (0, utils_1.prepareUpdateFields)(dto, {
                updated_by_id: 'updated_by',
                client_id: 'client',
            });
            Object.assign(lead, updateData);
            await this.leadsRepo.save(lead);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.LEADS.UPDATE.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.LEADS.UPDATE.MESSAGE,
                data: lead,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.LEADS.UPDATE.CODE,
                message: utils_1.API_RESPONSE.ERROR.LEADS.UPDATE.MESSAGE,
                data: error,
            };
        }
    }
    // Soft delete lead
    async softDelete(dto) {
        try {
            const lead = await this.leadsRepo.findOne({ where: { id: dto.id } });
            if (!lead) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.LEADS.DELETE.CODE,
                    message: 'Lead not found',
                    data: null,
                };
            }
            lead.status = interface_1.LeadStatus.DELETED;
            await this.leadsRepo.save(lead);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.LEADS.DELETE.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.LEADS.DELETE.MESSAGE,
                data: lead,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.LEADS.DELETE.CODE,
                message: utils_1.API_RESPONSE.ERROR.LEADS.DELETE.MESSAGE,
                data: error,
            };
        }
    }
};
exports.LeadsService = LeadsService;
exports.LeadsService = LeadsService = LeadsService_1 = tslib_1.__decorate([
    (0, common_1.Injectable)(),
    tslib_1.__param(0, (0, typeorm_1.InjectRepository)(dto_1.LeadsEntity)),
    tslib_1.__metadata("design:paramtypes", [typeof (_a = typeof typeorm_2.Repository !== "undefined" && typeorm_2.Repository) === "function" ? _a : Object])
], LeadsService);


/***/ }),
/* 101 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LeadsController = void 0;
const tslib_1 = __webpack_require__(4);
const common_1 = __webpack_require__(1);
const leads_service_1 = __webpack_require__(100);
const dto_1 = __webpack_require__(22);
let LeadsController = class LeadsController {
    constructor(leadsService) {
        this.leadsService = leadsService;
    }
    // GET /leads - fetch all leads (management only)
    async getAll() {
        return this.leadsService.getAll();
    }
    // GET /leads/supervisor - fetch leads by managers and supervisors only
    async getForSupervisor() {
        return this.leadsService.getForSupervisor();
    }
    // GET /leads/user/:userId - fetch leads created by a specific user
    async getByUserId(userId) {
        return this.leadsService.getByUserId(userId);
    }
    // GET /leads/:id - fetch a single lead by ID
    async getById(id) {
        return this.leadsService.getById(id);
    }
    // POST /leads - create a new lead
    async create(dto) {
        return this.leadsService.create(dto);
    }
    // PATCH /leads - update an existing lead
    async update(dto) {
        return this.leadsService.update(dto);
    }
    // PATCH /leads/delete - soft delete a lead
    async softDelete(dto) {
        return this.leadsService.softDelete(dto);
    }
};
exports.LeadsController = LeadsController;
tslib_1.__decorate([
    (0, common_1.Get)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", typeof (_b = typeof Promise !== "undefined" && Promise) === "function" ? _b : Object)
], LeadsController.prototype, "getAll", null);
tslib_1.__decorate([
    (0, common_1.Get)('supervisor'),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", typeof (_c = typeof Promise !== "undefined" && Promise) === "function" ? _c : Object)
], LeadsController.prototype, "getForSupervisor", null);
tslib_1.__decorate([
    (0, common_1.Get)('user/:userId'),
    tslib_1.__param(0, (0, common_1.Param)('userId')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [String]),
    tslib_1.__metadata("design:returntype", typeof (_d = typeof Promise !== "undefined" && Promise) === "function" ? _d : Object)
], LeadsController.prototype, "getByUserId", null);
tslib_1.__decorate([
    (0, common_1.Get)(':id'),
    tslib_1.__param(0, (0, common_1.Param)('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [String]),
    tslib_1.__metadata("design:returntype", typeof (_e = typeof Promise !== "undefined" && Promise) === "function" ? _e : Object)
], LeadsController.prototype, "getById", null);
tslib_1.__decorate([
    (0, common_1.Post)(),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [typeof (_f = typeof dto_1.CreateLeadsDto !== "undefined" && dto_1.CreateLeadsDto) === "function" ? _f : Object]),
    tslib_1.__metadata("design:returntype", typeof (_g = typeof Promise !== "undefined" && Promise) === "function" ? _g : Object)
], LeadsController.prototype, "create", null);
tslib_1.__decorate([
    (0, common_1.Patch)(),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [typeof (_h = typeof dto_1.UpdateLeadsDto !== "undefined" && dto_1.UpdateLeadsDto) === "function" ? _h : Object]),
    tslib_1.__metadata("design:returntype", typeof (_j = typeof Promise !== "undefined" && Promise) === "function" ? _j : Object)
], LeadsController.prototype, "update", null);
tslib_1.__decorate([
    (0, common_1.Patch)('soft-delete'),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [typeof (_k = typeof dto_1.UpdateLeadsDto !== "undefined" && dto_1.UpdateLeadsDto) === "function" ? _k : Object]),
    tslib_1.__metadata("design:returntype", typeof (_l = typeof Promise !== "undefined" && Promise) === "function" ? _l : Object)
], LeadsController.prototype, "softDelete", null);
exports.LeadsController = LeadsController = tslib_1.__decorate([
    (0, common_1.Controller)('leads'),
    tslib_1.__metadata("design:paramtypes", [typeof (_a = typeof leads_service_1.LeadsService !== "undefined" && leads_service_1.LeadsService) === "function" ? _a : Object])
], LeadsController);


/***/ }),
/* 102 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MonitoringsModule = void 0;
const tslib_1 = __webpack_require__(4);
const common_1 = __webpack_require__(1);
const monitorings_service_1 = __webpack_require__(103);
const monitorings_controller_1 = __webpack_require__(104);
const dto_1 = __webpack_require__(22);
const typeorm_1 = __webpack_require__(21);
const guards_module_1 = __webpack_require__(108);
const supabase_module_1 = __webpack_require__(9);
let MonitoringsModule = class MonitoringsModule {
};
exports.MonitoringsModule = MonitoringsModule;
exports.MonitoringsModule = MonitoringsModule = tslib_1.__decorate([
    (0, common_1.Module)({
        controllers: [monitorings_controller_1.MonitoringsController],
        providers: [monitorings_service_1.MonitoringsService],
        imports: [typeorm_1.TypeOrmModule.forFeature([dto_1.MonitoringsEntity, dto_1.UsersEntity]), guards_module_1.GuardsModule, supabase_module_1.SupabaseModule],
    })
], MonitoringsModule);


/***/ }),
/* 103 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var MonitoringsService_1;
var _a;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MonitoringsService = void 0;
const tslib_1 = __webpack_require__(4);
const dto_1 = __webpack_require__(22);
const interface_1 = __webpack_require__(67);
const utils_1 = __webpack_require__(11);
const common_1 = __webpack_require__(1);
const typeorm_1 = __webpack_require__(21);
const typeorm_2 = __webpack_require__(8);
let MonitoringsService = MonitoringsService_1 = class MonitoringsService {
    constructor(monitoringsRepo) {
        this.monitoringsRepo = monitoringsRepo;
        this.logger = new common_1.Logger(MonitoringsService_1.name);
    }
    // ====== GET ALL ======
    async getAll() {
        try {
            const monitorings = await this.monitoringsRepo.find({
                relations: ['proposal', 'company', 'created_by', 'updated_by', 'attachments'],
            });
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.MONITORINGS.GET_ALL.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.MONITORINGS.GET_ALL.MESSAGE,
                data: monitorings,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.MONITORINGS.GET_ALL.CODE,
                message: utils_1.API_RESPONSE.ERROR.MONITORINGS.GET_ALL.MESSAGE,
                data: error,
            };
        }
    }
    // ====== GET FOR SUPERVISOR (created by managers and supervisors) ======
    async getForSupervisor() {
        try {
            const monitorings = await this.monitoringsRepo.find({
                where: { created_by: { role: (0, typeorm_2.In)([interface_1.UserRole.MANAGER, interface_1.UserRole.SUPERVISOR]) } },
                relations: ['proposal', 'company', 'created_by', 'updated_by', 'attachments'],
            });
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.MONITORINGS.GET_ALL.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.MONITORINGS.GET_ALL.MESSAGE,
                data: monitorings,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.MONITORINGS.GET_ALL.CODE,
                message: utils_1.API_RESPONSE.ERROR.MONITORINGS.GET_ALL.MESSAGE,
                data: error,
            };
        }
    }
    // ====== UPDATE STATUS ONLY (management + supervisor) ======
    async updateStatus(id, status, updatedById) {
        try {
            const monitoring = await this.monitoringsRepo.findOne({ where: { id } });
            if (!monitoring) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.MONITORINGS.UPDATE.CODE,
                    message: utils_1.API_RESPONSE.ERROR.MONITORINGS.UPDATE.MESSAGE,
                    data: null,
                };
            }
            monitoring.status = status;
            if (updatedById)
                monitoring.updated_by = { id: updatedById };
            await this.monitoringsRepo.save(monitoring);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.MONITORINGS.UPDATE.CODE,
                message: 'Monitoring status updated successfully.',
                data: monitoring,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.MONITORINGS.UPDATE.CODE,
                message: utils_1.API_RESPONSE.ERROR.MONITORINGS.UPDATE.MESSAGE,
                data: error,
            };
        }
    }
    // ====== GET BY USER ID ======
    async getByUserId(userId) {
        try {
            const monitorings = await this.monitoringsRepo.find({
                where: { created_by: { id: userId } },
                relations: ['proposal', 'company', 'created_by', 'updated_by', 'attachments'],
            });
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.MONITORINGS.GET_BY_ID.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.MONITORINGS.GET_BY_ID.MESSAGE,
                data: monitorings,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.MONITORINGS.GET_BY_ID.CODE,
                message: utils_1.API_RESPONSE.ERROR.MONITORINGS.GET_BY_ID.MESSAGE,
                data: error,
            };
        }
    }
    // ====== GET BY ID ======
    async getById(id) {
        try {
            const monitoring = await this.monitoringsRepo.findOne({
                where: { id },
                relations: ['proposal', 'company', 'created_by', 'updated_by', 'attachments'],
            });
            if (!monitoring) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.MONITORINGS.GET_BY_ID.CODE,
                    message: utils_1.API_RESPONSE.ERROR.MONITORINGS.GET_BY_ID.MESSAGE,
                    data: null,
                };
            }
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.MONITORINGS.GET_BY_ID.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.MONITORINGS.GET_BY_ID.MESSAGE,
                data: monitoring,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.MONITORINGS.GET_BY_ID.CODE,
                message: utils_1.API_RESPONSE.ERROR.MONITORINGS.GET_BY_ID.MESSAGE,
                data: error,
            };
        }
    }
    // ====== CREATE ======
    async create(dto) {
        try {
            // Map relation IDs to objects
            const createData = { ...dto };
            createData.proposal = { id: dto.proposal_id };
            createData.company = { id: dto.company_id };
            if (dto.created_by_id)
                createData.created_by = { id: dto.created_by_id };
            if (dto.updated_by_id)
                createData.updated_by = { id: dto.updated_by_id };
            // Remove raw ID fields
            delete createData.proposal_id;
            delete createData.company_id;
            delete createData.created_by_id;
            delete createData.updated_by_id;
            const newMonitoring = this.monitoringsRepo.create(createData);
            await this.monitoringsRepo.save(newMonitoring);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.MONITORINGS.CREATE.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.MONITORINGS.CREATE.MESSAGE,
                data: newMonitoring,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.MONITORINGS.CREATE.CODE,
                message: utils_1.API_RESPONSE.ERROR.MONITORINGS.CREATE.MESSAGE,
                data: error,
            };
        }
    }
    // ====== UPDATE ======
    async update(dto) {
        try {
            const monitoring = await this.monitoringsRepo.findOne({ where: { id: dto.id } });
            if (!monitoring) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.MONITORINGS.UPDATE.CODE,
                    message: utils_1.API_RESPONSE.ERROR.MONITORINGS.UPDATE.MESSAGE,
                    data: null,
                };
            }
            const updateData = (0, utils_1.prepareUpdateFields)(dto, { updated_by_id: 'updated_by' });
            // Map relation IDs if present
            if (dto.company_id)
                updateData.company = { id: dto.company_id };
            Object.assign(monitoring, updateData);
            await this.monitoringsRepo.save(monitoring);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.MONITORINGS.UPDATE.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.MONITORINGS.UPDATE.MESSAGE,
                data: monitoring,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.MONITORINGS.UPDATE.CODE,
                message: utils_1.API_RESPONSE.ERROR.MONITORINGS.UPDATE.MESSAGE,
                data: error,
            };
        }
    }
    // ====== SOFT DELETE ======
    async softDelete(dto) {
        try {
            const monitoring = await this.monitoringsRepo.findOne({ where: { id: dto.id } });
            if (!monitoring) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.MONITORINGS.DELETE.CODE,
                    message: utils_1.API_RESPONSE.ERROR.MONITORINGS.DELETE.MESSAGE,
                    data: null,
                };
            }
            // For soft delete, we can change status to a "deleted" enum if exists, otherwise nullify relations
            monitoring.status = interface_1.MonitoringStatus.DELETED;
            await this.monitoringsRepo.save(monitoring);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.MONITORINGS.DELETE.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.MONITORINGS.DELETE.MESSAGE,
                data: monitoring,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.MONITORINGS.DELETE.CODE,
                message: utils_1.API_RESPONSE.ERROR.MONITORINGS.DELETE.MESSAGE,
                data: error,
            };
        }
    }
};
exports.MonitoringsService = MonitoringsService;
exports.MonitoringsService = MonitoringsService = MonitoringsService_1 = tslib_1.__decorate([
    (0, common_1.Injectable)(),
    tslib_1.__param(0, (0, typeorm_1.InjectRepository)(dto_1.MonitoringsEntity)),
    tslib_1.__metadata("design:paramtypes", [typeof (_a = typeof typeorm_2.Repository !== "undefined" && typeorm_2.Repository) === "function" ? _a : Object])
], MonitoringsService);


/***/ }),
/* 104 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MonitoringsController = void 0;
const tslib_1 = __webpack_require__(4);
const common_1 = __webpack_require__(1);
const monitorings_service_1 = __webpack_require__(103);
const dto_1 = __webpack_require__(22);
const interface_1 = __webpack_require__(67);
const auth_guard_1 = __webpack_require__(105);
const roles_guard_1 = __webpack_require__(106);
const roles_decorator_1 = __webpack_require__(107);
const class_validator_1 = __webpack_require__(24);
class UpdateMonitoringStatusDto {
}
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], UpdateMonitoringStatusDto.prototype, "id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(interface_1.MonitoringStatus),
    tslib_1.__metadata("design:type", typeof (_a = typeof interface_1.MonitoringStatus !== "undefined" && interface_1.MonitoringStatus) === "function" ? _a : Object)
], UpdateMonitoringStatusDto.prototype, "status", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateMonitoringStatusDto.prototype, "updated_by_id", void 0);
let MonitoringsController = class MonitoringsController {
    constructor(monitoringsService) {
        this.monitoringsService = monitoringsService;
    }
    // ====== GET ALL MONITORINGS ======
    async getAll() {
        return this.monitoringsService.getAll();
    }
    // ====== GET MONITORINGS FOR SUPERVISOR ======
    async getForSupervisor() {
        return this.monitoringsService.getForSupervisor();
    }
    // ====== GET MONITORINGS BY USER ID ======
    async getByUserId(userId) {
        return this.monitoringsService.getByUserId(userId);
    }
    // ====== GET MONITORING BY ID ======
    async getById(id) {
        return this.monitoringsService.getById(id);
    }
    // ====== CREATE NEW MONITORING ======
    async create(dto) {
        return this.monitoringsService.create(dto);
    }
    // ====== UPDATE STATUS (management + supervisor only) ======
    async updateStatus(dto) {
        return this.monitoringsService.updateStatus(dto.id, dto.status, dto.updated_by_id);
    }
    // ====== UPDATE MONITORING (all roles, does not update status) ======
    async update(dto) {
        return this.monitoringsService.update(dto);
    }
    // ====== SOFT DELETE MONITORING ======
    async softDelete(dto) {
        return this.monitoringsService.softDelete(dto);
    }
};
exports.MonitoringsController = MonitoringsController;
tslib_1.__decorate([
    (0, common_1.Get)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", typeof (_c = typeof Promise !== "undefined" && Promise) === "function" ? _c : Object)
], MonitoringsController.prototype, "getAll", null);
tslib_1.__decorate([
    (0, common_1.Get)('supervisor'),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", typeof (_d = typeof Promise !== "undefined" && Promise) === "function" ? _d : Object)
], MonitoringsController.prototype, "getForSupervisor", null);
tslib_1.__decorate([
    (0, common_1.Get)('user/:userId'),
    tslib_1.__param(0, (0, common_1.Param)('userId')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [String]),
    tslib_1.__metadata("design:returntype", typeof (_e = typeof Promise !== "undefined" && Promise) === "function" ? _e : Object)
], MonitoringsController.prototype, "getByUserId", null);
tslib_1.__decorate([
    (0, common_1.Get)(':id'),
    tslib_1.__param(0, (0, common_1.Param)('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [String]),
    tslib_1.__metadata("design:returntype", typeof (_f = typeof Promise !== "undefined" && Promise) === "function" ? _f : Object)
], MonitoringsController.prototype, "getById", null);
tslib_1.__decorate([
    (0, common_1.Post)(),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [typeof (_g = typeof dto_1.CreateMonitoringsDto !== "undefined" && dto_1.CreateMonitoringsDto) === "function" ? _g : Object]),
    tslib_1.__metadata("design:returntype", typeof (_h = typeof Promise !== "undefined" && Promise) === "function" ? _h : Object)
], MonitoringsController.prototype, "create", null);
tslib_1.__decorate([
    (0, common_1.Patch)('update-status'),
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard, roles_guard_1.RolesGuard),
    (0, roles_decorator_1.Roles)(interface_1.UserRole.MANAGEMENT, interface_1.UserRole.SUPERVISOR),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [UpdateMonitoringStatusDto]),
    tslib_1.__metadata("design:returntype", typeof (_j = typeof Promise !== "undefined" && Promise) === "function" ? _j : Object)
], MonitoringsController.prototype, "updateStatus", null);
tslib_1.__decorate([
    (0, common_1.Patch)(),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [typeof (_k = typeof dto_1.UpdateMonitoringsDto !== "undefined" && dto_1.UpdateMonitoringsDto) === "function" ? _k : Object]),
    tslib_1.__metadata("design:returntype", typeof (_l = typeof Promise !== "undefined" && Promise) === "function" ? _l : Object)
], MonitoringsController.prototype, "update", null);
tslib_1.__decorate([
    (0, common_1.Patch)('soft-delete'),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [typeof (_m = typeof dto_1.UpdateMonitoringsDto !== "undefined" && dto_1.UpdateMonitoringsDto) === "function" ? _m : Object]),
    tslib_1.__metadata("design:returntype", typeof (_o = typeof Promise !== "undefined" && Promise) === "function" ? _o : Object)
], MonitoringsController.prototype, "softDelete", null);
exports.MonitoringsController = MonitoringsController = tslib_1.__decorate([
    (0, common_1.Controller)('monitorings'),
    tslib_1.__metadata("design:paramtypes", [typeof (_b = typeof monitorings_service_1.MonitoringsService !== "undefined" && monitorings_service_1.MonitoringsService) === "function" ? _b : Object])
], MonitoringsController);


/***/ }),
/* 105 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a, _b;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AuthGuard = void 0;
const tslib_1 = __webpack_require__(4);
const common_1 = __webpack_require__(1);
const supabase_service_1 = __webpack_require__(10);
const typeorm_1 = __webpack_require__(21);
const typeorm_2 = __webpack_require__(8);
const dto_1 = __webpack_require__(22);
let AuthGuard = class AuthGuard {
    constructor(supabase, usersRepo) {
        this.supabase = supabase;
        this.usersRepo = usersRepo;
    }
    async canActivate(context) {
        const request = context.switchToHttp().getRequest();
        const authHeader = request.headers['authorization'];
        if (!authHeader || !authHeader.startsWith('Bearer ')) {
            throw new common_1.UnauthorizedException('No authorization token provided.');
        }
        const token = authHeader.split(' ')[1];
        const { data, error } = await this.supabase.client.auth.getUser(token);
        if (error || !data?.user) {
            throw new common_1.UnauthorizedException('Invalid or expired token.');
        }
        const dbUser = await this.usersRepo.findOne({
            where: { id: data.user.id },
        });
        if (!dbUser) {
            throw new common_1.UnauthorizedException('User not found.');
        }
        request.user = dbUser;
        return true;
    }
};
exports.AuthGuard = AuthGuard;
exports.AuthGuard = AuthGuard = tslib_1.__decorate([
    (0, common_1.Injectable)(),
    tslib_1.__param(1, (0, typeorm_1.InjectRepository)(dto_1.UsersEntity)),
    tslib_1.__metadata("design:paramtypes", [typeof (_a = typeof supabase_service_1.SupabaseService !== "undefined" && supabase_service_1.SupabaseService) === "function" ? _a : Object, typeof (_b = typeof typeorm_2.Repository !== "undefined" && typeorm_2.Repository) === "function" ? _b : Object])
], AuthGuard);


/***/ }),
/* 106 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RolesGuard = void 0;
const tslib_1 = __webpack_require__(4);
const common_1 = __webpack_require__(1);
const core_1 = __webpack_require__(2);
const roles_decorator_1 = __webpack_require__(107);
let RolesGuard = class RolesGuard {
    constructor(reflector) {
        this.reflector = reflector;
    }
    canActivate(context) {
        const requiredRoles = this.reflector.getAllAndOverride(roles_decorator_1.ROLES_KEY, [
            context.getHandler(),
            context.getClass(),
        ]);
        if (!requiredRoles || requiredRoles.length === 0) {
            return true;
        }
        const request = context.switchToHttp().getRequest();
        const user = request.user;
        if (!user) {
            throw new common_1.ForbiddenException('Access denied.');
        }
        const hasRole = requiredRoles.some((role) => user.role === role);
        if (!hasRole) {
            throw new common_1.ForbiddenException(`Access denied. Required roles: ${requiredRoles.join(', ')}.`);
        }
        return true;
    }
};
exports.RolesGuard = RolesGuard;
exports.RolesGuard = RolesGuard = tslib_1.__decorate([
    (0, common_1.Injectable)(),
    tslib_1.__metadata("design:paramtypes", [typeof (_a = typeof core_1.Reflector !== "undefined" && core_1.Reflector) === "function" ? _a : Object])
], RolesGuard);


/***/ }),
/* 107 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Roles = exports.ROLES_KEY = void 0;
const common_1 = __webpack_require__(1);
exports.ROLES_KEY = 'roles';
const Roles = (...roles) => (0, common_1.SetMetadata)(exports.ROLES_KEY, roles);
exports.Roles = Roles;


/***/ }),
/* 108 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GuardsModule = void 0;
const tslib_1 = __webpack_require__(4);
const common_1 = __webpack_require__(1);
const typeorm_1 = __webpack_require__(21);
const supabase_module_1 = __webpack_require__(9);
const dto_1 = __webpack_require__(22);
const auth_guard_1 = __webpack_require__(105);
const roles_guard_1 = __webpack_require__(106);
let GuardsModule = class GuardsModule {
};
exports.GuardsModule = GuardsModule;
exports.GuardsModule = GuardsModule = tslib_1.__decorate([
    (0, common_1.Module)({
        imports: [supabase_module_1.SupabaseModule, typeorm_1.TypeOrmModule.forFeature([dto_1.UsersEntity])],
        providers: [auth_guard_1.AuthGuard, roles_guard_1.RolesGuard],
        exports: [auth_guard_1.AuthGuard, roles_guard_1.RolesGuard],
    })
], GuardsModule);


/***/ }),
/* 109 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ProposalsModule = void 0;
const tslib_1 = __webpack_require__(4);
const common_1 = __webpack_require__(1);
const proposals_service_1 = __webpack_require__(110);
const proposals_controller_1 = __webpack_require__(111);
const typeorm_1 = __webpack_require__(21);
const dto_1 = __webpack_require__(22);
const guards_module_1 = __webpack_require__(108);
const supabase_module_1 = __webpack_require__(9);
let ProposalsModule = class ProposalsModule {
};
exports.ProposalsModule = ProposalsModule;
exports.ProposalsModule = ProposalsModule = tslib_1.__decorate([
    (0, common_1.Module)({
        controllers: [proposals_controller_1.ProposalsController],
        providers: [proposals_service_1.ProposalsService],
        imports: [
            typeorm_1.TypeOrmModule.forFeature([
                dto_1.ProposalsEntity,
                dto_1.ProposalAttachmentsEntity,
                dto_1.ProposalItemsEntity,
                dto_1.ProposalPricingSummaryEntity,
                dto_1.UsersEntity,
            ]),
            guards_module_1.GuardsModule,
            supabase_module_1.SupabaseModule
        ],
    })
], ProposalsModule);


/***/ }),
/* 110 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var ProposalsService_1;
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ProposalsService = void 0;
const tslib_1 = __webpack_require__(4);
const dto_1 = __webpack_require__(22);
const interface_1 = __webpack_require__(67);
const utils_1 = __webpack_require__(11);
const common_1 = __webpack_require__(1);
const typeorm_1 = __webpack_require__(21);
const typeorm_2 = __webpack_require__(8);
const PROPOSAL_APPROVAL_LIMIT = 250000;
let ProposalsService = ProposalsService_1 = class ProposalsService {
    constructor(proposalsRepo, attachmentsRepo, itemsRepo, summaryRepo) {
        this.proposalsRepo = proposalsRepo;
        this.attachmentsRepo = attachmentsRepo;
        this.itemsRepo = itemsRepo;
        this.summaryRepo = summaryRepo;
        this.logger = new common_1.Logger(ProposalsService_1.name);
    }
    // ====== PROPOSALS ======
    async getAll() {
        try {
            const proposals = await this.proposalsRepo.find({
                relations: ['created_by', 'updated_by', 'proposal_attachments', 'proposal_items', 'proposal_pricing_summary'],
            });
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.PROPOSALS.GET_ALL.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.PROPOSALS.GET_ALL.MESSAGE,
                data: proposals,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.PROPOSALS.GET_ALL.CODE,
                message: utils_1.API_RESPONSE.ERROR.PROPOSALS.GET_ALL.MESSAGE,
                data: error,
            };
        }
    }
    // Get proposals for supervisor (created by managers and supervisors)
    async getForSupervisor() {
        try {
            const proposals = await this.proposalsRepo.find({
                where: { created_by: { role: (0, typeorm_2.In)([interface_1.UserRole.MANAGER, interface_1.UserRole.SUPERVISOR]) } },
                relations: ['created_by', 'updated_by', 'company_ref', 'proposal_attachments', 'proposal_items', 'proposal_pricing_summary'],
            });
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.PROPOSALS.GET_ALL.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.PROPOSALS.GET_ALL.MESSAGE,
                data: proposals,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.PROPOSALS.GET_ALL.CODE,
                message: utils_1.API_RESPONSE.ERROR.PROPOSALS.GET_ALL.MESSAGE,
                data: error,
            };
        }
    }
    // Approve proposal — management can approve all, supervisor cannot approve >250k
    async approveProposal(id, status, userRole, updatedById) {
        try {
            const proposal = await this.proposalsRepo.findOne({
                where: { id },
                relations: ['proposal_pricing_summary'],
            });
            if (!proposal) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.PROPOSALS.UPDATE.CODE,
                    message: 'Proposal not found.',
                    data: null,
                };
            }
            const grandTotal = proposal.proposal_pricing_summary?.grand_total ?? 0;
            if (userRole === interface_1.UserRole.SUPERVISOR && Number(grandTotal) > PROPOSAL_APPROVAL_LIMIT) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: 403,
                    message: `Supervisors cannot approve proposals exceeding ₱${PROPOSAL_APPROVAL_LIMIT.toLocaleString()}. Management approval required.`,
                    data: null,
                };
            }
            proposal.status = status;
            if (updatedById)
                proposal.updated_by = { id: updatedById };
            await this.proposalsRepo.save(proposal);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.PROPOSALS.UPDATE.CODE,
                message: 'Proposal status updated successfully.',
                data: proposal,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.PROPOSALS.UPDATE.CODE,
                message: utils_1.API_RESPONSE.ERROR.PROPOSALS.UPDATE.MESSAGE,
                data: error,
            };
        }
    }
    async getByUserId(userId) {
        try {
            const proposals = await this.proposalsRepo.find({
                where: { created_by: { id: userId } },
                relations: ['created_by', 'updated_by', 'proposal_attachments', 'proposal_items', 'proposal_pricing_summary'],
            });
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.PROPOSALS.GET_BY_ID.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.PROPOSALS.GET_BY_ID.MESSAGE,
                data: proposals,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.PROPOSALS.GET_BY_ID.CODE,
                message: utils_1.API_RESPONSE.ERROR.PROPOSALS.GET_BY_ID.MESSAGE,
                data: error,
            };
        }
    }
    async getById(id) {
        try {
            const proposal = await this.proposalsRepo.findOne({
                where: { id },
                relations: ['created_by', 'updated_by', 'proposal_attachments', 'proposal_items', 'proposal_pricing_summary'],
            });
            if (!proposal) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.PROPOSALS.GET_BY_ID.CODE,
                    message: utils_1.API_RESPONSE.ERROR.PROPOSALS.GET_BY_ID.MESSAGE,
                    data: null,
                };
            }
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.PROPOSALS.GET_BY_ID.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.PROPOSALS.GET_BY_ID.MESSAGE,
                data: proposal,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.PROPOSALS.GET_BY_ID.CODE,
                message: utils_1.API_RESPONSE.ERROR.PROPOSALS.GET_BY_ID.MESSAGE,
                data: error,
            };
        }
    }
    async create(dto) {
        try {
            const newProposal = this.proposalsRepo.create(dto);
            await this.proposalsRepo.save(newProposal);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.PROPOSALS.CREATE.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.PROPOSALS.CREATE.MESSAGE,
                data: newProposal,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.PROPOSALS.CREATE.CODE,
                message: utils_1.API_RESPONSE.ERROR.PROPOSALS.CREATE.MESSAGE,
                data: error,
            };
        }
    }
    async update(dto) {
        try {
            const proposal = await this.proposalsRepo.findOne({ where: { id: dto.id } });
            if (!proposal) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.PROPOSALS.UPDATE.CODE,
                    message: utils_1.API_RESPONSE.ERROR.PROPOSALS.UPDATE.MESSAGE,
                    data: null,
                };
            }
            const updateData = (0, utils_1.prepareUpdateFields)(dto, { updated_by_id: 'updated_by' });
            Object.assign(proposal, updateData);
            await this.proposalsRepo.save(proposal);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.PROPOSALS.UPDATE.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.PROPOSALS.UPDATE.MESSAGE,
                data: proposal,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.PROPOSALS.UPDATE.CODE,
                message: utils_1.API_RESPONSE.ERROR.PROPOSALS.UPDATE.MESSAGE,
                data: error,
            };
        }
    }
    async softDelete(dto) {
        try {
            const proposal = await this.proposalsRepo.findOne({ where: { id: dto.id } });
            if (!proposal) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.PROPOSALS.DELETE.CODE,
                    message: utils_1.API_RESPONSE.ERROR.PROPOSALS.DELETE.MESSAGE,
                    data: null,
                };
            }
            proposal.status = interface_1.ProposalStatus.DELETED;
            await this.proposalsRepo.save(proposal);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.PROPOSALS.DELETE.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.PROPOSALS.DELETE.MESSAGE,
                data: proposal,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.PROPOSALS.DELETE.CODE,
                message: utils_1.API_RESPONSE.ERROR.PROPOSALS.DELETE.MESSAGE,
                data: error,
            };
        }
    }
    async saveAsDraft(dto) {
        try {
            const proposal = await this.proposalsRepo.findOne({ where: { id: dto.id } });
            if (!proposal) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.PROPOSALS.DELETE.CODE,
                    message: utils_1.API_RESPONSE.ERROR.PROPOSALS.DELETE.MESSAGE,
                    data: null,
                };
            }
            proposal.status = interface_1.ProposalStatus.DRAFT;
            await this.proposalsRepo.save(proposal);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.PROPOSALS.DELETE.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.PROPOSALS.DELETE.MESSAGE,
                data: proposal,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.PROPOSALS.DELETE.CODE,
                message: utils_1.API_RESPONSE.ERROR.PROPOSALS.DELETE.MESSAGE,
                data: error,
            };
        }
    }
    // ====== PROPOSAL ATTACHMENTS ======
    async createProposalAttachment(dto) {
        try {
            const newAttachment = this.attachmentsRepo.create(dto);
            await this.attachmentsRepo.save(newAttachment);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.PROPOSAL_ATTACHMENT.CREATE.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.PROPOSAL_ATTACHMENT.CREATE.MESSAGE,
                data: newAttachment,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.PROPOSAL_ATTACHMENT.CREATE.CODE,
                message: utils_1.API_RESPONSE.ERROR.PROPOSAL_ATTACHMENT.CREATE.MESSAGE,
                data: error,
            };
        }
    }
    async updateProposalAttachment(dto) {
        try {
            const attachment = await this.attachmentsRepo.findOne({
                where: {
                    proposal: { id: dto.proposal_id },
                    attachment: { id: dto.attachment_id },
                },
                relations: ['proposal', 'attachment'],
            });
            if (!attachment) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.PROPOSAL_ATTACHMENT.UPDATE.CODE,
                    message: utils_1.API_RESPONSE.ERROR.PROPOSAL_ATTACHMENT.UPDATE.MESSAGE,
                    data: null,
                };
            }
            Object.assign(attachment, dto);
            await this.attachmentsRepo.save(attachment);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.PROPOSAL_ATTACHMENT.UPDATE.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.PROPOSAL_ATTACHMENT.UPDATE.MESSAGE,
                data: attachment,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.PROPOSAL_ATTACHMENT.UPDATE.CODE,
                message: utils_1.API_RESPONSE.ERROR.PROPOSAL_ATTACHMENT.UPDATE.MESSAGE,
                data: error,
            };
        }
    }
    // ====== PROPOSAL ITEMS ======
    async getProposalItemByProposalId(id) {
        try {
            const items = await this.itemsRepo.find({
                where: { proposal: { id } },
            });
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.PROPOSAL_ITEMS.GET_BY_ID.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.PROPOSAL_ITEMS.GET_BY_ID.MESSAGE,
                data: items,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.PROPOSAL_ITEMS.GET_BY_ID.CODE,
                message: utils_1.API_RESPONSE.ERROR.PROPOSAL_ITEMS.GET_BY_ID.MESSAGE,
                data: error,
            };
        }
    }
    async createProposalItem(dto) {
        try {
            const createData = { ...dto };
            if (dto.attachment_item_img) {
                createData.attachment_item_img = { id: dto.attachment_item_img };
            }
            // Map proposal_id to proposal relation
            if (dto.proposal_id) {
                createData.proposal = { id: dto.proposal_id };
                delete createData.proposal_id;
            }
            const newItem = this.itemsRepo.create(createData);
            await this.itemsRepo.save(newItem);
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.PROPOSAL_ITEMS.CREATE.CODE,
                message: utils_1.API_RESPONSE.ERROR.PROPOSAL_ITEMS.CREATE.MESSAGE,
                data: error,
            };
        }
    }
    async updateProposalItem(dto) {
        try {
            const item = await this.itemsRepo.findOne({ where: { id: dto.id } });
            if (!item) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.PROPOSAL_ITEMS.UPDATE.CODE,
                    message: utils_1.API_RESPONSE.ERROR.PROPOSAL_ITEMS.UPDATE.MESSAGE,
                    data: null,
                };
            }
            Object.assign(item, dto);
            await this.itemsRepo.save(item);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.PROPOSAL_ITEMS.UPDATE.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.PROPOSAL_ITEMS.UPDATE.MESSAGE,
                data: item,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.PROPOSAL_ITEMS.UPDATE.CODE,
                message: utils_1.API_RESPONSE.ERROR.PROPOSAL_ITEMS.UPDATE.MESSAGE,
                data: error,
            };
        }
    }
    async softDeleteProposalItem(dto) {
        try {
            const item = await this.itemsRepo.findOne({ where: { id: dto.id } });
            if (!item) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.PROPOSAL_ITEMS.DELETE.CODE,
                    message: utils_1.API_RESPONSE.ERROR.PROPOSAL_ITEMS.DELETE.MESSAGE,
                    data: null,
                };
            }
            item.status = interface_1.ProposalItemStatus.DELETED;
            await this.itemsRepo.save(item);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.PROPOSAL_ITEMS.DELETE.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.PROPOSAL_ITEMS.DELETE.MESSAGE,
                data: item,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.PROPOSAL_ITEMS.DELETE.CODE,
                message: utils_1.API_RESPONSE.ERROR.PROPOSAL_ITEMS.DELETE.MESSAGE,
                data: error,
            };
        }
    }
    // ====== PROPOSAL PRICING SUMMARY ======
    async getProposalSummaryByProposalId(id) {
        try {
            const summary = await this.summaryRepo.findOne({ where: { proposal: { id } } });
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.PROPOSAL_PRICING_SUMMARY.GET_BY_ID.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.PROPOSAL_PRICING_SUMMARY.GET_BY_ID.MESSAGE,
                data: summary,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.PROPOSAL_PRICING_SUMMARY.GET_BY_ID.CODE,
                message: utils_1.API_RESPONSE.ERROR.PROPOSAL_PRICING_SUMMARY.GET_BY_ID.MESSAGE,
                data: error,
            };
        }
    }
    async createProposalSummary(dto) {
        try {
            const newSummary = this.summaryRepo.create(dto);
            await this.summaryRepo.save(newSummary);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.PROPOSAL_PRICING_SUMMARY.CREATE.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.PROPOSAL_PRICING_SUMMARY.CREATE.MESSAGE,
                data: newSummary,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.PROPOSAL_PRICING_SUMMARY.CREATE.CODE,
                message: utils_1.API_RESPONSE.ERROR.PROPOSAL_PRICING_SUMMARY.CREATE.MESSAGE,
                data: error,
            };
        }
    }
    async updateProposalSummary(dto) {
        try {
            const summary = await this.summaryRepo.findOne({ where: { id: dto.id } });
            if (!summary) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.PROPOSAL_PRICING_SUMMARY.UPDATE.CODE,
                    message: utils_1.API_RESPONSE.ERROR.PROPOSAL_PRICING_SUMMARY.UPDATE.MESSAGE,
                    data: null,
                };
            }
            Object.assign(summary, dto);
            await this.summaryRepo.save(summary);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.PROPOSAL_PRICING_SUMMARY.UPDATE.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.PROPOSAL_PRICING_SUMMARY.UPDATE.MESSAGE,
                data: summary,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.PROPOSAL_PRICING_SUMMARY.UPDATE.CODE,
                message: utils_1.API_RESPONSE.ERROR.PROPOSAL_PRICING_SUMMARY.UPDATE.MESSAGE,
                data: error,
            };
        }
    }
};
exports.ProposalsService = ProposalsService;
exports.ProposalsService = ProposalsService = ProposalsService_1 = tslib_1.__decorate([
    (0, common_1.Injectable)(),
    tslib_1.__param(0, (0, typeorm_1.InjectRepository)(dto_1.ProposalsEntity)),
    tslib_1.__param(1, (0, typeorm_1.InjectRepository)(dto_1.ProposalAttachmentsEntity)),
    tslib_1.__param(2, (0, typeorm_1.InjectRepository)(dto_1.ProposalItemsEntity)),
    tslib_1.__param(3, (0, typeorm_1.InjectRepository)(dto_1.ProposalPricingSummaryEntity)),
    tslib_1.__metadata("design:paramtypes", [typeof (_a = typeof typeorm_2.Repository !== "undefined" && typeorm_2.Repository) === "function" ? _a : Object, typeof (_b = typeof typeorm_2.Repository !== "undefined" && typeorm_2.Repository) === "function" ? _b : Object, typeof (_c = typeof typeorm_2.Repository !== "undefined" && typeorm_2.Repository) === "function" ? _c : Object, typeof (_d = typeof typeorm_2.Repository !== "undefined" && typeorm_2.Repository) === "function" ? _d : Object])
], ProposalsService);


/***/ }),
/* 111 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0, _1, _2, _3, _4, _5, _6;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ProposalsController = void 0;
const tslib_1 = __webpack_require__(4);
const common_1 = __webpack_require__(1);
const proposals_service_1 = __webpack_require__(110);
const dto_1 = __webpack_require__(22);
const interface_1 = __webpack_require__(67);
const auth_guard_1 = __webpack_require__(105);
const roles_guard_1 = __webpack_require__(106);
const roles_decorator_1 = __webpack_require__(107);
const class_validator_1 = __webpack_require__(24);
class ApproveProposalDto {
}
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], ApproveProposalDto.prototype, "id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(interface_1.ProposalStatus),
    tslib_1.__metadata("design:type", typeof (_a = typeof interface_1.ProposalStatus !== "undefined" && interface_1.ProposalStatus) === "function" ? _a : Object)
], ApproveProposalDto.prototype, "status", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], ApproveProposalDto.prototype, "updated_by_id", void 0);
let ProposalsController = class ProposalsController {
    constructor(proposalsService) {
        this.proposalsService = proposalsService;
    }
    // ====== PROPOSALS ======
    async getAll() {
        return this.proposalsService.getAll();
    }
    async getForSupervisor() {
        return this.proposalsService.getForSupervisor();
    }
    async getByUserId(userId) {
        return this.proposalsService.getByUserId(userId);
    }
    async getById(id) {
        return this.proposalsService.getById(id);
    }
    async create(dto) {
        return this.proposalsService.create(dto);
    }
    async update(dto) {
        return this.proposalsService.update(dto);
    }
    async softDelete(dto) {
        return this.proposalsService.softDelete(dto);
    }
    async saveAsDraft(dto) {
        return this.proposalsService.saveAsDraft(dto);
    }
    // ====== APPROVE PROPOSAL (management + supervisor; management required for >250k) ======
    async approveProposal(dto, req) {
        return this.proposalsService.approveProposal(dto.id, dto.status, req.user.role, dto.updated_by_id);
    }
    // ====== PROPOSAL ATTACHMENTS ======
    async createAttachment(dto) {
        return this.proposalsService.createProposalAttachment(dto);
    }
    async updateAttachment(dto) {
        return this.proposalsService.updateProposalAttachment(dto);
    }
    // ====== PROPOSAL ITEMS ======
    async getItemsByProposalId(proposalId) {
        return this.proposalsService.getProposalItemByProposalId(proposalId);
    }
    async createItem(dto) {
        return this.proposalsService.createProposalItem(dto);
    }
    async updateItem(dto) {
        return this.proposalsService.updateProposalItem(dto);
    }
    async softDeleteItem(dto) {
        return this.proposalsService.softDeleteProposalItem(dto);
    }
    // ====== PROPOSAL PRICING SUMMARY ======
    async getSummaryByProposalId(proposalId) {
        return this.proposalsService.getProposalSummaryByProposalId(proposalId);
    }
    async createSummary(dto) {
        return this.proposalsService.createProposalSummary(dto);
    }
    async updateSummary(dto) {
        return this.proposalsService.updateProposalSummary(dto);
    }
};
exports.ProposalsController = ProposalsController;
tslib_1.__decorate([
    (0, common_1.Get)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", typeof (_c = typeof Promise !== "undefined" && Promise) === "function" ? _c : Object)
], ProposalsController.prototype, "getAll", null);
tslib_1.__decorate([
    (0, common_1.Get)('supervisor'),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", typeof (_d = typeof Promise !== "undefined" && Promise) === "function" ? _d : Object)
], ProposalsController.prototype, "getForSupervisor", null);
tslib_1.__decorate([
    (0, common_1.Get)('user/:userId'),
    tslib_1.__param(0, (0, common_1.Param)('userId')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [String]),
    tslib_1.__metadata("design:returntype", typeof (_e = typeof Promise !== "undefined" && Promise) === "function" ? _e : Object)
], ProposalsController.prototype, "getByUserId", null);
tslib_1.__decorate([
    (0, common_1.Get)(':id'),
    tslib_1.__param(0, (0, common_1.Param)('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [String]),
    tslib_1.__metadata("design:returntype", typeof (_f = typeof Promise !== "undefined" && Promise) === "function" ? _f : Object)
], ProposalsController.prototype, "getById", null);
tslib_1.__decorate([
    (0, common_1.Post)(),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [typeof (_g = typeof dto_1.CreateProposalsDto !== "undefined" && dto_1.CreateProposalsDto) === "function" ? _g : Object]),
    tslib_1.__metadata("design:returntype", typeof (_h = typeof Promise !== "undefined" && Promise) === "function" ? _h : Object)
], ProposalsController.prototype, "create", null);
tslib_1.__decorate([
    (0, common_1.Patch)(),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [typeof (_j = typeof dto_1.UpdateProposalsDto !== "undefined" && dto_1.UpdateProposalsDto) === "function" ? _j : Object]),
    tslib_1.__metadata("design:returntype", typeof (_k = typeof Promise !== "undefined" && Promise) === "function" ? _k : Object)
], ProposalsController.prototype, "update", null);
tslib_1.__decorate([
    (0, common_1.Patch)('soft-delete'),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [typeof (_l = typeof dto_1.UpdateProposalsDto !== "undefined" && dto_1.UpdateProposalsDto) === "function" ? _l : Object]),
    tslib_1.__metadata("design:returntype", typeof (_m = typeof Promise !== "undefined" && Promise) === "function" ? _m : Object)
], ProposalsController.prototype, "softDelete", null);
tslib_1.__decorate([
    (0, common_1.Patch)('save-draft'),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [typeof (_o = typeof dto_1.UpdateProposalsDto !== "undefined" && dto_1.UpdateProposalsDto) === "function" ? _o : Object]),
    tslib_1.__metadata("design:returntype", typeof (_p = typeof Promise !== "undefined" && Promise) === "function" ? _p : Object)
], ProposalsController.prototype, "saveAsDraft", null);
tslib_1.__decorate([
    (0, common_1.Patch)('approve'),
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard, roles_guard_1.RolesGuard),
    (0, roles_decorator_1.Roles)(interface_1.UserRole.MANAGEMENT, interface_1.UserRole.SUPERVISOR),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__param(1, (0, common_1.Req)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [ApproveProposalDto, Object]),
    tslib_1.__metadata("design:returntype", typeof (_q = typeof Promise !== "undefined" && Promise) === "function" ? _q : Object)
], ProposalsController.prototype, "approveProposal", null);
tslib_1.__decorate([
    (0, common_1.Post)('attachments'),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [typeof (_r = typeof dto_1.CreateProposalAttachmentsDto !== "undefined" && dto_1.CreateProposalAttachmentsDto) === "function" ? _r : Object]),
    tslib_1.__metadata("design:returntype", typeof (_s = typeof Promise !== "undefined" && Promise) === "function" ? _s : Object)
], ProposalsController.prototype, "createAttachment", null);
tslib_1.__decorate([
    (0, common_1.Patch)('attachments'),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [typeof (_t = typeof dto_1.UpdateProposalAttachmentsDto !== "undefined" && dto_1.UpdateProposalAttachmentsDto) === "function" ? _t : Object]),
    tslib_1.__metadata("design:returntype", typeof (_u = typeof Promise !== "undefined" && Promise) === "function" ? _u : Object)
], ProposalsController.prototype, "updateAttachment", null);
tslib_1.__decorate([
    (0, common_1.Get)(':proposalId/items'),
    tslib_1.__param(0, (0, common_1.Param)('proposalId')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [String]),
    tslib_1.__metadata("design:returntype", typeof (_v = typeof Promise !== "undefined" && Promise) === "function" ? _v : Object)
], ProposalsController.prototype, "getItemsByProposalId", null);
tslib_1.__decorate([
    (0, common_1.Post)('items'),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [typeof (_w = typeof dto_1.CreateProposalItemsDto !== "undefined" && dto_1.CreateProposalItemsDto) === "function" ? _w : Object]),
    tslib_1.__metadata("design:returntype", typeof (_x = typeof Promise !== "undefined" && Promise) === "function" ? _x : Object)
], ProposalsController.prototype, "createItem", null);
tslib_1.__decorate([
    (0, common_1.Patch)('items'),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [typeof (_y = typeof dto_1.UpdateProposalItemsDto !== "undefined" && dto_1.UpdateProposalItemsDto) === "function" ? _y : Object]),
    tslib_1.__metadata("design:returntype", typeof (_z = typeof Promise !== "undefined" && Promise) === "function" ? _z : Object)
], ProposalsController.prototype, "updateItem", null);
tslib_1.__decorate([
    (0, common_1.Patch)('items/soft-delete'),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [typeof (_0 = typeof dto_1.UpdateProposalItemsDto !== "undefined" && dto_1.UpdateProposalItemsDto) === "function" ? _0 : Object]),
    tslib_1.__metadata("design:returntype", typeof (_1 = typeof Promise !== "undefined" && Promise) === "function" ? _1 : Object)
], ProposalsController.prototype, "softDeleteItem", null);
tslib_1.__decorate([
    (0, common_1.Get)(':proposalId/summary'),
    tslib_1.__param(0, (0, common_1.Param)('proposalId')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [String]),
    tslib_1.__metadata("design:returntype", typeof (_2 = typeof Promise !== "undefined" && Promise) === "function" ? _2 : Object)
], ProposalsController.prototype, "getSummaryByProposalId", null);
tslib_1.__decorate([
    (0, common_1.Post)('summary'),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [typeof (_3 = typeof dto_1.CreateProposalPricingSummaryDto !== "undefined" && dto_1.CreateProposalPricingSummaryDto) === "function" ? _3 : Object]),
    tslib_1.__metadata("design:returntype", typeof (_4 = typeof Promise !== "undefined" && Promise) === "function" ? _4 : Object)
], ProposalsController.prototype, "createSummary", null);
tslib_1.__decorate([
    (0, common_1.Patch)('summary'),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [typeof (_5 = typeof dto_1.UpdateProposalPricingSummaryDto !== "undefined" && dto_1.UpdateProposalPricingSummaryDto) === "function" ? _5 : Object]),
    tslib_1.__metadata("design:returntype", typeof (_6 = typeof Promise !== "undefined" && Promise) === "function" ? _6 : Object)
], ProposalsController.prototype, "updateSummary", null);
exports.ProposalsController = ProposalsController = tslib_1.__decorate([
    (0, common_1.Controller)('proposals'),
    tslib_1.__metadata("design:paramtypes", [typeof (_b = typeof proposals_service_1.ProposalsService !== "undefined" && proposals_service_1.ProposalsService) === "function" ? _b : Object])
], ProposalsController);


/***/ }),
/* 112 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SalesModule = void 0;
const tslib_1 = __webpack_require__(4);
const common_1 = __webpack_require__(1);
const sales_service_1 = __webpack_require__(113);
const sales_controller_1 = __webpack_require__(114);
const dto_1 = __webpack_require__(22);
const typeorm_1 = __webpack_require__(21);
const guards_module_1 = __webpack_require__(108);
const supabase_module_1 = __webpack_require__(9);
let SalesModule = class SalesModule {
};
exports.SalesModule = SalesModule;
exports.SalesModule = SalesModule = tslib_1.__decorate([
    (0, common_1.Module)({
        controllers: [sales_controller_1.SalesController],
        providers: [sales_service_1.SalesService],
        imports: [
            typeorm_1.TypeOrmModule.forFeature([dto_1.SalesEntity, dto_1.SaleAttachmentsEntity, dto_1.UsersEntity]),
            guards_module_1.GuardsModule,
            supabase_module_1.SupabaseModule
        ],
    })
], SalesModule);


/***/ }),
/* 113 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var SalesService_1;
var _a, _b;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SalesService = void 0;
const tslib_1 = __webpack_require__(4);
const dto_1 = __webpack_require__(22);
const interface_1 = __webpack_require__(67);
const utils_1 = __webpack_require__(11);
const common_1 = __webpack_require__(1);
const typeorm_1 = __webpack_require__(21);
const typeorm_2 = __webpack_require__(8);
let SalesService = SalesService_1 = class SalesService {
    constructor(salesRepo, salesAttachmentsRepo) {
        this.salesRepo = salesRepo;
        this.salesAttachmentsRepo = salesAttachmentsRepo;
        this.logger = new common_1.Logger(SalesService_1.name);
    }
    // ====== GET ALL ======
    async getAll() {
        try {
            const sales = await this.salesRepo.find({
                relations: ['monitoring', 'created_by', 'updated_by', 'attachments', 'attachments.attachment'],
            });
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.SALES.GET_ALL.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.SALES.GET_ALL.MESSAGE,
                data: sales,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.SALES.GET_ALL.CODE,
                message: utils_1.API_RESPONSE.ERROR.SALES.GET_ALL.MESSAGE,
                data: error,
            };
        }
    }
    // ====== GET FOR SUPERVISOR (created by managers and supervisors) ======
    async getForSupervisor() {
        try {
            const sales = await this.salesRepo.find({
                where: { created_by: { role: (0, typeorm_2.In)([interface_1.UserRole.MANAGER, interface_1.UserRole.SUPERVISOR]) } },
                relations: ['monitoring', 'created_by', 'updated_by', 'attachments', 'attachments.attachment'],
            });
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.SALES.GET_ALL.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.SALES.GET_ALL.MESSAGE,
                data: sales,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.SALES.GET_ALL.CODE,
                message: utils_1.API_RESPONSE.ERROR.SALES.GET_ALL.MESSAGE,
                data: error,
            };
        }
    }
    // ====== UPDATE STATUS (management + supervisor only) ======
    async updateStatus(id, status, updatedById) {
        try {
            const sale = await this.salesRepo.findOne({ where: { id } });
            if (!sale) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.SALES.UPDATE.CODE,
                    message: utils_1.API_RESPONSE.ERROR.SALES.UPDATE.MESSAGE,
                    data: null,
                };
            }
            sale.status = status;
            if (updatedById)
                sale.updated_by = { id: updatedById };
            await this.salesRepo.save(sale);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.SALES.UPDATE.CODE,
                message: 'Sale status updated successfully.',
                data: sale,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.SALES.UPDATE.CODE,
                message: utils_1.API_RESPONSE.ERROR.SALES.UPDATE.MESSAGE,
                data: error,
            };
        }
    }
    // ====== GET BY USER ID ======
    async getByUserId(userId) {
        try {
            const sales = await this.salesRepo.find({
                where: { created_by: { id: userId } },
                relations: ['monitoring', 'created_by', 'updated_by', 'attachments', 'attachments.attachment'],
            });
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.SALES.GET_BY_ID.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.SALES.GET_BY_ID.MESSAGE,
                data: sales,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.SALES.GET_BY_ID.CODE,
                message: utils_1.API_RESPONSE.ERROR.SALES.GET_BY_ID.MESSAGE,
                data: error,
            };
        }
    }
    // ====== GET BY ID ======
    async getById(id) {
        try {
            const sale = await this.salesRepo.findOne({
                where: { id },
                relations: ['monitoring', 'created_by', 'updated_by', 'attachments', 'attachments.attachment'],
            });
            if (!sale) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.SALES.GET_BY_ID.CODE,
                    message: utils_1.API_RESPONSE.ERROR.SALES.GET_BY_ID.MESSAGE,
                    data: null,
                };
            }
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.SALES.GET_BY_ID.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.SALES.GET_BY_ID.MESSAGE,
                data: sale,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.SALES.GET_BY_ID.CODE,
                message: utils_1.API_RESPONSE.ERROR.SALES.GET_BY_ID.MESSAGE,
                data: error,
            };
        }
    }
    // ====== CREATE SALE ======
    async create(dto) {
        try {
            const createData = { ...dto };
            // Map relations
            if (dto.created_by_id)
                createData.created_by = { id: dto.created_by_id };
            if (dto.updated_by_id)
                createData.updated_by = { id: dto.updated_by_id };
            createData.monitoring = { id: dto.monitoring_id };
            // Remove raw ID fields
            delete createData.created_by_id;
            delete createData.updated_by_id;
            delete createData.monitoring_id;
            const newSale = this.salesRepo.create(createData);
            await this.salesRepo.save(newSale);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.SALES.CREATE.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.SALES.CREATE.MESSAGE,
                data: newSale,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.SALES.CREATE.CODE,
                message: utils_1.API_RESPONSE.ERROR.SALES.CREATE.MESSAGE,
                data: error,
            };
        }
    }
    // ====== UPDATE SALE ======
    async update(dto) {
        try {
            const sale = await this.salesRepo.findOne({ where: { id: dto.id } });
            if (!sale) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.SALES.UPDATE.CODE,
                    message: utils_1.API_RESPONSE.ERROR.SALES.UPDATE.MESSAGE,
                    data: null,
                };
            }
            const updateData = (0, utils_1.prepareUpdateFields)(dto, { updated_by_id: 'updated_by' });
            // Map relation if present
            if (dto.monitoring_id)
                updateData.monitoring = { id: dto.monitoring_id };
            Object.assign(sale, updateData);
            await this.salesRepo.save(sale);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.SALES.UPDATE.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.SALES.UPDATE.MESSAGE,
                data: sale,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.SALES.UPDATE.CODE,
                message: utils_1.API_RESPONSE.ERROR.SALES.UPDATE.MESSAGE,
                data: error,
            };
        }
    }
    // ====== SOFT DELETE SALE ======
    async softDelete(dto) {
        try {
            const sale = await this.salesRepo.findOne({ where: { id: dto.id } });
            if (!sale) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.SALES.DELETE.CODE,
                    message: utils_1.API_RESPONSE.ERROR.SALES.DELETE.MESSAGE,
                    data: null,
                };
            }
            sale.status = interface_1.SalesStatus.DELETED;
            await this.salesRepo.save(sale);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.SALES.DELETE.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.SALES.DELETE.MESSAGE,
                data: sale,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.SALES.DELETE.CODE,
                message: utils_1.API_RESPONSE.ERROR.SALES.DELETE.MESSAGE,
                data: error,
            };
        }
    }
    // ====== CREATE SALE ATTACHMENT ======
    async createSalesAttachment(dto) {
        try {
            const createData = {
                status: dto.status,
                sale: { id: dto.sales_id },
                attachment: { id: dto.attachment_id },
            };
            const newAttachment = this.salesAttachmentsRepo.create(createData);
            await this.salesAttachmentsRepo.save(newAttachment);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.SALES_ATTACHMENT.CREATE.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.SALES_ATTACHMENT.CREATE.MESSAGE,
                data: newAttachment,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.SALES_ATTACHMENT.CREATE.CODE,
                message: utils_1.API_RESPONSE.ERROR.SALES_ATTACHMENT.CREATE.MESSAGE,
                data: error,
            };
        }
    }
    // ====== UPDATE SALE ATTACHMENT ======
    async updateSalesAttachment(dto) {
        try {
            const attachment = await this.salesAttachmentsRepo.findOne({
                where: { sale: { id: dto.sales_id }, attachment: { id: dto.attachment_id } },
            });
            if (!attachment) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.SALES_ATTACHMENT.UPDATE.CODE,
                    message: utils_1.API_RESPONSE.ERROR.SALES_ATTACHMENT.UPDATE.MESSAGE,
                    data: null,
                };
            }
            attachment.status = dto.status;
            await this.salesAttachmentsRepo.save(attachment);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.SALES_ATTACHMENT.UPDATE.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.SALES_ATTACHMENT.UPDATE.MESSAGE,
                data: attachment,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.SALES_ATTACHMENT.UPDATE.CODE,
                message: utils_1.API_RESPONSE.ERROR.SALES_ATTACHMENT.UPDATE.MESSAGE,
                data: error,
            };
        }
    }
};
exports.SalesService = SalesService;
exports.SalesService = SalesService = SalesService_1 = tslib_1.__decorate([
    (0, common_1.Injectable)(),
    tslib_1.__param(0, (0, typeorm_1.InjectRepository)(dto_1.SalesEntity)),
    tslib_1.__param(1, (0, typeorm_1.InjectRepository)(dto_1.SaleAttachmentsEntity)),
    tslib_1.__metadata("design:paramtypes", [typeof (_a = typeof typeorm_2.Repository !== "undefined" && typeorm_2.Repository) === "function" ? _a : Object, typeof (_b = typeof typeorm_2.Repository !== "undefined" && typeorm_2.Repository) === "function" ? _b : Object])
], SalesService);


/***/ }),
/* 114 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SalesController = void 0;
const tslib_1 = __webpack_require__(4);
const common_1 = __webpack_require__(1);
const sales_service_1 = __webpack_require__(113);
const dto_1 = __webpack_require__(22);
const interface_1 = __webpack_require__(67);
const auth_guard_1 = __webpack_require__(105);
const roles_guard_1 = __webpack_require__(106);
const roles_decorator_1 = __webpack_require__(107);
const class_validator_1 = __webpack_require__(24);
class UpdateSaleStatusDto {
}
tslib_1.__decorate([
    (0, class_validator_1.IsUUID)(),
    tslib_1.__metadata("design:type", String)
], UpdateSaleStatusDto.prototype, "id", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsEnum)(interface_1.SalesStatus),
    tslib_1.__metadata("design:type", typeof (_a = typeof interface_1.SalesStatus !== "undefined" && interface_1.SalesStatus) === "function" ? _a : Object)
], UpdateSaleStatusDto.prototype, "status", void 0);
tslib_1.__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    tslib_1.__metadata("design:type", String)
], UpdateSaleStatusDto.prototype, "updated_by_id", void 0);
let SalesController = class SalesController {
    constructor(salesService) {
        this.salesService = salesService;
    }
    // ====== GET ALL SALES ======
    async getAll() {
        return this.salesService.getAll();
    }
    // ====== GET SALES FOR SUPERVISOR ======
    async getForSupervisor() {
        return this.salesService.getForSupervisor();
    }
    // ====== GET SALES BY USER ID ======
    async getByUserId(userId) {
        return this.salesService.getByUserId(userId);
    }
    // ====== GET SALE BY ID ======
    async getById(id) {
        return this.salesService.getById(id);
    }
    // ====== CREATE SALE ======
    async create(dto) {
        return this.salesService.create(dto);
    }
    // ====== UPDATE STATUS (management + supervisor only) ======
    async updateStatus(dto) {
        return this.salesService.updateStatus(dto.id, dto.status, dto.updated_by_id);
    }
    // ====== UPDATE SALE (all roles) ======
    async update(dto) {
        return this.salesService.update(dto);
    }
    // ====== SOFT DELETE SALE ======
    async softDelete(dto) {
        return this.salesService.softDelete(dto);
    }
    // ====== CREATE SALE ATTACHMENT ======
    async createAttachment(dto) {
        return this.salesService.createSalesAttachment(dto);
    }
    // ====== UPDATE SALE ATTACHMENT ======
    async updateAttachment(dto) {
        return this.salesService.updateSalesAttachment(dto);
    }
};
exports.SalesController = SalesController;
tslib_1.__decorate([
    (0, common_1.Get)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", typeof (_c = typeof Promise !== "undefined" && Promise) === "function" ? _c : Object)
], SalesController.prototype, "getAll", null);
tslib_1.__decorate([
    (0, common_1.Get)('supervisor'),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", typeof (_d = typeof Promise !== "undefined" && Promise) === "function" ? _d : Object)
], SalesController.prototype, "getForSupervisor", null);
tslib_1.__decorate([
    (0, common_1.Get)('user/:userId'),
    tslib_1.__param(0, (0, common_1.Param)('userId')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [String]),
    tslib_1.__metadata("design:returntype", typeof (_e = typeof Promise !== "undefined" && Promise) === "function" ? _e : Object)
], SalesController.prototype, "getByUserId", null);
tslib_1.__decorate([
    (0, common_1.Get)(':id'),
    tslib_1.__param(0, (0, common_1.Param)('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [String]),
    tslib_1.__metadata("design:returntype", typeof (_f = typeof Promise !== "undefined" && Promise) === "function" ? _f : Object)
], SalesController.prototype, "getById", null);
tslib_1.__decorate([
    (0, common_1.Post)(),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [typeof (_g = typeof dto_1.CreateSalesDto !== "undefined" && dto_1.CreateSalesDto) === "function" ? _g : Object]),
    tslib_1.__metadata("design:returntype", typeof (_h = typeof Promise !== "undefined" && Promise) === "function" ? _h : Object)
], SalesController.prototype, "create", null);
tslib_1.__decorate([
    (0, common_1.Patch)('update-status'),
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard, roles_guard_1.RolesGuard),
    (0, roles_decorator_1.Roles)(interface_1.UserRole.MANAGEMENT, interface_1.UserRole.SUPERVISOR),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [UpdateSaleStatusDto]),
    tslib_1.__metadata("design:returntype", typeof (_j = typeof Promise !== "undefined" && Promise) === "function" ? _j : Object)
], SalesController.prototype, "updateStatus", null);
tslib_1.__decorate([
    (0, common_1.Patch)(),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [typeof (_k = typeof dto_1.UpdateSalesDto !== "undefined" && dto_1.UpdateSalesDto) === "function" ? _k : Object]),
    tslib_1.__metadata("design:returntype", typeof (_l = typeof Promise !== "undefined" && Promise) === "function" ? _l : Object)
], SalesController.prototype, "update", null);
tslib_1.__decorate([
    (0, common_1.Patch)('soft-delete'),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [typeof (_m = typeof dto_1.UpdateSalesDto !== "undefined" && dto_1.UpdateSalesDto) === "function" ? _m : Object]),
    tslib_1.__metadata("design:returntype", typeof (_o = typeof Promise !== "undefined" && Promise) === "function" ? _o : Object)
], SalesController.prototype, "softDelete", null);
tslib_1.__decorate([
    (0, common_1.Post)('attachments'),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [typeof (_p = typeof dto_1.CreateSaleAttachmentsDto !== "undefined" && dto_1.CreateSaleAttachmentsDto) === "function" ? _p : Object]),
    tslib_1.__metadata("design:returntype", typeof (_q = typeof Promise !== "undefined" && Promise) === "function" ? _q : Object)
], SalesController.prototype, "createAttachment", null);
tslib_1.__decorate([
    (0, common_1.Patch)('attachments'),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [typeof (_r = typeof dto_1.UpdateSaleAttachmentsDto !== "undefined" && dto_1.UpdateSaleAttachmentsDto) === "function" ? _r : Object]),
    tslib_1.__metadata("design:returntype", typeof (_s = typeof Promise !== "undefined" && Promise) === "function" ? _s : Object)
], SalesController.prototype, "updateAttachment", null);
exports.SalesController = SalesController = tslib_1.__decorate([
    (0, common_1.Controller)('sales'),
    tslib_1.__metadata("design:paramtypes", [typeof (_b = typeof sales_service_1.SalesService !== "undefined" && sales_service_1.SalesService) === "function" ? _b : Object])
], SalesController);


/***/ }),
/* 115 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UsersModule = void 0;
const tslib_1 = __webpack_require__(4);
const common_1 = __webpack_require__(1);
const users_service_1 = __webpack_require__(116);
const users_controller_1 = __webpack_require__(117);
const dto_1 = __webpack_require__(22);
const typeorm_1 = __webpack_require__(21);
const guards_module_1 = __webpack_require__(108);
const supabase_module_1 = __webpack_require__(9);
let UsersModule = class UsersModule {
};
exports.UsersModule = UsersModule;
exports.UsersModule = UsersModule = tslib_1.__decorate([
    (0, common_1.Module)({
        controllers: [users_controller_1.UsersController],
        providers: [users_service_1.UsersService],
        imports: [typeorm_1.TypeOrmModule.forFeature([dto_1.UsersEntity]), guards_module_1.GuardsModule, supabase_module_1.SupabaseModule],
        exports: [users_service_1.UsersService],
    })
], UsersModule);


/***/ }),
/* 116 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var UsersService_1;
var _a;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UsersService = void 0;
const tslib_1 = __webpack_require__(4);
const dto_1 = __webpack_require__(22);
const interface_1 = __webpack_require__(67);
const utils_1 = __webpack_require__(11);
const common_1 = __webpack_require__(1);
const typeorm_1 = __webpack_require__(21);
const typeorm_2 = __webpack_require__(8);
let UsersService = UsersService_1 = class UsersService {
    constructor(usersRepo) {
        this.usersRepo = usersRepo;
        this.logger = new common_1.Logger(UsersService_1.name);
    }
    // ====== GET ALL USERS ======
    async getAll() {
        try {
            const users = await this.usersRepo.find({
                relations: [
                    'created_by',
                    'updated_by',
                    'attachment_signature',
                    'attachment_avatar',
                ],
            });
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.USERS.GET_ALL.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.USERS.GET_ALL.MESSAGE,
                data: users,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.USERS.GET_ALL.CODE,
                message: utils_1.API_RESPONSE.ERROR.USERS.GET_ALL.MESSAGE,
                data: error,
            };
        }
    }
    // ====== GET USER BY CREATOR/USER ID ======
    async getByUserId(userId) {
        try {
            const users = await this.usersRepo.find({
                where: { created_by: { id: userId } },
                relations: [
                    'created_by',
                    'updated_by',
                    'attachment_signature',
                    'attachment_avatar',
                ],
            });
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.USERS.GET_BY_ID.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.USERS.GET_BY_ID.MESSAGE,
                data: users,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.USERS.GET_BY_ID.CODE,
                message: utils_1.API_RESPONSE.ERROR.USERS.GET_BY_ID.MESSAGE,
                data: error,
            };
        }
    }
    // ====== GET USER BY ID ======
    async getById(id) {
        try {
            const user = await this.usersRepo.findOne({
                where: { id },
                relations: [
                    'created_by',
                    'updated_by',
                    'attachment_signature',
                    'attachment_avatar',
                ],
            });
            if (!user) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.USERS.GET_BY_ID.CODE,
                    message: utils_1.API_RESPONSE.ERROR.USERS.GET_BY_ID.MESSAGE,
                    data: null,
                };
            }
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.USERS.GET_BY_ID.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.USERS.GET_BY_ID.MESSAGE,
                data: user,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.USERS.GET_BY_ID.CODE,
                message: utils_1.API_RESPONSE.ERROR.USERS.GET_BY_ID.MESSAGE,
                data: error,
            };
        }
    }
    // ====== CREATE USER ======
    async create(dto) {
        try {
            const createData = { ...dto };
            // Map relations
            if (dto.created_by_id)
                createData.created_by = { id: dto.created_by_id };
            if (dto.updated_by_id)
                createData.updated_by = { id: dto.updated_by_id };
            if (dto.attachment_signature_id)
                createData.attachment_signature = { id: dto.attachment_signature_id };
            if (dto.attachment_avatar_id)
                createData.attachment_avatar = { id: dto.attachment_avatar_id };
            // Remove raw ID fields
            delete createData.created_by_id;
            delete createData.updated_by_id;
            delete createData.attachment_signature_id;
            delete createData.attachment_avatar_id;
            const newUser = this.usersRepo.create(createData);
            await this.usersRepo.save(newUser);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.USERS.CREATE.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.USERS.CREATE.MESSAGE,
                data: newUser,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.USERS.CREATE.CODE,
                message: utils_1.API_RESPONSE.ERROR.USERS.CREATE.MESSAGE,
                data: error,
            };
        }
    }
    // ====== UPDATE USER ======
    async update(dto) {
        try {
            const user = await this.usersRepo.findOne({ where: { id: dto.id } });
            if (!user) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.USERS.UPDATE.CODE,
                    message: utils_1.API_RESPONSE.ERROR.USERS.UPDATE.MESSAGE,
                    data: null,
                };
            }
            const updateData = (0, utils_1.prepareUpdateFields)(dto, { updated_by_id: 'updated_by' });
            // Map relations
            if (dto.attachment_signature_id)
                updateData.attachment_signature = { id: dto.attachment_signature_id };
            if (dto.attachment_avatar_id)
                updateData.attachment_avatar = { id: dto.attachment_avatar_id };
            Object.assign(user, updateData);
            await this.usersRepo.save(user);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.USERS.UPDATE.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.USERS.UPDATE.MESSAGE,
                data: user,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.USERS.UPDATE.CODE,
                message: utils_1.API_RESPONSE.ERROR.USERS.UPDATE.MESSAGE,
                data: error,
            };
        }
    }
    // ====== SOFT DELETE USER ======
    async softDelete(dto) {
        try {
            const user = await this.usersRepo.findOne({ where: { id: dto.id } });
            if (!user) {
                return {
                    status: interface_1.ApiResponseStatus.ERROR,
                    code: utils_1.API_RESPONSE.ERROR.USERS.DELETE.CODE,
                    message: utils_1.API_RESPONSE.ERROR.USERS.DELETE.MESSAGE,
                    data: null,
                };
            }
            // Soft delete by setting status to inactive/deleted
            user.status = interface_1.UserStatus.DELETED;
            await this.usersRepo.save(user);
            return {
                status: interface_1.ApiResponseStatus.SUCCESS,
                code: utils_1.API_RESPONSE.SUCCESS.USERS.DELETE.CODE,
                message: utils_1.API_RESPONSE.SUCCESS.USERS.DELETE.MESSAGE,
                data: user,
            };
        }
        catch (error) {
            this.logger.error(error.message, error.stack);
            return {
                status: interface_1.ApiResponseStatus.ERROR,
                code: utils_1.API_RESPONSE.ERROR.USERS.DELETE.CODE,
                message: utils_1.API_RESPONSE.ERROR.USERS.DELETE.MESSAGE,
                data: error,
            };
        }
    }
};
exports.UsersService = UsersService;
exports.UsersService = UsersService = UsersService_1 = tslib_1.__decorate([
    (0, common_1.Injectable)(),
    tslib_1.__param(0, (0, typeorm_1.InjectRepository)(dto_1.UsersEntity)),
    tslib_1.__metadata("design:paramtypes", [typeof (_a = typeof typeorm_2.Repository !== "undefined" && typeorm_2.Repository) === "function" ? _a : Object])
], UsersService);


/***/ }),
/* 117 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UsersController = void 0;
const tslib_1 = __webpack_require__(4);
const common_1 = __webpack_require__(1);
const users_service_1 = __webpack_require__(116);
const dto_1 = __webpack_require__(22);
const interface_1 = __webpack_require__(67);
const auth_guard_1 = __webpack_require__(105);
const roles_guard_1 = __webpack_require__(106);
const roles_decorator_1 = __webpack_require__(107);
let UsersController = class UsersController {
    constructor(usersService) {
        this.usersService = usersService;
    }
    // ====== GET ALL USERS (management only) ======
    async getAll() {
        return this.usersService.getAll();
    }
    // ====== GET USERS BY CREATOR/USER ID ======
    async getByUserId(userId) {
        return this.usersService.getByUserId(userId);
    }
    // ====== GET USER BY ID ======
    async getById(id) {
        return this.usersService.getById(id);
    }
    // ====== CREATE USER (management only) ======
    async create(dto) {
        return this.usersService.create(dto);
    }
    // ====== UPDATE USER ======
    async update(dto) {
        return this.usersService.update(dto);
    }
    // ====== SOFT DELETE USER (management only) ======
    async softDelete(dto) {
        return this.usersService.softDelete(dto);
    }
};
exports.UsersController = UsersController;
tslib_1.__decorate([
    (0, common_1.Get)(),
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard, roles_guard_1.RolesGuard),
    (0, roles_decorator_1.Roles)(interface_1.UserRole.MANAGEMENT),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", typeof (_b = typeof Promise !== "undefined" && Promise) === "function" ? _b : Object)
], UsersController.prototype, "getAll", null);
tslib_1.__decorate([
    (0, common_1.Get)('user/:userId'),
    tslib_1.__param(0, (0, common_1.Param)('userId')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [String]),
    tslib_1.__metadata("design:returntype", typeof (_c = typeof Promise !== "undefined" && Promise) === "function" ? _c : Object)
], UsersController.prototype, "getByUserId", null);
tslib_1.__decorate([
    (0, common_1.Get)(':id'),
    tslib_1.__param(0, (0, common_1.Param)('id')),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [String]),
    tslib_1.__metadata("design:returntype", typeof (_d = typeof Promise !== "undefined" && Promise) === "function" ? _d : Object)
], UsersController.prototype, "getById", null);
tslib_1.__decorate([
    (0, common_1.Post)(),
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard, roles_guard_1.RolesGuard),
    (0, roles_decorator_1.Roles)(interface_1.UserRole.MANAGEMENT),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [typeof (_e = typeof dto_1.CreateUser !== "undefined" && dto_1.CreateUser) === "function" ? _e : Object]),
    tslib_1.__metadata("design:returntype", typeof (_f = typeof Promise !== "undefined" && Promise) === "function" ? _f : Object)
], UsersController.prototype, "create", null);
tslib_1.__decorate([
    (0, common_1.Patch)(),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [typeof (_g = typeof dto_1.UpdateUser !== "undefined" && dto_1.UpdateUser) === "function" ? _g : Object]),
    tslib_1.__metadata("design:returntype", typeof (_h = typeof Promise !== "undefined" && Promise) === "function" ? _h : Object)
], UsersController.prototype, "update", null);
tslib_1.__decorate([
    (0, common_1.Patch)('soft-delete'),
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard, roles_guard_1.RolesGuard),
    (0, roles_decorator_1.Roles)(interface_1.UserRole.MANAGEMENT),
    tslib_1.__param(0, (0, common_1.Body)()),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [typeof (_j = typeof dto_1.UpdateUser !== "undefined" && dto_1.UpdateUser) === "function" ? _j : Object]),
    tslib_1.__metadata("design:returntype", typeof (_k = typeof Promise !== "undefined" && Promise) === "function" ? _k : Object)
], UsersController.prototype, "softDelete", null);
exports.UsersController = UsersController = tslib_1.__decorate([
    (0, common_1.Controller)('users'),
    tslib_1.__metadata("design:paramtypes", [typeof (_a = typeof users_service_1.UsersService !== "undefined" && users_service_1.UsersService) === "function" ? _a : Object])
], UsersController);


/***/ }),
/* 118 */
/***/ ((module) => {

module.exports = require("@nestjs/config");

/***/ }),
/* 119 */
/***/ ((module) => {

module.exports = require("@nestjs/swagger");

/***/ })
/******/ 	]);
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
(() => {
var exports = __webpack_exports__;

/**
 * This is not a production server yet!
 * This is only a minimal backend to get started.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
const common_1 = __webpack_require__(1);
const core_1 = __webpack_require__(2);
const app_module_1 = __webpack_require__(3);
const utils_1 = __webpack_require__(11);
const swagger_1 = __webpack_require__(119);
async function bootstrap() {
    const app = await core_1.NestFactory.create(app_module_1.AppModule);
    const globalPrefix = 'api';
    const swaggerPrefix = 'api-docs';
    app.setGlobalPrefix(globalPrefix);
    // Enable CORS
    app.enableCors({
        origin: utils_1.ALLOWED_CORS_ORIGINS,
        methods: 'GET,HEAD,PUT,PATCH,POST,DELETE',
        allowedHeaders: 'Content-Type,Authorization',
        credentials: true,
    });
    // Enable validation globally
    app.useGlobalPipes(new common_1.ValidationPipe({
        transform: true,
        whitelist: true,
        forbidNonWhitelisted: true,
    }));
    // =========== Swagger setup ===========
    const config = new swagger_1.DocumentBuilder()
        .setTitle('API Documentation')
        .setDescription('API documentation for the application')
        .setVersion('1.0')
        .addBearerAuth()
        .build();
    const document = swagger_1.SwaggerModule.createDocument(app, config);
    swagger_1.SwaggerModule.setup(swaggerPrefix, app, document, {
        swaggerOptions: {
            deepLinking: false,
        },
        customSiteTitle: 'API Docs',
    });
    const port = process.env.PORT || 3000;
    await app.listen(port, '0.0.0.0');
    common_1.Logger.log(`🚀 Swagger setup at: http://localhost:${port}/${swaggerPrefix}`);
    common_1.Logger.log(`🚀 Application is running on: http://localhost:${port}/${globalPrefix}`);
}
bootstrap();

})();

/******/ })()
;
//# sourceMappingURL=main.js.map